<?php

class RequestHelper
{

    /**
     * @param string $name
     * @param mixed $default
     * @param array $allowed
     * @return mixed
     */
    public static function getGetVariable($name, $default = null, $allowed = null)
    {
        return self::getPostHelper($_GET, $name, $default, $allowed);
    }    

    /**
     * @param string $name
     * @param mixed $default
     * @param array $allowed
     * @return mixed
     */
    public static function getPostVariable($name, $default = null, $allowed = null)
    {
        return self::getPostHelper($_POST, $name, $default, $allowed);
    }

    /**
     * @param array $data
     * @param string $name
     * @param mixed $default
     * @param array $allowed
     * @return mixed
     */
    protected static function getPostHelper($data, $name, $default, $allowed)
    {
        $val =  isset($data[$name]) ? $data[$name] : $default;
        if ($allowed && !in_array($val, $allowed)) {
            return $default;
        }

        return $val;
    }

    /**
     * @param array $data
     */
    public static function returnJson($data){
        header('Content-type: application/json');
        echo json_encode($data);
    }
}