<?php

class SequenceModel extends BaseModel
{
    const STATUS_BIJGESCHREVEN = 'bijgeschreven';
    const STATUS_GESTORNEERD = 'gestorneerd';
    const STATUS_TERUGBETAALD = 'terugbetaald';
    const STATUS_TERUGBETALEN = 'terugbetalen';
    const STATUS_GEANNULEERD = 'geannuleerd';
    const STATUS_OVERBOEKING_AANGELEVERD = 'overboeking_aangeleverd';
    const STATUS_OVERBOEKING_BEVESTIGD = 'overboeking_bevestigd';

    /**
     * The db id
     * @var int
     */
    protected $id;

    /**
     * @var SaleModel
     */
    protected $sale;

    /**
     * @var TransactionModel[]
     */
    protected $transactions;

    /**
     * @var InternalTransactionModel[]
     */
    protected $internalTransactions;

    /**
     * @var int
     */
    protected $saleId;

    /**
     * @var int
     */
    protected $amount;

    /**
     * @var string
     */
    protected $currentStatus;

    /**
     * @var int
     */
    protected $amountAffiliate;

    /**
     * @var int
     */
    protected $sequenceNumber;

    /**
     * @var DateTime
     */
    protected $date;

    /**
     * @var DateTime
     */
    protected $creditDate;

    /**
     * @var array
     */
    protected $originalData;

    /**
     * @var DateTime
     */
    protected $createdAt;

    /**
     * @var DateTime
     */
    protected $updatedAt;

    /**
     * SequenceModel constructor.
     *
     * @param array $data
     */
    public function __construct($data)
    {
        $this->originalData = $data;

        $this->sequenceNumber = (int)$data['sequence_number'];
        $this->creditDate = ModelHelper::fromPayproDate($data['credit_date']);
        $this->currentStatus = $data['current_status'];
        $this->amountAffiliate = (int)$data['amount_affiliate'];
        $this->saleId = ModelHelper::fixPayproId($data['id']);
        $this->amount = (int)$data['amount'];
        $this->date = ModelHelper::fromPayproDate($data['date']);
    }

    /**
     * @return SaleModel
     */
    public function getSale()
    {
        return $this->sale;
    }

    /**
     * @param SaleModel $sale
     */
    public function setSale($sale)
    {
        $this->sale = $sale;
    }

    /**
     * @return TransactionModel[]
     */
    public function getTransactions()
    {
        return $this->transactions;
    }

    /**
     * @param TransactionModel $transaction
     */
    public function addTransaction($transaction)
    {
        $this->transactions[] = $transaction;
    }

    /**
     * @param TransactionModel[] $transactions
     */
    public function setTransactions($transactions)
    {
        $this->transactions = $transactions;
    }

    /**
     * @return InternalTransactionModel[]
     */
    public function getInternalTransactions()
    {
        return $this->internalTransactions;
    }

    /**
     * @param InternalTransactionModel[] $internalTransactions
     */
    public function setInternalTransactions($internalTransactions)
    {
        $this->internalTransactions = $internalTransactions;
    }

    /**
     * @param InternalTransactionModel $internalTransaction
     */
    public function addInternalTransaction($internalTransaction)
    {
        $this->internalTransactions[] = $internalTransaction;
    }

    /**
     * @return int
     */
    public function getSaleId()
    {
        return $this->saleId;
    }

    /**
     * @param int $saleId
     */
    public function setSaleId($saleId)
    {
        $this->saleId = $saleId;
    }

    /**
     * @return int
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param int $amount
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
    }

    /**
     * @return string
     */
    public function getCurrentStatus()
    {
        return $this->currentStatus;
    }

    /**
     * @param string $currentStatus
     */
    public function setCurrentStatus($currentStatus)
    {
        $this->currentStatus = $currentStatus;
    }

    /**
     * @return int
     */
    public function getAmountAffiliate()
    {
        return $this->amountAffiliate;
    }

    /**
     * @param int $amountAffiliate
     */
    public function setAmountAffiliate($amountAffiliate)
    {
        $this->amountAffiliate = $amountAffiliate;
    }

    /**
     * @return int
     */
    public function getSequenceNumber()
    {
        return $this->sequenceNumber;
    }

    /**
     * @param int $sequenceNumber
     */
    public function setSequenceNumber($sequenceNumber)
    {
        $this->sequenceNumber = $sequenceNumber;
    }

    /**
     * @return bool
     */
    public function isFirstSequence()
    {
        return $this->sequenceNumber == 1;
    }

    /**
     * @return DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param DateTime $date
     */
    public function setDate($date)
    {
        $this->date = $date;
    }

    /**
     * @return DateTime
     */
    public function getCreditDate()
    {
        return $this->creditDate;
    }

    /**
     * @param DateTime $creditDate
     */
    public function setCreditDate($creditDate)
    {
        $this->creditDate = $creditDate;
    }

    /**
     * @return array
     */
    public function getOriginalData()
    {
        return $this->originalData;
    }

    /**
     * @param array $originalData
     */
    public function setOriginalData($originalData)
    {
        $this->originalData = $originalData;
    }

    public function isBijgeschreven()
    {
        return $this->currentStatus === self::STATUS_BIJGESCHREVEN;
    }

    /**
     * @return TransactionModel | null
     */
    public function getFirstTransaction()
    {
        return $this->getTransactionByIndex(0);
    }

    /**
     * @return TransactionModel | null
     */
    public function getSecondTransaction()
    {
        return $this->getTransactionByIndex(1);
    }

    /**
     * @return TransactionModel | null
     */
    public function getThirdTransaction()
    {
        return $this->getTransactionByIndex(2);
    }

    /**
     * @return TransactionModel | null
     */
    public function getFourthTransaction()
    {
        return $this->getTransactionByIndex(3);
    }

    /**
     * @param $index
     * @return TransactionModel | null
     */
    public function getTransactionByIndex($index)
    {
        $transactions = $this->getTransactions();

        return is_array($transactions) && isset($transactions[$index]) ? $transactions[$index] : null;
    }

    public function getTransactionsCount()
    {
        return count($this->transactions);
    }
}