<?php

namespace Senh\Lib\Prices;

use \DateTime;

class KortingModel
{

    /**
     * @var string
     */
    protected $code;

    /**
     * @var int uren
     */
    protected $duur;

    /**
     * @var array: productId => korting in centen
     */
    protected $kortingen1;
    
    /**
     * @var array: productId => korting in centen
     */
    protected $kortingenN;

    /**
     * @var array
     */
    protected $allowedProductIds;
    
    /**
     * @var array
     */
    protected $commissions1;
 
    /**
     * @var array
     */
    protected $commissionsN;

    /**
     * @var DateTime
     */
    protected $datumStop;

    /**
     * KortingModel constructor.
     *
     * @param string $code
     * @param int $duur
     * @param int|array $korting1, if int, korting geldt voor alle producten, if array, dan associatief met (int)productId => (int)korting
     * @param int|array $korting2, if int, korting geldt voor alle producten, if array, dan associatief met (int)productId => (int)korting
     * @param array $allowedProductIds
     */
    public function __construct($code, $duur, $korting1, $kortingN, $allowedProductIds = array(), $commissions1 = array(), $commissionsN = array())
    {
        $kortingen1 = $korting1;
        if (!is_array($korting1)) {
            $kortingen1 = array();
            foreach ($allowedProductIds as $productId) {
                $kortingen1[$productId] = $korting1;
            }
        }
        
        $kortingenN = $kortingN;
        if (!is_array($kortingN)) {
            $kortingenN = array();
            foreach ($allowedProductIds as $productId) {
                $kortingenN[$productId] = $kortingN;
            }
        }
        $this->code = $code;
        $this->duur = $duur;
        $this->kortingen1 = $kortingen1;
        $this->kortingenN = $kortingenN;
        $this->allowedProductIds = $allowedProductIds;
        $this->commissions1 = $commissions1;
        $this->commissionsN = $commissionsN;
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @return int
     */
    public function getDuur()
    {
        return $this->duur;
    }

    /**
     * @param $productId
     * @return int|null
     */
    public function getKorting1($productId)
    {
        return isset($this->kortingen1[$productId]) ? $this->kortingen1[$productId] : null;
    }
    
    /**
     * @param $productId
     * @return int|null
     */
    public function getKortingN($productId)
    {
        return isset($this->kortingenN[$productId]) ? $this->kortingenN[$productId] : null;
    }

    /**
     * @return array
     */
    public function getAllowedProductIds()
    {
        return $this->allowedProductIds;
    }

    /**
     * @return array
     */
    public function getCommissions1()
    {
        return $this->commissions1;
    }
    
    /**
     * @param int $productId
     * @return int
     */
    public function getCommission1($productId) {
        if (isset($this->commissions1[$productId])) {
	        return $this->commissions1[$productId];
        }
        return false;
    }
 
    /**
     * @param int $productId
     * @return int
     */
    public function getCommissionN($productId) {
        if (isset($this->commissionsN[$productId])) {
	        return $this->commissionsN[$productId];
        }
        return false;
    }

    /**
     * @param int $productId
     * @return bool
     */
    public function hasAllowedProductId($productId) {
        foreach ($this->allowedProductIds as $allowedProductId) {
            if ($productId == $allowedProductId) {
                return true;
            }
        }

        return false;
    }

    /**
     * @param array $productIds
     * @return bool
     */
    public function hasAllowedProductIds($productIds) {
        foreach ($productIds as $productId) {
            if (! $this->hasAllowedProductId($productId)) {
                return false;
            }
        }

        return true;
    }

    /**
     * @return DateTime
     */
    public function getDatumStop()
    {
        return $this->datumStop;
    }

    /**
     * @param DateTime $datumStop
     */
    public function setDatumStop($datumStop)
    {
        $this->datumStop = $datumStop;
    }

    /**
     * @return bool
     */
    public function isFutureDatumStop()
    {
        return $this->datumStop->getTimestamp() > time();
    }
}