<?php
session_start();

use Senh\Lib\NextSell\NextSellHelper;

/**
 * @var \DI\Container $container;
 */
global $container;
$nextSellHelper = $container->get(NextSellHelper::class);

//if (!isset($_SESSION['sale'])) die();

$paymentTestMode = defined('PAYMENT_TEST_MODE') && PAYMENT_TEST_MODE === true;

if (isset($_POST['sale_id']) && $_POST['sale_id'] != $_SESSION['sale_id']) {
?><script>alert('Er ging iets fout, probeer het nog eens.');history.go(-1);</script><?php
	die();
}

if (!function_exists('get_sale')) { 
	function get_sale() {
		return $_SESSION['sale'][$_SESSION['sale_id']];
	}
}
//if ($_GET['test']) { print_r(get_sale()); die(); }
//$sale = $_SESSION['sale'];
$sale = get_sale() ?: die();
$sale['IssuerID'] = $sale['IssuerID'] ?: $_POST['IssuerID'];
$sale['name'] = $sale['name'] ?: $_POST['name'];
$sale['email'] = $sale['email'] ?: $_POST['email'];
$sale['payment_system'] = $sale['payment_system'] ?: $_POST['payment_system'];
$sale['iban'] = $_POST['iban'] ? str_replace(' ', '', $_POST['iban']) : null;
$sale['order_quantity'] = isset($_POST['quantity']) ? ($_POST['quantity'] ?: 1) : 1;

// consumer address
$sale['consumer_address'] = $_POST['address'];
$sale['consumer_postal'] = str_replace(' ', '', $_POST['postal']);
$sale['consumer_city'] = $_POST['city'];
$sale['consumer_country'] = $_POST['country'];

// insert fake consumer address when no address has been posted
if (!isset($_POST['address'])) {
	$sale['consumer_address'] = 'Adres 99';
	$sale['consumer_postal'] = '1234AB';
	$sale['consumer_city'] = 'Plaats';

	$ipdat = @json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip=" . ($_SERVER['HTTP_X_FORWARDED_FOR'] ?: $_SERVER['REMOTE_ADDR'])));
	$country = @$ipdat->geoplugin_countryName ?: 'unknown';
	$sale['consumer_country'] = $country;
    $is_product_payment = false;
} else {
	// enable product payment when requiring personal data like address for sending a physical product
	$is_product_payment = true;
}

// paypal-termijnen2 is creditcard payment with paypal
if ($sale['payment_system'] == 'paypal-termijnen2') {
	$sale['payment_system'] = 'paypal-termijnen';
}

do_iban_check($sale['iban']);

// do some product updates
senh_update_product_subscription($sale['productID'], array(
	'price_1' => $sale['price']*$sale['order_quantity'], 
	'price_n' => $sale['price_memb'], 
	'number_of_periods' => $sale['number_of_periods'], 
	'time_type' => $sale['time_type'], 
	'time_multiplier' => $sale['time_multiplier'], 
	'initiate_with_ideal' => $sale['payment_system'] == 'doorlopende-machtiging' ? 'false' : 'true', 
	'initiate_with_bancontact' => $sale['payment_system'] == 'mistercash' ? 'true' : 'false', 
	'affiliate_commission_1' => $sale['aff_comm_onetime']*$sale['order_quantity'], 
	'affiliate_commission_n' => $sale['aff_comm_memb']
));


$consumer_data = array(
	'name' => $sale['name'], 
	'email' => $sale['email'],
	'accountno' => $sale['iban'],
	'address' => $sale['consumer_address'],
	'postal' => $sale['consumer_postal'],
	'city' => $sale['consumer_city'],
	'country' => $sale['consumer_country'],
	'vat' => isset($is_product_payment) && $is_product_payment == true ? 6 : 21, // vat is corrected in the postback url
	'amount' => $sale['price']*$sale['order_quantity'],
	'order_quantity' => $sale['order_quantity']
);

$postbackUrl = isset($sale['postback_url']) ? $sale['postback_url'] : POSTBACK_URL_DEFAULT;

@require_once('/home/salespages/domains/senhpayments.nl/public_html/abandoning/abandoning.php');
@$abandoning = new abandoning();
@$abandoning->add_abandoning($sale['email'],$sale['name'],$_SERVER["HTTP_HOST"]);
@$abandoning->set_cookie($sale['email'], $sale['productName']);

@$nextSellHelper->saveCheckoutData($_SESSION['sale_id'], $sale, $consumer_data, $pay_method);

// override payment_system with issuerid
if ($sale['payment_system'] == 'ideal' || $sale['payment_method'] == 'ideal') {
	$sale['payment_system'] = $sale['IssuerID'] = $sale['IssuerID'] ?: $sale['ideal_issuer'];
}

$pay_method = senh_get_paypro_membership_pay_method($sale['payment_system']);
if ($pay_method == 'bancontact/mrcash') {
	$sale['payment_system'] = 'bancontact';
	senh_blackhole_api($sale, $paymentTestMode);
} else if ($pay_method == 'idealabbo') {

	// use old api
	// there are no iDEAL codes available in the new API for recurring payments

	echo '
	<form id="form" method="post" action="https://www.paypro.nl/pay/">
	   <input type="hidden" name="account" value="5289" />
	   <input type="hidden" name="name" value="'.$sale['name'].'" />
	   <input type="hidden" name="email" value="'.$sale['email'].'" />
	   <input type="hidden" name="vat" value="'.$consumer_data['vat'].'" />

	   <input type="hidden" name="consumer_address" value="' . $sale['consumer_address'] . '" />
	   <input type="hidden" name="consumer_postal" value="' . $sale['consumer_postal'] . '" />
	   <input type="hidden" name="consumer_city" value="' . $sale['consumer_city'] . '" />
	   <input type="hidden" name="consumer_country" value="' . senh_parse_countrycode($sale['consumer_country']) . '" />

	   <input type="hidden" name="product_id" value="'.$sale['productID'].'" />
	   <input type="hidden" name="product_naam" value="' . $sale['productName'] . '" />
	   <input type="hidden" name="product_omschrijving" value="' . $sale['productName'] . '" />
	   <input type="hidden" name="product_bedrag" value="' . number_format($sale['price']/100, 2, ',', '') . '" />
	   <input type="hidden" name="affiliate_bedrag" value="' . number_format($sale['aff_comm_onetime']/100, 2, ',', '') . '" />
	   <input type="hidden" name="product_return_url" id="product_return_url" value="' . $sale['return_url_memb'] . '" />
	   <input type="hidden" name="postback_url" id="postback_url" value="' .$postbackUrl. '" />
	   <input type="hidden" name="consumer_psp" id="consumer_psp" value="'.$sale['IssuerID'].'" />
	   <input type="hidden" name="test_mode" id="test_mode" value="'.$paymentTestMode.'" />
	   <input type="hidden" name="akkoord_termijnen" value="1" />
	</form>
	<script>document.getElementById("form").submit();</script>
	';

} else {
	if ($is_product_payment) {
		senh_do_product_payment(
            $sale['productID'],
            $sale['productName'],
            $pay_method,
            $consumer_data,
            $sale['return_url_onetime'],
            false,
            $postbackUrl,
            $paymentTestMode);
	} else {
		senh_do_payment(
            $sale['productID'],
            $sale['productName'],
            $pay_method,
            $consumer_data,
            $sale['return_url_onetime'],
            false,
            $postbackUrl,
            $paymentTestMode);
	}
}