<?php

function get_sale_defaults() {
    global $container;
    $urlStart = defined('DOMAIN') ? 'http://' . DOMAIN : 'https://afslankreceptenbijbel.nl';
    if (sale_id() == 'digital') {
        // digitaal product
        return array(
            'productID' => TEST_PRODUCT_ID_BOOK_DIGITAL,
            'productName' => 'digitaal',
            'return_url_onetime' => $urlStart. '/bedankt/Opt-ARB-zvl8qu9SP5QIgJAA5bs0uCqILypJNR89ckxqO23B/',
            'return_url_memb' => $urlStart . '/bedankt/Opt-ARB-HUAP-nDEl3RPTPlBBtwfeWZoUlhs162cYziWNuCrHmYSR/',
            'send_membership' => false,
            'number_of_periods' => '0', //(dit is de 4de waarde van update_product_subscription en als het 0 is het een doorlopend abonnement)
            'time_type' => 'month', // (week, maand, jaar)
            'time_multiplier' => '1', // (1, 2, 3 etc.)
            'custom' => ''
        );
    } elseif (sale_id() == 'variant'){
        // variant
        return array(
            'productID' => TEST_PRODUCT_ID_VARIANTS,
            'productName' => 'variant',
            'return_url_onetime' => $urlStart . '/bedankt/Opt-ARB-zvl8qu9SP5QIgJAA5bs0uCqILypJNR89ckxqO23B/',
            'return_url_memb' => $urlStart . '/bedankt/Opt-ARB-HUAP-nDEl3RPTPlBBtwfeWZoUlhs162cYziWNuCrHmYSR/',
            'send_membership' => false,
            'number_of_periods' => '0', //(dit is de 4de waarde van update_product_subscription en als het 0 is het een doorlopend abonnement)
            'time_type' => 'month', // (week, maand, jaar)
            'time_multiplier' => '1', // (1, 2, 3 etc.)
            'custom' => ''
        );
    } else {
        // 1 maand
        return array(
            'productID' => TEST_NO_INTERNAL_PRODUCT_MODEL,
            'productName' => 'No internal product',
            'price' => 1000,
            'price_memb' => '1997',
            'aff_comm_onetime' => 50,
            'aff_comm_memb' => 51,
            'return_url_onetime' => 'https://afslankreceptenbijbel.nl/bedankt/Opt-ARB-zvl8qu9SP5QIgJAA5bs0uCqILypJNR89ckxqO23B/',
            'return_url_onetime2' => 'https://afslankreceptenbijbel.nl/bedankt/Opt-ARB-zvl8qu9SP5QIgJAA5bs0uCqILypJNR89ckxqO23B/',
            'return_url_memb' => 'https://afslankreceptenbijbel.nl/bedankt/Opt-ARB-HUAP-nDEl3RPTPlBBtwfeWZoUlhs162cYziWNuCrHmYSR/',
            'return_url_memb2' => 'https://afslankreceptenbijbel.nl/bedankt/Opt-ARB-HUAP-nDEl3RPTPlBBtwfeWZoUlhs162cYziWNuCrHmYSR/',
            'postback_url_onetime' => 'http://senhpayments.nl/postbacks/pp/cec.php',
            'postback_url_memb' => 'http://senhpayments.nl/postbacks/pp/cec-ok.php',
            'send_membership' => false,
            'number_of_periods' => '0', //(dit is de 4de waarde van update_product_subscription en als het 0 is het een doorlopend abonnement)
            'time_type' => 'month', // (week, maand, jaar)
            'time_multiplier' => '1', // (1, 2, 3 etc.)
            'custom' => ''
        );
    }
}

require_once(__DIR__ . '/../../../src/gateways/sale.fn.php');
sale_bootstrap_multiple(['digital', 'no_internal_product', 'variant'], 'variant', [], 'b');