<?php
	
defined( 'ABSPATH' ) || exit;
// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}
// If class 'CCTimer' not exists.
if ( ! class_exists( 'CCTimer' ) ) {
	
	/**
	 * Sets up and initializes the CCTimer plugin.
	 *
	 * @since 1.0.0
	 */
	class CCTimer {
	
		private $defaults;
		
		public function __construct() {
		
			if(!get_option('CCTimer_init_tables')){
			
				$this->init_tables();
			}
			
			add_shortcode('addCCTimer', array( $this, 'render_tool'));
			
			add_action('init', array($this, 'init_data'));
			// add_action('admin_menu', array($this, 'init_admin_menu'));
			
			// add_action( 'wp_ajax_nopriv_CCTimer_showMoreEvents',  array( $this, 'showMoreEvents'));			
			// add_action( 'wp_ajax_CCTimer_showMoreEvents',  array( $this, 'showMoreEvents'));			
			
			add_action( 'wp_ajax_nopriv_CCTimer_update',  array( $this, 'update_timer'));			
			add_action( 'wp_ajax_CCTimer_update',  array( $this, 'update_timer'));
			
			add_action( 'wp_ajax_nopriv_CCTimer_add',  array( $this, 'add_timer'));			
			add_action( 'wp_ajax_CCTimer_add',  array( $this, 'add_timer'));
			
			// add_action('wp_head', array( $this, 'initScripts'));
			add_action('wp_footer', array( $this, 'initScripts'));
			
		}
		
		public function init_data(){	
			$uid = get_current_user_id();
			// print_r($this->get_timer($uid));die();
			
			if($uid != 0){
			
					// print_r($data);
				if(!isset($_COOKIE['CCTimer_'.$uid]) || isset($_COOKIE['CCTimer_'.$uid]) && $_COOKIE['CCTimer_'.$uid] == 0) {
				
					$data = $this->get_timer($uid);
					
					if(!empty($data)){						
						
						setcookie('CCTimerStatus_'.$uid, 'stored', time() + (86400 * 30), "/");
						setcookie('CCTimerKey_'.$uid, $data['timer_key'], time() + (86400 * 30), "/");
						setcookie('CCTimerVal_'.$uid, $data['timer_value'], time() + (86400 * 30), "/");
						setcookie('CCTimer_'.$uid, $data['timer_counter'], time() + (86400 * 30), "/");
					}
				}
			}
		}
		
		public function initScripts(){			
			
			$uid = get_current_user_id();
			
			if($uid != 0){
			
				?>
					<style>
						.CCTimer_baner{
							width;100%;
							min-height:165px;
							background-color: #F6C24A;
							padding:20px 0;
							text-align:center;
						}
						.CCTimer_baner p{
							font-family: "Montserrat", Sans-serif;
							font-size: 22px;
							font-weight: 400;
							line-height: 15px;
							color: #406A52;
							line-height: 1.2;
							margin-bottom: 0;
						}
						.CCTimer_baner_counter_box{
							text-align: center;
							margin-right: 8px;
							margin-left: 8px;
							padding: 8px 0px 10px 6px;
							border-radius: 20px 20px 20px 20px;
							background-color: #222222;
							min-height: 60px;
							display: inline-block;
							width: 130px;
													
						}
						.CCTimer_baner_counter_box div{
							color: #FFFFFF;
							font-family: "Roboto Slab", Sans-serif;
							font-size: 26px;
							font-weight: 400;
						}
						.CCTimer_baner_counter_box span{
						    font-family: "Roboto Slab", Sans-serif;
							font-size: 16px;
							font-weight: 400;
							color: #FFFFFF;
						}
						.CCTimer_baner_counter{
						    margin-top: 12px;
						}
						.CCTimer_get_more_time{
						   background-color: #a8d5ba;
							text-align: center;
							color: #fff;
							border: 0;
							border-radius: 3px;
							font-size: 14px;
							font-weight: 400;
							padding: 10px 25px;
							vertical-align: text-bottom;
							/* box-shadow: inset 0 -3px 0 rgba(0, 0, 0, .1); */
							/* text-shadow: none !important; */
							display: inline-block;
							margin-top: 5px;
							text-decoration:none;
						}
						.CCTimer_baner_notice p{
							font-size: 14px;
							margin-top: 15px;
						}
						
						.CCTimer_stopped #CCTimer_min,
						.CCTimer_stopped #CCTimer_sec{
							/*animation: blinker 2.5s linear infinite;
							font-size: 30px;
							*/
							opacity: 0.5;
						}

						.CCTimer_pause #CCTimer_min,
						.CCTimer_pause #CCTimer_sec{
							animation: blinker 2s linear infinite;
						}

						.CCTimer_timesup #CCTimer_sec{
							animation: blinker 1s linear infinite;
						}
						.CCTimer_baner_notice a{
							text-decoration:underline;
						}
						@keyframes blinker {
							50% {
								opacity: 0;
							}
						}
					</style>
					
					<script id="CCTimer_script">
				
						class CCTimer{
						
							constructor(action) {
								
								this.countdown;

								this.uid 			= '<?=$uid;?>';
								
								this.timerStatus 	= this.getCookie('CCTimerStatus_'+this.uid); 
								
								this.timerKey 		= this.getCookie('CCTimerKey_'+this.uid); 
															
								this.timerVal 		= this.getCookie('CCTimerVal_'+this.uid) != '' ? this.getCookie('CCTimerVal_'+this.uid) : 0;
								
								this.timeLeft 		= this.getCookie('CCTimer_'+this.uid) != '' ? this.getCookie('CCTimer_'+this.uid) : 0;
						
								// this.timeLeft 		= this.timerProgress !='' ? this.timerProgress : 180;
								
								this.minLeft 		= this.timeLeft != 0 ? `${String(Math.floor((this.timeLeft % 3600) / 60)).padStart(2, '0')}` : '00';
								
								this.secLeft 		= this.timeLeft != 0 ? `${String(this.timeLeft % 60).padStart(2, '0')}` : '00';
								
								this.isPaused		= this.timerStatus == 'paused' ? true : (this.timerVal == this.timeLeft ? false : true);
							}
							
							initTimer(){
								
								if(this.timeLeft > 0){
									
									this.initBanner();
									
									if (window.location.href.indexOf("chat") > -1) {
									
										cTimer.startTimer();
									}
						
								}else{
								
								}
							}
							
							initBanner(){
								
								let headerHeight = document.body.contains(document.querySelector('header')) ? document.querySelector('header').offsetHeight : 0;
								
								console.log('headerHeight');
								console.log(headerHeight);
								
								let CCTimer_baner 				= document.createElement("div");
								CCTimer_baner.className  		= 'CCTimer_baner';
								CCTimer_baner.innerHTML  		= '<div class="CCTimer_baner_container container">\
									<div class="CCTimer_baner_heading">\
										<p>Klik op een profiel naar keuze om te beginnen met chatten\
										<br>Dit is nog de tijd die je over hebt:<p>\
									</div>\
									<div class="CCTimer_baner_counter">\
										<div class="CCTimer_baner_counter_box CCTimer_baner_counter_min">\
											<div id="CCTimer_min">'+this.minLeft+'</div>\
											<span>min</span>\
										</div>\
										<div class="CCTimer_baner_counter_box CCTimer_baner_counter_sec">\
											<div id="CCTimer_sec">'+this.secLeft+'</div>\
											<span>sec</span>\
										</div>\
									</div>\
									<div id="CCTimer_baner_popup_call"></div>\
									<div class="CCTimer_baner_notice"></div>\
								</div>';
				
								// document.querySelector('body').appendChild(CCTimer_baner);
								// document.querySelector('body').insertBefore(CCTimer_baner, document.querySelector('header'));
								
								this.insertAfter(document.querySelector('header'), CCTimer_baner);
								
								if(this.isPaused){
								
									document.querySelector('.CCTimer_baner_counter').className = 'CCTimer_baner_counter CCTimer_pause';
								}
								
								if(this.timeLeft < 30){
								
									if(this.timeLeft == 0){
									
										document.querySelector('.CCTimer_baner_counter').className = 'CCTimer_baner_counter CCTimer_stopped';
										this.updateDB();
										this.showBuyBtn(2);
									}else{
										
										this.showBuyBtn(1);
									}
								}
								// this.startTimer();
							}
							
							insertAfter(referenceNode, newNode) {
							
								referenceNode.parentNode.insertBefore(newNode, referenceNode.nextSibling);
							}
							
							showBuyBtn(step=0) {								
								
								// console.log('step');
								// console.log(step);
								let text = '';
								
								if(step == 1){
									text = '<p>Weinig tijd? Bekijk onze \
									<a href="/plans" target="_blank">prijsplannen</a></p>';
								}
								
								if(step == 2){
								
									text = '<p>De tijd is om!</p>\
									<a href="/plans" target="_blank" class="CCTimer_get_more_time">Krijg een tijd</a>';
								}
								
								document.querySelector('.CCTimer_baner_notice').innerHTML = text;
							}
							
							updateDB() {
								//write to DB
								if(this.timerKey != ''){
								
									jQuery.ajax({
										
										type: 'POST', 
										url: '<?php  echo  get_admin_url(); ?>admin-ajax.php',
										data: {
											'action'		:	'CCTimer_update',
											'timeLeft'		:	this.timeLeft,
											'timerKey'		:	this.timerKey,
										},
										success: function (data) {
										
											console.log('data');
											console.log(data);
											
											// if(data != 'error'){	
											
												// jQuery('#arbstate').val(data);
												// arbitrageLoadRows(data);
											// }
										},
										error: function (errorThrown) {
										
											console.log('errorThrown');
											console.log(errorThrown);
										}

									});	
								}
							}
							
							updateProgress() {
							
								if(this.timeLeft < 30){
									
									this.showBuyBtn(1);
								}else{
								
									this.showBuyBtn(0);
								}
								
								// this.timeLeft = this.timeLeft > 10 ? parseInt(this.timeLeft) + 1 : this.timeLeft; //add one second for proccessing
								
								this.setCookie('CCTimer_'+this.uid, this.timeLeft, 365); 
							
							}
							
							updateDisplay() {
								
								// console.log('this.timeLeft');
								// console.log(this.timeLeft);
								
								document.querySelector('.CCTimer_baner_counter').className = 'CCTimer_baner_counter';
								
								this.updateProgress();							
 
								// const hours 	= Math.floor(time / 3600);
								const minutes   = Math.floor((this.timeLeft % 3600) / 60);
								const seconds 	= this.timeLeft % 60;
								
								document.querySelector('#CCTimer_min').innerHTML = `${String(minutes).padStart(2, '0')}`;
								document.querySelector('#CCTimer_sec').innerHTML = `${String(seconds).padStart(2, '0')}`;								
								
								if(this.timeLeft <= 10){
									
									document.querySelector('.CCTimer_baner_counter').className = 'CCTimer_baner_counter CCTimer_timesup';
								}
								// timerDisplay.textContent = `${String(hours).padStart(2, '0')}:${String(minutes).padStart(2, '0')}:${String(seconds).padStart(2, '0')}`;
							}
							
							startTimer() {
 
								// if(!this.isPaused){
								
									// // document.querySelector('.CCTimer_baner_counter').className = 'CCTimer_baner_counter CCTimer_pause';
									// return; 
								// } 
								
								// document.querySelector('.CCTimer_baner_counter').className = 'CCTimer_baner_counter';
								
								this.isPaused 	= false;
								
								document.querySelector('.CCTimer_baner_heading').innerHTML = '<p>Resterende tijd om te chatten:</p>';
								
								this.enableChat(true);
							
								this.setCookie('CCTimerStatus_'+this.uid, 'running', 365); 
								
								this.countdown 	= setInterval(() => {
								
									if(this.timeLeft > 0){
									
										this.timeLeft--;
										this.updateDisplay();
									}else{
										
										clearInterval(this.countdown);
										this.stopTimer();
									}
								
								}, 1000);								
								
							}
							
							enableChat(action = false) {
								
								if(document.querySelectorAll('.mwai-input textarea').length > 0){
									
									document.querySelector('.mwai-input textarea').setAttribute('disabled', action);
								}
							}
							
							stopTimer() {
							
								this.setCookie('CCTimerStatus_'+this.uid, 'stopped', 365); 
								document.querySelector('.CCTimer_baner_counter').className = 'CCTimer_baner_counter CCTimer_stopped';
								
								
								this.showBuyBtn(0);
								this.showPopup();
							}
							
							showPopup() {							
								
								
								this.enableChat(false);
								
								this.eventFire(document.getElementById('CCTimer_baner_popup_call'),'click');
								
							}
							eventFire(el, etype){
							
								if (el.fireEvent) {
									(el.fireEvent('on' + etype));
								} else {
									var evObj = document.createEvent('Events');
									evObj.initEvent(etype, true, false);
									el.dispatchEvent(evObj);
								}
							}
//usage

							pauseTimer() {
							
								if(this.isPaused){
								
									return;
								} 
								
								clearInterval(this.countdown);
								
								this.isPaused = true;
								
								document.querySelector('.CCTimer_baner_counter').className = 'CCTimer_baner_counter CCTimer_pause';
								
								this.setCookie('CCTimerStatus_'+this.uid, 'paused', 365); 
								
								this.updateDB();
							}
							
							resumeTimer() {
							
								// console.log('isPaused');
								// console.log(this.isPaused);
							
								// if(this.isPaused){
									// return;
								// } 
								// clearInterval(this.countdown);
								this.isPaused = true;
								this.startTimer();
							}
							
							setCookie(cname,cvalue,exdays) {
							
								const d = new Date();
								d.setTime(d.getTime() + (exdays*24*60*60*1000));
								let expires = "expires=" + d.toUTCString();
								document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
							}

							removeCookie(name){
								document.cookie = name +'=; Path=/; Expires=Thu, 01 Jan 1970 00:00:01 GMT;';
							}

							getCookie(cname) {
								
								let name = cname + "=";
								let decodedCookie = decodeURIComponent(document.cookie);
								let ca = decodedCookie.split(';');
								for(let i = 0; i < ca.length; i++) {
									let c = ca[i];
									while (c.charAt(0) == ' ') {
										c = c.substring(1);
									}
									if (c.indexOf(name) == 0) {
									  return c.substring(name.length, c.length);
									}
								}
								
								return "";
							}
				
						}
						
						window.cTimer = new CCTimer();
						
						cTimer.initTimer();
						
						onbeforeunload = (event) => { 
							
							if(cTimer.timeLeft > 0){
								
								cTimer.pauseTimer();
							}
						};
						
					</script>
					
				<?php
			}
		}
		// private function get_team_id($team_name){			
			
			// global $wpdb;
			
			// if(!empty($team_name)){
				
				// $ch_table	= $wpdb->prefix . 'CCTimer_TEAMS';
				
				// $sdata = $wpdb->get_row( 'SELECT * FROM '.$ch_table.' WHERE team_name LIKE "%'.$team_name.'%"');			
				
				// if(!is_null($sdata)){
					
					// return $sdata->team_id;
				// }
			// }
			
			// return false;
		// }
		
		// private function get_datas(){			
			
			// global $wpdb;			
			
			// $option = get_option('CCTimer_init_leagues');
			
			// if(!empty($option) && ($option + (3600 * 24 * 3)) < time()){
			
				// $this->init_leagues();
			// }
			
			// $ch_table	= $wpdb->prefix . 'CCTimer_LEAGUES';
			
			// $query = 'SELECT * FROM '.$ch_table. ' ORDER BY name ASC';			
			
			// $sdata = $wpdb->get_results($query, 'ARRAY_A');			
			// // print_r($sdata);exit;
			// if(!empty($sdata)){
				
				// return $sdata;
			// }
			
			// return false;
		// }
		
		private function init_tables(){
			
			global $wpdb;
			
			$charset_collate 		= $wpdb->get_charset_collate();		
			
			$args = array(				
				
				'CCTimer_timer'		=> array(	
				
					array('column'=>'ID', 				'type'=>'INT(11) AUTO_INCREMENT'),
					array('column'=>'uid', 				'type'=>'INT(11)'),
					array('column'=>'timer_key', 		'type'=>'VARCHAR(255)'),
					array('column'=>'timer_value', 		'type'=>'INT(11)'),
					array('column'=>'timer_counter', 	'type'=>'INT(11)'),
					array('column'=>'created_at', 		'type'=>'INT(11)'),
					array('column'=>'modified_at', 		'type'=>'INT(11)'),
				),	
				// 'CCTimer_chat'		=> array(	
				
					// array('column'=>'ID', 				'type'=>'INT(11) AUTO_INCREMENT'),
					// array('column'=>'ckey', 			'type'=>'VARCHAR(255)'),
					// array('column'=>'slug', 			'type'=>'VARCHAR(255)'),
					// array('column'=>'name', 			'type'=>'VARCHAR(255)'),
					// array('column'=>'shortName', 		'type'=>'VARCHAR(255)'),
					// array('column'=>'sport', 			'type'=>'VARCHAR(255)'),
				// ),
				
			);		
	
			foreach($args as $col => $arg){
				
				$queryStr 	 = "";
				
				foreach($arg as $row){
					
					$queryStr 	.= ' '.$row['column'].' '.$row['type'].',';
				}
				
				$queryStr 	.= ' PRIMARY KEY('.$arg[0]['column'].')';
				
				$query 		 = "CREATE TABLE IF NOT EXISTS  ".$wpdb->prefix.$col." (".$queryStr." )$charset_collate"; 	
				
				$wpdb->query($query);
			}
			
			update_option('CCTimer_init_tables', time());
		}
		
		public function update_timer(){
		
			$uid = get_current_user_id();
			
			if($uid != 0){
			
				if(isset($_POST['timeLeft'])  && !empty($_POST['timeLeft'])
					&& isset($_POST['timerKey']) && !empty($_POST['timerKey'])){
					
					global $wpdb;	
					
					$query = $wpdb->update(
					
						$wpdb->prefix . 'CCTimer_timer', 					
						array(
						
							'timer_counter'	=> (int)$_POST['timeLeft'],
							'modified_at'	=> time(),
						),
						array(
						
							'timer_key'		=> $_POST['timerKey'],
						), 
					);
					
					die($_POST['timeLeft'].' / '.$_POST['timerKey']);
				}
			}
		}
		
		private function get_timer($uid){
			
			global $wpdb;
			
			if(!empty($uid)){
				
				$ch_table	= $wpdb->prefix . 'CCTimer_timer';
				
				$res = $wpdb->get_results( 'SELECT * FROM '.$ch_table.' WHERE uid="'.$uid.'" ORDER BY created_at DESC LIMIT 1', 'ARRAY_A');
				
				if(!empty($res)){
				
					return $res[0];	
				}
			
			}
			
			return false;
		}
		
		public function add_timer(){
		
			$uid = get_current_user_id();
			
			if($uid != 0){
			
				$timer = $this->get_timer($uid);
				
				if(!empty($timer) && $timer['timer_value'] == $timer['timer_counter']){
				
					//already exists
				}else{
				
					if(isset($_POST['timer_val']) && !empty($_POST['timer_val'])){
						
						
						global $wpdb;	
						
						$timer_val = $_POST['timer_val'];
						
						$query = $wpdb->insert(
						
							$wpdb->prefix . 'CCTimer_timer', 					
							array(
							
								'uid'			=> $uid,
								'timer_key' 	=> $uid.'_'.wp_generate_password(11).'_'.time(),
								'timer_value'	=> $timer_val,
								'timer_counter'	=> $timer_val,
								'created_at'	=> time(),
							)
						);
						
						die('success');
					}
				}
			}
		}
		// public function init_admin_menu() {
			// // add_menu_page('Odds Futures', 'Odds Futures', 'manage_options', 'O_F', array($this, 'init_admin_page'), 'dashicons-pressthis', 6); 
			// add_menu_page('CCTimer', 'Futures Tool', 'manage_options', 'CCTimer', array($this, 'init_admin_page'), 'dashicons-spreadsheet', 6); 
		// }
		
		public function init_admin_page() {		
			
			
			?>
			
			
			<h2 class="data-heading">Options</h2>

			
			<form method="post" action="">
			
	
				<style>
					.pevt-options input, .pevt-options textarea{
						width:50%;
					}
					.pevt-options h4{
						font-size:18px;
					}
					.pevt-options b{
						font-size:16px;
					}
					.pevt-options{
						margin-bottom:50px;
						margin-bottom:50px;
					}
				</style>
				
				<div class="pevt-options">
													
				</div>
							
					
				<button type="submit" name="fubooksS">Save</button>
			
			</form>
			
			<?php
			
		
		}
		
		
		public function render_tool($args = array()){
		
			ob_start();
			
			$uid = get_current_user_id();
			
			if($uid != 0){
			
				?>
					
					<script>
						
						var timer_val = 180;//write to DB
						
						if(timer_val != ''){
						
							jQuery.ajax({
								
								type: 'POST', 
								url: '<?php  echo  get_admin_url(); ?>admin-ajax.php',
								data: {
									'action'		:	'CCTimer_add',
									'timer_val'		:	timer_val,
								},
								success: function (data) {
								
									console.log('data');
									console.log(data);
									
									// if(data != 'error'){	
									
										// jQuery('#arbstate').val(data);
										// arbitrageLoadRows(data);
									// }
								},
								error: function (errorThrown) {
								
									console.log('errorThrown');
									console.log(errorThrown);
								}

							});	
						}
						
					</script>
				
				<?php

			}
			
			return ob_get_clean();
		}

	}		
}		

?>