<?php

	/**
	 * PA Setup Wizard Main View.
	 *
	 * @package Setup Wizard.
	 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

	use PremiumAddons\Includes\Helper_Functions;

	$steps = array(
		'welcome'   => __( 'Website Type', 'premium-addons-for-elementor' ),
		'widgets'   => __( 'Widgets', 'premium-addons-for-elementor' ),
		'upgrade'   => __( 'Get PRO', 'premium-addons-for-elementor' ),
		'community' => __( 'Get Involved', 'premium-addons-for-elementor' ),
		'finish'    => __( 'Finish', 'premium-addons-for-elementor' ),
	);

	$memory_limit         = wp_convert_hr_to_bytes( WP_MEMORY_LIMIT );
	$hide_memory_limit    = $memory_limit < 314572800 ? false : true;
	$time_limit           = ini_get( 'max_execution_time' );
	$hide_time_limit      = $time_limit < 120 && $time_limit != 0 ? false : true;
	$render_memory_notice = ! ( $hide_memory_limit && $hide_time_limit );
	$divider_border       = $render_memory_notice ? 'pa-bt-border-dim' : '';
	?>

	<div id="premium-addons-setup-wizard" class="pa-wz-outer-wrapper pa-wz-flex pa-wz-flex-d-col" pa-current-step="1">

		<!-- Header -->
		<div class="pa-wz-header pa-wz-flex pa-wz-justify-content-between pa-wz-align-items-center">
			<svg class="pa-wz-logo" xmlns="http://www.w3.org/2000/svg" width="196.15" height="56.85" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 196.15 56.85"><defs><style>.pa-logo-1{fill:#010101;}.pa-logo-2{fill:url(#linear-gradient-5);}.pa-logo-3{fill:url(#linear-gradient-4);}.pa-logo-4{fill:url(#linear-gradient-3);}.pa-logo-5{fill:url(#linear-gradient-2);}.pa-logo-6{fill:url(#linear-gradient);}.pa-logo-7{fill:#fff;}</style><linearGradient id="linear-gradient" x1="8.73" y1="23.4" x2="10.95" y2="38.67" gradientUnits="userSpaceOnUse"><stop offset=".08" stop-color="#35c5f1"/><stop offset=".24" stop-color="#32b6e7"/><stop offset=".99" stop-color="#2674bb"/></linearGradient><linearGradient id="linear-gradient-2" x1="12.17" y1="17.26" x2="26.84" y2="6.65" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#f04d23"/><stop offset=".99" stop-color="#eb8b23"/></linearGradient><linearGradient id="linear-gradient-3" x1="26.45" y1="36.93" x2="29.07" y2="54.9" gradientUnits="userSpaceOnUse"><stop offset=".08" stop-color="#4187c7"/><stop offset=".32" stop-color="#4082c4"/><stop offset=".57" stop-color="#3d76bc"/><stop offset=".81" stop-color="#3962af"/><stop offset=".99" stop-color="#354fa2"/></linearGradient><linearGradient id="linear-gradient-4" x1="39.98" y1="2.41" x2="41.64" y2="13.76" gradientUnits="userSpaceOnUse"><stop offset="0" stop-color="#feee53"/><stop offset=".33" stop-color="#f7ca42"/><stop offset="1" stop-color="#ec8723"/></linearGradient><linearGradient id="linear-gradient-5" x1="46.27" y1="25.1" x2="48.29" y2="38.92" gradientUnits="userSpaceOnUse"><stop offset=".02" stop-color="#97c93d"/><stop offset=".99" stop-color="#648d3d"/></linearGradient></defs><g id="Dark"><circle class="pa-logo-7" cx="28.42" cy="28.42" r="28.42"/><path class="pa-logo-6" d="M17.22,33.19c-1.45,4.37-2.87,8.75-4.31,13.13-.24.75-.49,1.5-.73,2.25-5.88-4.74-9.65-12.01-9.65-20.16,0-2.08.25-4.1.71-6.04,4.56,3.3,9.11,6.6,13.68,9.88.38.27.45.5.3.94Z"/><path class="pa-logo-5" d="M11.63,19.63c-2.52,0-5.04,0-7.57,0C7.52,10.03,16.48,3.07,27.13,2.55c-1.78,5.52-3.56,11.03-5.33,16.55-.14.45-.35.57-.81.56-3.12-.02-6.24-.01-9.37-.01v-.02Z"/><path class="pa-logo-4" d="M40.42,49.37c.51.37,1.02.74,1.52,1.11-3.94,2.42-8.57,3.81-13.53,3.81s-9.59-1.39-13.53-3.81c4.32-3.15,8.64-6.3,12.96-9.47.42-.31.68-.35,1.12-.02,3.8,2.81,7.63,5.59,11.45,8.37Z"/><path class="pa-logo-3" d="M32.51,11.2c-.93-2.88-1.86-5.77-2.79-8.65,10.65.52,19.61,7.49,23.07,17.08-5.66,0-11.31.01-16.97.03-.44,0-.63-.13-.76-.54-.83-2.64-1.69-5.28-2.54-7.92Z"/><path class="pa-logo-2" d="M54.31,28.41c0,8.15-3.76,15.41-9.64,20.16-1.66-5.07-3.31-10.13-4.99-15.19-.2-.6-.09-.89.41-1.25,4.1-2.93,8.17-5.89,12.25-8.84.42-.31.84-.61,1.26-.91.46,1.93.71,3.95.71,6.03Z"/><path class="pa-logo-1" d="M66.89,23.4v-10.89h5.74c.53,0,1.02.09,1.48.26.46.18.85.42,1.17.74.33.32.58.69.77,1.12.19.43.28.9.28,1.41s-.09.94-.28,1.37c-.19.43-.45.79-.78,1.1-.33.31-.72.55-1.17.72-.45.18-.94.26-1.47.26h-3.06v3.9h-2.67ZM72.31,14.8h-2.75v2.49h2.75c.38,0,.7-.11.94-.34.24-.23.37-.52.37-.89s-.12-.68-.37-.91c-.24-.23-.56-.35-.94-.35Z"/><path class="pa-logo-1" d="M77.57,23.4v-8.23h2.52v.82c.27-.32.59-.57.95-.75.36-.18.77-.26,1.21-.26.24.01.43.03.58.05.14.03.27.08.37.15v2.19c-.17-.07-.35-.13-.56-.18-.21-.05-.42-.07-.64-.07-.39,0-.76.09-1.1.28-.34.19-.61.44-.82.76v5.22h-2.52Z"/><path class="pa-logo-1" d="M91.52,22.31c-.52.44-1.05.75-1.59.95s-1.16.3-1.84.3c-.62,0-1.21-.11-1.76-.33-.55-.22-1.02-.52-1.42-.9-.4-.38-.72-.84-.95-1.36-.23-.52-.35-1.08-.35-1.67s.11-1.15.33-1.67c.22-.52.53-.98.91-1.36s.84-.68,1.36-.9c.52-.22,1.09-.33,1.69-.33s1.16.11,1.66.34c.51.23.95.54,1.31.93.37.39.66.87.86,1.42.21.55.31,1.15.31,1.8v.62h-5.86c.17.38.42.7.78.94.35.24.77.37,1.24.37.34,0,.65-.05.93-.16.28-.11.52-.26.72-.46l1.66,1.48ZM87.85,17.08c-.41,0-.77.11-1.07.34-.3.23-.51.55-.64.96h3.44c-.13-.39-.36-.71-.66-.95-.31-.24-.66-.36-1.07-.36Z"/><path class="pa-logo-1" d="M93.23,23.4v-8.23h2.52v.53c.29-.23.61-.4.96-.51.35-.11.71-.17,1.1-.17.51,0,.97.1,1.39.3.42.2.77.48,1.05.83.33-.36.73-.64,1.18-.84.46-.2.95-.3,1.49-.3.93,0,1.7.31,2.29.93.6.62.89,1.42.89,2.38v5.07h-2.52v-4.73c0-.45-.12-.81-.37-1.08-.24-.27-.57-.41-.97-.41-.28,0-.53.05-.76.16-.23.11-.43.26-.59.46.01.08.02.17.02.26,0,.09,0,.18,0,.27v5.07h-2.52v-4.73c0-.45-.12-.81-.37-1.08-.24-.27-.57-.41-.97-.41-.28,0-.53.05-.75.15-.22.1-.41.25-.57.44v5.63h-2.52Z"/><path class="pa-logo-1" d="M108.86,14.41c-.38,0-.71-.13-.98-.4-.27-.27-.4-.6-.4-.98s.13-.71.4-.98c.27-.27.6-.4.98-.4s.71.13.98.4c.27.27.4.6.4.98s-.13.71-.4.98c-.27.27-.6.4-.98.4ZM110.12,15.17v8.23h-2.52v-8.23h2.52Z"/><path class="pa-logo-1" d="M114.13,15.17v4.73c0,.45.14.81.41,1.08.27.27.63.41,1.08.41.32,0,.61-.06.86-.17.25-.11.46-.27.62-.48v-5.57h2.52v8.23h-2.52v-.56c-.3.23-.64.4-1.02.53-.38.12-.78.19-1.19.19-.96,0-1.75-.31-2.36-.93-.61-.62-.92-1.42-.92-2.38v-5.07h2.52Z"/><path class="pa-logo-1" d="M121.17,23.4v-8.23h2.52v.53c.29-.23.61-.4.96-.51.35-.11.71-.17,1.1-.17.51,0,.97.1,1.39.3.42.2.77.48,1.05.83.33-.36.73-.64,1.18-.84.46-.2.95-.3,1.49-.3.93,0,1.7.31,2.29.93.6.62.89,1.42.89,2.38v5.07h-2.52v-4.73c0-.45-.12-.81-.37-1.08-.24-.27-.57-.41-.97-.41-.28,0-.53.05-.76.16-.23.11-.43.26-.59.46.01.08.02.17.02.26,0,.09,0,.18,0,.27v5.07h-2.52v-4.73c0-.45-.12-.81-.37-1.08-.24-.27-.57-.41-.97-.41-.28,0-.53.05-.75.15-.22.1-.41.25-.57.44v5.63h-2.52Z"/><path class="pa-logo-1" d="M137.69,23.4l4.46-10.89h3.06l4.4,10.89h-2.89l-1-2.63h-4.25l-1.01,2.63h-2.78ZM142.29,18.64h2.64l-1.31-3.48-1.34,3.48Z"/><path class="pa-logo-1" d="M155.85,23.4v-.61c-.32.23-.67.4-1.04.53s-.76.19-1.17.19c-.58,0-1.13-.11-1.64-.33s-.96-.52-1.34-.9c-.38-.38-.68-.83-.89-1.35-.22-.51-.33-1.07-.33-1.66s.11-1.14.33-1.66c.22-.51.53-.96.91-1.34.38-.38.84-.68,1.36-.89.52-.22,1.08-.33,1.67-.33.38,0,.75.05,1.1.14.35.09.68.23,1,.4v-3.09l2.52-.54v11.43h-2.49ZM151.92,19.27c0,.59.21,1.09.63,1.49.42.4.93.6,1.53.6.35,0,.67-.05.96-.16.29-.11.55-.27.78-.49v-2.88c-.22-.2-.48-.35-.78-.47-.3-.11-.62-.17-.96-.17-.61,0-1.12.2-1.54.6-.41.4-.62.89-.62,1.48Z"/><path class="pa-logo-1" d="M165.93,23.4v-.61c-.32.23-.67.4-1.04.53s-.76.19-1.17.19c-.58,0-1.13-.11-1.64-.33s-.96-.52-1.34-.9c-.38-.38-.68-.83-.89-1.35-.22-.51-.33-1.07-.33-1.66s.11-1.14.33-1.66c.22-.51.53-.96.91-1.34.38-.38.84-.68,1.36-.89.52-.22,1.08-.33,1.67-.33.38,0,.75.05,1.1.14.35.09.68.23,1,.4v-3.09l2.52-.54v11.43h-2.49ZM161.99,19.27c0,.59.21,1.09.63,1.49.42.4.93.6,1.53.6.35,0,.67-.05.96-.16.29-.11.55-.27.78-.49v-2.88c-.22-.2-.48-.35-.78-.47-.3-.11-.62-.17-.96-.17-.61,0-1.12.2-1.54.6-.41.4-.62.89-.62,1.48Z"/><path class="pa-logo-1" d="M169.6,19.29c0-.59.12-1.15.35-1.67s.55-.98.95-1.36c.4-.38.87-.69,1.42-.91.54-.22,1.13-.33,1.75-.33s1.21.11,1.75.33c.54.22,1.02.53,1.41.91.4.38.72.84.95,1.36s.35,1.08.35,1.67-.12,1.15-.35,1.67c-.23.52-.55.98-.95,1.36-.4.38-.87.68-1.41.9-.54.22-1.13.33-1.75.33s-1.21-.11-1.75-.33c-.54-.22-1.02-.52-1.42-.9-.4-.38-.72-.84-.95-1.36-.23-.52-.35-1.08-.35-1.67ZM174.06,21.37c.56,0,1.03-.2,1.42-.61.39-.4.58-.9.58-1.48s-.19-1.09-.58-1.49c-.39-.4-.86-.61-1.42-.61s-1.03.2-1.42.61c-.39.4-.58.9-.58,1.49s.19,1.07.58,1.48c.39.4.86.61,1.42.61Z"/><path class="pa-logo-1" d="M179.7,23.4v-8.23h2.52v.56c.3-.23.64-.4,1.02-.53.38-.12.77-.19,1.19-.19.96,0,1.75.31,2.36.93.61.62.92,1.42.92,2.38v5.07h-2.52v-4.73c0-.45-.14-.81-.41-1.08-.27-.27-.64-.41-1.08-.41-.32,0-.61.06-.86.17-.25.11-.46.27-.62.48v5.57h-2.52Z"/><path class="pa-logo-1" d="M188.57,22.48l1.2-1.69c.52.31.99.54,1.42.68.42.14.84.21,1.26.21s.74-.06.99-.18c.24-.12.37-.28.37-.47,0-.16-.07-.28-.2-.38-.13-.1-.35-.17-.64-.21l-1.63-.25c-.81-.12-1.43-.4-1.87-.82s-.65-.97-.65-1.64c0-.83.32-1.48.95-1.96.63-.48,1.5-.72,2.6-.72.59,0,1.18.09,1.78.26.6.17,1.15.42,1.66.74l-1.2,1.62c-.45-.26-.87-.45-1.28-.57-.4-.12-.81-.18-1.21-.18-.32,0-.58.05-.78.16-.2.11-.3.25-.3.43,0,.17.07.3.22.4.14.1.39.17.75.23l1.63.25c.81.11,1.43.38,1.87.8.44.42.66.95.66,1.59,0,.39-.09.76-.28,1.1-.19.34-.44.64-.77.89-.33.25-.72.44-1.17.58-.46.14-.95.21-1.48.21-.78,0-1.5-.09-2.17-.27-.67-.18-1.24-.45-1.72-.8Z"/><path class="pa-logo-1" d="M133.86,38.09c.32-.59.6-1.09.88-1.59.4-.71,1.03-.99,1.83-.96.62.03.9.28.73.93-.25.95-.23,1.93-.18,2.9,0,.21-.02.48.23.56.24.07.38-.16.52-.32,1.35-1.54,1.83-3.38,1.85-5.39,0-.68.09-1.25-.9-1.08-.39.07-.82-.12-.84-.58-.02-.48.42-.63.81-.58.87.12,1.17-.18,1.15-1.08-.02-.76.63-1.15,1.43-1.05.73.09,1.07.52.95,1.3-.08.52,0,.77.57.67.08-.01.16,0,.24,0,.44.04.95.09.94.66-.01.5-.49.59-.9.63-1.11.12-1.12.12-1.2,1.28-.14,1.97-.4,3.93-.19,5.91.02.23-.04.58.23.64.32.07.42-.29.54-.51.65-1.18,1.28-2.38,1.56-3.72.13-.64.41-1.23.79-1.76,1.26-1.77,3.74-1.7,4.89.15.96,1.53.78,3.83-.3,5.28-.99,1.33-3.62,1.96-5.15-.21-.37.69-.68,1.41-1.23,1.98-.57.6-1.24,1.01-2.09.81-.84-.19-1.06-.94-1.25-1.65-.13-.51-.19-1.05-.3-1.72-.38.45-.69.83-1.01,1.2-.53.61-1.18.98-2.01.72-.87-.27-1.17-1-1.26-1.82-.05-.47,0-.95-.1-1.44-.71.85-.85,1.89-1.02,2.9-.12.7-.52.97-1.14,1.04-.84.09-1.25-.29-1.26-1.16,0-.29,0-.58,0-1.08-.45.62-.76,1.08-1.11,1.51-.66.82-1.48,1.42-2.52,1.67-1.57.38-2.73-.23-3.28-1.74-.13-.35-.23-.72-.36-1.14-.35.44-.67.87-1.02,1.26-.52.58-1.17.93-1.95.67-.75-.25-.92-.96-1.01-1.63-.15-1.1-.01-2.2.09-3.32-.77.92-1.23,2.01-1.7,3.08-.24.53-.57.9-1.1,1.12-.52.22-.83.09-.94-.48-.12-.64-.1-1.29-.09-1.94,0-.31,0-.61-.07-.93-.66,1.11-.93,2.34-1.18,3.57-.12.61-.45.89-1,1.01-.84.18-1.35-.25-1.35-1.11,0-.47,0-.95,0-1.42-.07-.02-.14-.04-.2-.06-.17.26-.33.51-.5.76-.78,1.15-1.76,2.06-3.18,2.34-1.45.28-2.47-.27-3.07-1.63-.06-.15-.12-.29-.23-.54-.4.7-.67,1.37-1.13,1.92-.53.64-1.17,1.09-2.03.92-.8-.16-1.09-.86-1.28-1.54-.19-.69-.29-1.4-.44-2.16-.38.52-.7,1.02-1.09,1.46-.83.95-1.83,1.6-3.14,1.62-1.24.02-2.12-.48-2.5-1.67-.93-2.94-.5-5.73,1.25-8.25.75-1.08,1.98-1.09,2.96-.19.55.51.87,1.17,1.05,1.89.33,1.33-.08,2.12-1.35,2.64-.25.1-.51.17-.77.23q-1.39.32-1.34,1.78c.01.27.05.54.09.81.07.52.15,1.07.72,1.26.55.19,1.03-.12,1.38-.5,1.47-1.64,2.77-3.35,2.85-5.73.07-2.16.3-4.31.48-6.47.07-.82.68-1.31,1.43-1.19.8.12,1.1.56,1,1.44-.44,3.76-.88,7.52-.7,11.32.02.45-.03,1.11.42,1.19.39.07.53-.61.69-.99.61-1.47,1.22-2.94,1.58-4.5.24-1.03.61-2.02,1.26-2.87.92-1.2,2.23-1.26,3.25-.14.45.49.72,1.08.88,1.71.33,1.33-.07,2.13-1.34,2.64-.25.1-.51.17-.77.23-1.36.31-1.4.36-1.34,1.77.01.3.05.59.09.89.2,1.3,1.03,1.69,1.95.79,1.59-1.57,2.92-3.33,2.95-5.74.02-1.26.65-2.09,1.71-2.36.86-.22,1.17.07,1.03.93-.21,1.32-.41,2.64-.45,4.04.33-.64.65-1.29.99-1.92.4-.74.95-1.23,1.86-1.2.78.03.97.24.8,1-.08.36-.14.72-.1,1.22.66-1.01,1.25-1.9,1.83-2.8.38-.59.93-.9,1.62-.94.8-.05,1.15.35,1.03,1.15-.25,1.71-.64,3.4-.77,5.13-.02.25-.15.53.09.77.36-.09.48-.41.64-.68.63-1.11,1.17-2.24,1.45-3.5.24-1.09.62-2.13,1.31-3.02.9-1.16,2.18-1.22,3.19-.15.5.53.79,1.16.94,1.86.27,1.28-.11,2-1.33,2.51-.27.11-.56.19-.85.26-1.3.3-1.33.29-1.31,1.64,0,.53.02,1.08.24,1.59.29.66.71.82,1.37.51.53-.25.91-.68,1.26-1.12.81-1.02,1.42-2.17,1.96-3.35.2-.45.12-.9.17-1.36.13-1.07.6-1.66,1.46-1.78.78-.11,1.27.33,1.15,1.11-.12.82-.22,1.66-.49,2.45-.06.16-.03.3.11.54ZM148.33,37.88c0-1-.07-1.87-.54-2.63-.35-.57-.84-.58-1.11,0-.65,1.45-.64,2.93.06,4.38.13.26.35.51.7.45.31-.06.5-.29.62-.59.23-.56.3-1.15.27-1.62ZM128.33,35.11c-.03-.15-.07-.39-.12-.62-.04-.17-.04-.41-.29-.41-.18,0-.26.19-.31.34-.16.43-.3.87-.43,1.3-.07.24-.32.56.02.7.25.11.59-.02.82-.24.28-.27.3-.62.31-1.07ZM109.63,35.03s-.05-.26-.09-.5c-.04-.19-.06-.43-.26-.46-.21-.02-.3.21-.37.38-.15.4-.29.81-.4,1.23-.07.25-.36.61.05.74.31.1.71-.05.91-.4.14-.23.19-.5.16-1ZM97.8,35.19c-.03-.18-.08-.44-.13-.71-.03-.16-.06-.37-.23-.4-.22-.04-.31.19-.37.35-.16.43-.29.87-.43,1.3-.07.22-.27.52-.03.66.25.15.58,0,.82-.18.31-.24.34-.6.37-1.04Z"/><path class="pa-logo-1" d="M152.52,39.67c-.01-.76.1-1.51.29-2.24.04-.17.17-.38-.06-.49-.21-.1-.38.03-.44.23-.15.43-.43.65-.86.49-.48-.17-.31-.55-.2-.89.08-.22-.03-.41-.1-.61-.23-.66-.06-1.23.49-1.66.34-.27.76-.33,1.14-.13.38.19.39.58.28.92-.2.66.14.66.61.57.19-.04.37-.08.56-.08.75-.03.98.24.83.98-.2,1.01-.4,2.01-.46,3.04-.02.27-.01.54.02.81.02.2,0,.48.25.55.26.06.36-.19.46-.37.65-1.13,1.1-2.34,1.47-3.58.06-.21.1-.43.2-.61.15-.24.39-.39.69-.3.26.07.43.25.38.54-.35,2.14-.92,4.2-2.73,5.59-1.11.85-2.23.37-2.65-.97-.18-.58-.17-1.17-.17-1.77Z"/><path class="pa-logo-1" d="M89.59,35.7c-.17,0-.31,0-1.1,1.74-.48,1.05-.97,1.93-1.45,2.6-.45.62-.73.84-.87.91-.01-.09-.03-.26-.03-.56,0-.54.06-1.3.16-2.23.14-1.3.16-1.6.16-1.71,0-.21-.06-.41-.19-.6-.17-.27-.39-.32-.56-.32h0l-1.31.14c.16-.34.23-.68.23-1.03,0-.45-.15-.85-.44-1.22-.3-.38-.64-.57-1.02-.57s-.7.2-.91.57c-.18.33-.28.72-.28,1.15s.11.84.33,1.19c.06.1.13.2.22.28-.09.06-.2.12-.33.2-.2.12-.55.27-1.03.44-.06-1-.36-1.83-.88-2.48-.59-.73-1.25-1.1-1.95-1.1-.65,0-1.23.17-1.72.5-1.07.02-1.95.55-2.63,1.56-.2.3-.37.61-.51.92-.02.01-.05.03-.07.04-.54.29-1.2.54-1.98.74-.26-.77-.55-1.4-.85-1.86,1.33-2.28,2.01-4.38,2.01-6.22,0-1.32-.34-1.99-1.02-1.99-.54,0-1.07.36-1.57,1.08-.48.67-.84,1.55-1.06,2.62-.22,1-.44,2.21-.66,3.58-.38.12-.7.36-.97.69-.29.38-.45.91-.45,1.58s.29,1.22.88,1.68c-.25,2.41-.38,4.51-.38,6.22s.02,3.02.07,3.8c.04.52.18,1.07.44,1.63.23.55.68.83,1.3.83.68,0,1.26-.28,1.72-.82.44-.52.77-1.2.97-2.02.35-1.42.52-2.91.52-4.46,0-1.76-.2-3.46-.6-5.05.44-.16.85-.34,1.23-.53-.04.25-.06.51-.06.77,0,1.14.29,2.14.85,2.99.59.88,1.44,1.33,2.54,1.33,1.47,0,2.61-.46,3.41-1.36.76-.86,1.22-1.99,1.36-3.35.72-.29,1.33-.62,1.82-.98.21-.16.37-.28.49-.4.23.08.48.12.75.14-.23.9-.35,1.97-.35,3.17,0,1.92.11,2.19.26,2.33.37.29.91.45,1.6.45,1,0,2.14-1.4,3.5-4.28.5-1.05.74-1.8.74-2.3,0-.32-.21-.43-.39-.43ZM70.99,29.93c.27-1.07.47-1.44.57-1.57.03.11.06.34.06.8,0,.69-.19,1.58-.58,2.63-.22.6-.45,1.16-.7,1.67.2-1.42.42-2.6.66-3.52ZM69.99,36.2c.13.25.26.53.37.84-.13,0-.28,0-.45-.04l.08-.8ZM70.78,47.32c-.36,1.4-.73,1.71-.95,1.76-.08-.17-.26-.85-.26-3.71,0-2.52.07-4.79.21-6.76.31-.02.65-.06.99-.14.33,1.52.49,3.05.49,4.55s-.17,3.02-.49,4.3ZM78.47,40.35c-.35.54-.83.8-1.46.8s-1.06-.31-1.35-.94c-.31-.68-.47-1.41-.47-2.16,0-.93.11-1.68.34-2.24,0,.11-.01.22-.01.34,0,.61.29,1.18.87,1.67.57.49,1.26.74,2.09.74h0l.62-.04c-.08.72-.29,1.34-.63,1.84ZM79.09,37.11c-.51,0-.94-.17-1.32-.51-.37-.34-.56-.77-.56-1.31,0-.24.06-.45.19-.66.11-.17.24-.25.42-.25.42,0,.73.27.93.84.21.57.34,1.2.38,1.89h-.05Z"/></g></svg>
			<span class="pa-wz-skip-txt-wrapper pa-wz-flex pa-wz-close">
				<span class="pa-wz-skip-txt"><?php echo esc_html_e( 'Skip Wizard', 'premium-addons-for-elementor' ); ?></span>
				<svg class="pa-wz-skip-icon" xmlns="http://www.w3.org/2000/svg" width="24.5" height="24" viewBox="0 0 24.5 24"><defs><style>.pa-wz-skip-icon-1{fill:#979797;fill-rule:evenodd;}</style></defs><path id="Close_Bold" class="pa-wz-skip-icon-1" d="M12.5,14.12l5.3,5.3c.59.59,1.54.59,2.12,0s.59-1.54,0-2.12l-5.3-5.3,5.3-5.3c.59-.59.59-1.54,0-2.12-.59-.59-1.54-.59-2.12,0l-5.3,5.3-5.3-5.3c-.59-.59-1.54-.59-2.12,0-.59.59-.59,1.54,0,2.12l5.3,5.3-5.3,5.3c-.59.59-.59,1.54,0,2.12.59.59,1.54.59,2.12,0l5.3-5.3Z"/></svg>
			</span>
		</div>
		<!-- End of Header -->

		<div class="pa-wz-content-container pa-wz-flex">
			<!-- Steps -->
			<div class="pa-wz-steps-wrapper pa-wz-flex pa-wz-flex-d-col">
				<span class="pa-step-progress"></span>
				<?php if ( $render_memory_notice ) : ?>
					<div class="pa-wz-extra-notice-wrapper pa-wz-flex pa-wz-flex-d-col" style="display:none">
						<span class="extra-notice-txt">
							<?php echo __( '<b>Heads up!</b> Too many widgets may slowdown Elementor or cause loading issues. Consider disabling unused widgets or <a href="' . Helper_Functions::get_campaign_link( 'https://premiumaddons.com/docs/fix-elementor-editor-panel-loading-issues/', 'premium-addons-for-elementor', 'wp-dash', 'wizard' ) . '" target="_blank">upgrading your PHP memory.</a>', 'premium-addons-for-elementor' ); ?>
						</span>
					</div>
				<?php endif; ?>

				<?php
					$index = 1;
				foreach ( $steps as $step ) {
					$step_cls = 1 === $index ? 'pa-wz-step pa-step-active' : 'pa-wz-step';
					?>
							<div id ="pa-step-<?php echo esc_attr( $index ); ?>" class="<?php echo esc_attr( $step_cls ); ?>">
								<span class="pa-wz-step-index pa-wz-align-items-center pa-wz-justify-content-center"><?php printf( __( '%1$s', 'premium-addons-for-elementor' ), esc_html( $index ) ); ?></span>
								<span class="pa-wz-step-title pa-wz-align-items-center"><?php printf( __( '%1$s', 'premium-addons-for-elementor' ), esc_html( $step ) ); ?></span>
						</div>
						<?php
						++$index;
				}
				?>
			</div>
			<!-- End of Steps -->
			<!-- Step Content -->
			<div class="pa-wz-content-wrappers">
				<?php
					$content_index = 0;
				foreach ( array_keys( $steps ) as $index => $key ) {
					++$content_index;
					$content_cls = 1 === $content_index ? 'pa-wz-step-content' : 'pa-wz-step-content pa-hidden-content';
					?>
							<div id ="pa-step-<?php echo esc_attr( $content_index ); ?>-content" class="<?php echo esc_attr( $content_cls ); ?>">
							<?php include_once PREMIUM_ADDONS_PATH . 'admin/includes/setup-wizard/content-views/' . $key . '.php'; ?>
							</div>
						<?php
				}
				?>
			</div>
			<!-- End of Step Content -->
		</div>

		<?php if ( $render_memory_notice ) : ?>
			<div class="pa-wz-notice-wrapper pa-wz-flex">
				<span class="pa-wz-notice-inner-wrapper pa-wz-flex">
					<?php echo __( '⚠️ <b>RECOMMENDED SETUP</b> Your website needs a higher WP Memeory Limit and PHP Time Limit. <a href="https://premiumaddons.com/upgrade/limits" target="_blank">Learn How to Fix</a>', 'premium-addons-for-elementor' ); ?>
				</span>
			</div>
		<?php endif; ?>

		<!-- Footer -->
		<div class="pa-wz-footer-outer-wrapper pa-wz-flex">
			<span class="pa-divider <?php echo esc_attr( $divider_border ); ?>"></span>
			<div class="pa-wz-footer pa-bt-border-dim pa-wz-flex pa-wz-justify-content-between pa-wz-align-items-center">
				<a class="prev-arrow pa-wz-nav pa-wz-flex pa-wz-align-items-center" type="button" role="button" aria-label="Back" pa-step-id="1">
					<svg xmlns="http://www.w3.org/2000/svg" width="14" height="11.99" viewBox="0 0 14 11.99"><defs><style>.pa-prev-1{fill:#979797;}</style></defs><path id="Left" class="pa-prev-1" d="M0,5.99c0-.53.22-1.03.59-1.4L4.88.29C5.07.1,5.32,0,5.58,0s.52.1.7.29c.09.09.17.2.22.33.05.12.08.25.08.38,0,.13-.03.26-.08.38-.05.12-.13.23-.22.33l-3.29,3.28h10c.27,0,.52.11.71.29.19.19.29.44.29.71s-.11.52-.29.71c-.19.19-.44.29-.71.29H3s3.29,3.29,3.29,3.29c.19.19.29.44.3.71,0,.27-.1.52-.29.71-.19.19-.44.29-.71.3-.27,0-.52-.1-.71-.29L.59,7.4c-.38-.37-.59-.88-.59-1.41Z"/></svg>
					<?php echo esc_html_e( 'Back', 'premium-addons-for-elementor' ); ?>
				</a>
				<a class="next-arrow pa-wz-nav pa-wz-flex pa-wz-align-items-center" type="button" role="button" aria-label="Next" pa-step-id="1">
					<?php echo esc_html_e( 'Next', 'premium-addons-for-elementor' ); ?>
					<svg xmlns="http://www.w3.org/2000/svg" width="14" height="11.99" viewBox="0 0 14 11.99"><defs><style>.pa-next-1{fill:#231f20;}</style></defs><path class="pa-next-1" d="M14,5.99c0-.53-.22-1.03-.59-1.4L9.12.29c-.19-.19-.44-.29-.7-.29s-.52.1-.7.29c-.09.09-.17.2-.22.33-.05.12-.08.25-.08.38s.03.26.08.38c.05.12.13.23.22.33l3.29,3.28H1c-.27,0-.52.11-.71.29-.19.19-.29.44-.29.71s.11.52.29.71c.19.19.44.29.71.29h10l-3.29,3.29c-.19.19-.29.44-.3.71,0,.27.1.52.29.71.19.19.44.29.71.3.27,0,.52-.1.71-.29l4.29-4.3c.38-.37.59-.88.59-1.41Z"/></svg>
				</a>
				<a class="pa-wz-nav pa-wz-flex pa-wz-align-items-center finish-btn" type="button" role="button" aria-label="Next" pa-step-id="1">
					<?php echo esc_html_e( 'Finish', 'premium-addons-for-elementor' ); ?>
				</a>
			</div>
		</div>
		<!-- End of Footer -->
	</div>

