(function ($) {

    $(window).on('elementor/frontend/init', function () {
        // Tabs Handler
        var PremiumTabsHandler = elementorModules.frontend.handlers.Base.extend({

            settings: {},

            getDefaultSettings: function () {
                return {
                    selectors: {
                        premiumTabsElem: '.premium-tabs',
                        navList: '.premium-tabs-nav-list',
                        navListItem: '.premium-tabs-nav-list-item',
                        contentWrap: '.premium-content-wrap',
                        currentTab: '.premium-tabs-nav-list-item.tab-current',
                        currentClass: 'tab-current',
                        tabContent: '.premium-accordion-tab-content'
                    }
                }
            },

            getDefaultElements: function () {
                var selectors = this.getSettings('selectors'),
                    elements = {
                        $premiumTabsElem: this.$element.find(selectors.premiumTabsElem),
                        $navList: this.$element.find(selectors.navList).first(),
                        $contentWrap: this.$element.find(selectors.contentWrap),
                        $navListItem: this.$element.find(selectors.navListItem),
                    };

                return elements;
            },

            bindEvents: function () {
                this.run();
            },

            run: function () {

                var _this = this,
                    $premiumTabsElem = this.elements.$premiumTabsElem,
                    $navList = this.elements.$navList,
                    currentDevice = elementorFrontend.getCurrentDeviceMode(),
                    elementSettings = this.getElementSettings(),
                    selectors = this.getSettings('selectors'),
                    navigation = [];

                //Fix conflict issue when shortcodes are added in tabs content.
                if ('object' === typeof elementSettings.premium_tabs_repeater) {
                    elementSettings.premium_tabs_repeater.forEach(function (item) {
                        navigation.push(item.custom_tab_navigation);
                    });
                }

                this.settings = {
                    id: '#premium-tabs-' + this.$element.data('id'),
                    start: parseInt(elementSettings.default_tab_index),
                    autoChange: elementSettings.autochange,
                    delay: elementSettings.autochange_delay,
                    list: this.elements.$navListItem,
                    carousel: elementSettings.carousel_tabs,
                    accordion: elementSettings.accordion_tabs,
                    tabColor: elementSettings.premium_tab_background_color,
                    activeTabColor: elementSettings.premium_tab_active_background_color
                };

                //apply outline on the tabs
                if (this.settings.activeTabColor) {
                    if ('00' === this.settings.activeTabColor.slice(-2)) {

                        var tabsType = elementSettings.premium_tab_type,
                            borderSide = 'horizontal' === tabsType ? "top" : elementorFrontend.config.is_rtl ? "right" : "left";

                        borderSide += "-color";

                        $premiumTabsElem.find(".premium-tab-arrow").css("border-" + borderSide, "#fff");
                    }
                }

                if (this.settings.carousel) {
                    if (-1 === elementSettings.carousel_tabs_devices.indexOf(currentDevice)) {
                        this.settings.carousel = false;
                        $premiumTabsElem.removeClass("elementor-invisible");
                    }
                }

                //We use another if condition to check the carousel tabs again if disabled on the current device.
                if (this.settings.carousel) {

                    //Make sure slick is initialized before showing tabs.
                    $navList.on('init', function () {
                        $premiumTabsElem.removeClass("elementor-invisible");

                        $premiumTabsElem.find('.carousel-next').on('click', function () {
                            var $nextTab = $premiumTabsElem.find('.tab-current').next();

                            setTimeout(function () {
                                $nextTab.click();
                            }, 500);

                        });

                        $premiumTabsElem.find('.carousel-prev').on('click', function () {
                            var $prevTab = $premiumTabsElem.find('.tab-current').prev();

                            setTimeout(function () {
                                $prevTab.click();
                            }, 500);
                        });
                    });

                    // elementorFrontend.waypoint(
                    //     $navList,
                    //     function () {
                    //         $navList.slick(_this.getSlickSettings());
                    //     }
                    // );

                    // Using IntersectionObserverAPI.
                    var eleObserver = new IntersectionObserver(function (entries) {
                        entries.forEach(function (entry) {
                            if (entry.isIntersecting) {
                                $navList.slick(_this.getSlickSettings());
                                eleObserver.unobserve(entry.target); // to only excecute the callback func once.

                                //Fix arrow pointer not showing on small screens.
                                if ('style1' === elementSettings.premium_tab_style_selected) {

                                    var navListHeight = $navList.find(".slick-list").eq(0).outerHeight();

                                    $navList.find(".slick-list").outerHeight(navListHeight + 10);

                                }
                            }
                        });
                    });

                    eleObserver.observe($navList[0]);

                    $navList.on('click', selectors.navListItem, function () {
                        var tabIndex = $(this).data("slick-index");
                        $navList.slick('slickGoTo', tabIndex);
                    });


                    //activate tab only if carousel tabs number is odd.
                    $navList.on("afterChange", function () {
                        var numberOfTabs = _this.getCarouselTabs();

                        if (1 === numberOfTabs % 2)
                            $navList.find(".premium-tabs-nav-list-item.slick-current").trigger('click');
                    });

                }

                if (this.settings.accordion && elementSettings.accordion_tabs_devices.includes(currentDevice)) {
                    this.$element.find('.premium-tabs, .premium-tabs-nav-list').addClass('premium-accordion-tabs');
                    this.elements.$contentWrap.css('display', 'none');
                } else {
                    new CBPFWTabs($premiumTabsElem, this.settings);
                }


                this.handleRemoteNavigation(navigation, currentDevice);

                $(document).ready(function () {

                    if (_this.settings.accordion && elementSettings.accordion_tabs_devices.includes(currentDevice)) {

                        $premiumTabsElem.find(".premium-content-wrap").remove();
                        _this.changeToAccodrion();

                    } else {
                        //Check this as it conflicts with Elementor swiper.
                        // if ($premiumTabsElem.find(".swiper-container").length < 1) {
                        //The comment removed because it will conflict if the swiper is a media carousel and the images are anchors.
                        $premiumTabsElem.find(".premium-accordion-tab-content").remove();
                        // }

                    }

                    navigation.map(function (item, index) {
                        if (item) {
                            $(item).on("click", function () {

                                if (!_this.settings.carousel) {
                                    var $tabToActivate = $navList.find("li.premium-tabs-nav-list-item").eq(index);

                                    $tabToActivate.trigger('click');
                                } else {
                                    var activeTabHref = _this.elements.$contentWrap.find("section").eq(index).attr("id");

                                    $("a[href=#" + activeTabHref + "]").eq(1).trigger('click');

                                    _this.$element.find(".slick-current").trigger('click');
                                }

                            });
                        }
                    });
                });

            },

            handleRemoteNavigation: function (navigation, currentDevice) {

                // Handle URL parameter for activating a specific tab
                var queryString = window.location.search,
                    urlParams = new URLSearchParams(queryString),
                    targetTab = urlParams.get('tab');

                if (!targetTab)
                    return;

                var _this = this,
                    $premiumTabsElem = this.elements.$premiumTabsElem,
                    selectors = this.getSettings('selectors'),
                    elementSettings = this.getElementSettings(),
                    isAccordion = this.settings.accordion && elementSettings.accordion_tabs_devices.includes(currentDevice),
                    isCarousel = this.settings.carousel,
                    navigationItems = navigation.map(item => item.replace('#', '')),
                    $navListItem = this.elements.$navListItem;

                $navListItem.each(function () {

                    var $this = $(this),
                        dataIndex = $this.data('list-index'),
                        tabDataIndex = $this.find('a').attr('href').replace('#', '');

                    navigationItems.forEach((nav, index) => {

                        if (!$this.hasClass('tab-current') && nav === targetTab && parseInt(dataIndex) === index) {

                            $navListItem.removeClass('tab-current');
                            $this.addClass('tab-current');

                            // Normal tabs mode
                            if (!isAccordion && !isCarousel) {

                                _this.elements.$contentWrap.find("section").removeClass('content-current');

                                _this.elements.$contentWrap.find('#' + tabDataIndex).addClass('content-current');

                            } else if (isAccordion) {

                                // Accordion mode
                                var contentId = $this.data('content-id'),
                                    $content = $premiumTabsElem.find(contentId);

                                if ($content.length) {
                                    $premiumTabsElem.find(selectors.tabContent).stop().slideUp();
                                    $content.stop().slideDown();
                                }

                            } else if (isCarousel) {

                                var sectionTab = _this.elements.$contentWrap.find("section"),
                                    $navList = _this.elements.$navList;

                                sectionTab.removeClass('content-current');

                                sectionTab.each(function () {
                                    var $thisSection = $(this);

                                    if ($thisSection.attr('id') === tabDataIndex) {
                                        $thisSection.addClass('content-current');
                                    }
                                });

                                setTimeout(function () {

                                    if (!$navList.hasClass('slick-initialized'))
                                        $navList.slick(_this.getSlickSettings());

                                    $navList.slick('slickGoTo', parseInt(dataIndex));

                                    $navListItem.removeClass('tab-current');
                                    $this.addClass('tab-current');

                                }, 100);

                            }
                        }

                    });
                });

            },

            getCarouselTabs: function () {
                var elementSettings = this.getElementSettings(),
                    currentDevice = elementorFrontend.getCurrentDeviceMode(),
                    numberofTabs = 5;

                switch (true) {
                    case currentDevice.includes('mobile'):
                        numberofTabs = elementSettings.tabs_number_mobile;
                        break;
                    case currentDevice.includes('tablet'):
                        numberofTabs = elementSettings.tabs_number_tablet;
                        break;
                    default:
                        numberofTabs = elementSettings.tabs_number;
                        break;
                }

                return numberofTabs;

            },

            getSlickSettings: function () {

                var elementSettings = this.getElementSettings(),
                    prevArrow = '<a type="button" data-role="none" class="carousel-arrow carousel-prev" aria-label="Next" role="button" style=""><i class="fas fa-angle-left" aria-hidden="true"></i></a>',
                    nextArrow = '<a type="button" data-role="none" class="carousel-arrow carousel-next" aria-label="Next" role="button" style=""><i class="fas fa-angle-right" aria-hidden="true"></i></a>',
                    slides_tab = elementSettings.tabs_number_tablet,
                    slides_mob = elementSettings.tabs_number_mobile,
                    spacing_tab = elementSettings.slides_spacing_tablet,
                    spacing_mob = elementSettings.slides_spacing_mobile;

                return {
                    infinite: true,
                    autoplay: false,
                    rows: 0,
                    dots: false,
                    useTransform: true,
                    centerMode: true,
                    draggable: false,
                    slidesToShow: elementSettings.tabs_number || 5,
                    responsive: [{
                        breakpoint: 1025,
                        settings: {
                            slidesToShow: slides_tab,
                            centerPadding: spacing_tab + "px",
                            nextArrow: elementSettings.carousel_arrows_tablet ? nextArrow : '',
                            prevArrow: elementSettings.carousel_arrows_tablet ? prevArrow : '',
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: slides_mob,
                            centerPadding: spacing_mob + "px",
                            nextArrow: elementSettings.carousel_arrows_mobile ? nextArrow : '',
                            prevArrow: elementSettings.carousel_arrows_mobile ? prevArrow : '',
                        }
                    }
                    ],
                    rtl: elementorFrontend.config.is_rtl,
                    nextArrow: elementSettings.carousel_arrows ? nextArrow : '',
                    prevArrow: elementSettings.carousel_arrows ? prevArrow : '',
                    centerPadding: elementSettings.slides_spacing + "px",
                }

            },

            changeToAccodrion: function () {

                var $premiumTabsElem = this.elements.$premiumTabsElem,
                    _this = this,
                    $navListItem = this.elements.$navListItem,
                    elementSettings = this.getElementSettings(),
                    selectors = this.getSettings('selectors'),
                    accDur = elementSettings.accordion_tabs_anim_duration,
                    queryString = window.location.search,
                    urlParams = new URLSearchParams(queryString),
                    targetTab = urlParams.get('tab'),
                    scrollAfter = elementSettings.accordion_animation;

                if (!targetTab) {
                    if (-1 !== this.settings.start) {
                        $premiumTabsElem.find(".premium-tabs-nav-list-item:eq(" + this.settings.start + ")").addClass("tab-current");
                    }

                }

                var contentId = $premiumTabsElem.find(selectors.currentTab).data('content-id');

                $premiumTabsElem.find('.premium-accordion-tab-content:not(' + contentId + ')').slideUp(accDur, 'swing');

                $navListItem.click(function () {

                    var $clickedTab = $(this);

                    if ($clickedTab.hasClass(selectors.currentClass)) {

                        $clickedTab.toggleClass(selectors.currentClass);

                        _this.$element.find($clickedTab.data('content-id')).slideUp(accDur, 'swing');

                    } else {

                        $navListItem.removeClass(selectors.currentClass);

                        $clickedTab.toggleClass(selectors.currentClass);

                        _this.$element.find(selectors.tabContent).slideUp(accDur, 'swing');

                        _this.$element.find($clickedTab.data('content-id')).slideDown(accDur, 'swing');
                    }

                    if (scrollAfter) {
                        setTimeout(function () {
                            $('html, body').animate({
                                scrollTop: $clickedTab.offset().top - 100
                            }, 1000);
                        }, accDur === 'slow' ? 700 : 400);
                    }

                });

            }

        });

        window.CBPFWTabs = function (t, settings) {

            var self = this,
                id = settings.id,
                i = settings.start,
                isClicked = false,
                canNavigate = true;

            self.el = t;

            self.options = {
                start: i
            };

            self.extend = function (t, s) {
                for (var i in s) s.hasOwnProperty(i) && (t[i] = s[i]);
                return t;
            };

            self._init = function () {

                self.tabs = $(id).find(".premium-tabs-nav").first().find("li.premium-tabs-nav-list-item");
                self.carouselTabs = $(id).find('.premium-tabs-nav-list').first();

                self.current = -1;

                //No tabs will be active by default.
                if (-1 !== self.options.start) {
                    self._show(id);
                }

                self._initEvents();

                if (settings.autoChange) {
                    self.runAutoNavigation();
                }

                if (settings.carousel) {
                    self.carouselTabs.on('beforeChange', function () {
                        canNavigate = false;
                    });

                    self.carouselTabs.on('afterChange', function () {
                        canNavigate = true;
                    });

                }
            };

            self._initEvents = function () {

                self.tabs.each(function (index, tab) {

                    var listIndex = $(tab).data("list-index");

                    $(tab).find("a.premium-tab-link").on("click", function (s) {
                        s.preventDefault();
                    });

                    $(tab).on("click", function (s) {

                        //If a tab is clicked by the user, not auto navigation
                        if (s.originalEvent)
                            isClicked = true;

                        s.preventDefault();

                        //If tab is clicked twice
                        if ($(tab).hasClass("tab-current"))
                            return;

                        self._show(id, listIndex, tab);
                    });
                });
            };

            self._show = function (id, tabIndex, tab) {

                self.items = $(id).find(".premium-content-wrap").first().find("> section");
                self.tabs = $(id).find(".premium-tabs-nav").first().find("li.premium-tabs-nav-list-item");

                if (!canNavigate)
                    return;

                if (self.current >= 0) {
                    self.tabs.removeClass("tab-current");
                    self.items.removeClass("content-current");
                }

                self.current = tabIndex;

                //Activate the first tab if no tab is clicked yet
                if (void 0 == tabIndex) {
                    self.current = self.options.start >= 0 && self.options.start < self.items.length ? self.options.start : 0;
                    //tab = settings.carousel ? self.tabs.filter(".slick-center:not(.slick-cloned)") : self.tabs[self.current];
                    if (settings.carousel) {
                        tab = self.current >= 0 ? self.tabs.eq(self.current) : self.tabs.filter(".slick-center:not(.slick-cloned)");
                    } else {
                        tab = self.tabs.eq(self.current);
                    }
                }

                self.tabs.removeClass("premium-zero-height");

                if (settings.carousel) {

                    //We need to make sure slick has been initialized before adding the active tab.
                    var checkSlick = setInterval(function () {
                        if (self.carouselTabs.hasClass('slick-initialized')) {
                            clearInterval(checkSlick);
                            var $currentActivetab = $(tab);
                            $currentActivetab.addClass("tab-current");
                            $currentActivetab.trigger('click');
                        }
                    }, 100);

                } else {
                    $(tab).addClass("tab-current");

                }

                var $activeContent = self.items.eq(self.current);

                $activeContent.addClass("content-current");

                if ($('.premium-mscroll-yes').length < 1 && $('.premium-hscroll-outer-wrap').length < 1)
                    window.dispatchEvent(new Event('resize'));

                //Fix Media Grid height issue.
                if ($activeContent.find(".premium-gallery-container").length > 0) {
                    var $mediaGrid = $activeContent.find(".premium-gallery-container"),
                        layout = $mediaGrid.data("settings").img_size;

                    setTimeout(function () {

                        if ('metro' === layout) {
                            $mediaGrid.trigger('resize');
                        } else {
                            $mediaGrid.isotope("layout");
                        }

                    }, 100);

                }

                if (self.items.find(".slick-slider").length > 0)
                    self.items.find(".slick-slider").slick('pause').slick('freezeAnimation');

                if ($activeContent.find(".slick-slider").length > 0) {

                    setTimeout(function () {

                        $activeContent.find(".slick-slider").slick("play").slick("resumeAnimation");

                        $activeContent.find(".slick-slider").slick('setPosition').slick('setPosition');
                    }, 100);

                }

                //Make sure videos are paused
                if (self.items.find("video").length > 0) {
                    self.items.not(".content-current").find("video").each(function (index, elem) {
                        $(elem).get(0).pause();
                    });

                    self.items.not(".content-current").find('.playing').removeClass('playing');
                }

                if (self.items.find("iframe").length > 0) {
                    self.items.not(".content-current").find("iframe").each(function (index, elem) {

                        var source = $(elem).parent().attr("data-src");

                        $(elem).attr("src", source);
                    });
                }

            };

            self.runAutoNavigation = function () {

                var $navListItem = settings.list,
                    index = settings.start > 0 ? settings.start : 0;

                var autoChangeInterval = setInterval(function () {

                    //If user clicks a tab, then stop auto navigation.
                    if (isClicked) {
                        clearInterval(autoChangeInterval);
                        return;
                    }

                    index++;

                    if (index > $navListItem.length - 1)
                        index = 0;

                    $navListItem.eq(index).trigger('click');
                }, settings.delay * 1000);

            };

            self.options = self.extend({}, self.options);
            self.extend(self.options, i);
            self._init();

        };

        elementorFrontend.elementsHandler.attachHandler('premium-addon-tabs', PremiumTabsHandler);
    });
})(jQuery);