<?php

function save_colorbox_template($template) {
	global $colorbox_templates;
	$template_key = null;
	foreach ($colorbox_templates as $k => $colorbox_template) {
		if ($colorbox_template['template_id'] == $template['template_id']) {
			$template_key = $k;
		}
	}
	if ($template_key !== null) {
		$tmp = $colorbox_templates[$template_key];
		$colorbox_templates[$template_key] = $template;

		$colorbox_templates[$template_key]['active'] = $tmp['active'];
	} else {
		$colorbox_templates []= $template;
	}
	scp_set_option('colorbox_templates', $colorbox_templates);
}

function get_colorbox_template_key($template_id) {
	global $colorbox_templates;
	$template_key = null;
	foreach ($colorbox_templates as $k => $colorbox_template) {
		if ($colorbox_template['template_id'] == $template_id) {
			$template_key = $k;
		}
	}
	return $template_key;
}


$colorbox_templates = scp_get_option('colorbox_templates') ?: array();

if (isset($_POST['toggle_active_colorbox_template'])) {
	$template_key = get_colorbox_template_key($_POST['toggle_active_colorbox_template']);
	if ($template_key !== null) {
		$colorbox_templates[$template_key]['active'] = !$colorbox_templates[$template_key]['active'];
		scp_set_option('colorbox_templates', $colorbox_templates);
	}
} else if (isset($_FILES['import_colorbox_templates'])) {
	if ($file = $_FILES['import_colorbox_templates']['tmp_name']) {
		if (file_exists($file)) {
			$xml = simplexml_load_file($file);	 
		}
	}

	if ($xml) {
		$xml = json_decode(json_encode($xml), true);
		foreach ($xml as $name => $v) {
			if (is_array($v)) {
				save_colorbox_template($v);
			}
		}
	} else {
		echo 'Failed to open XML-file<script>top.location="/wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php";</script>';
		die();
	}
} else if (isset($_POST['save_colorbox_template'])) {
	$template = json_decode(urldecode($_POST['save_colorbox_template']), true);
	save_colorbox_template($template);
} else if (isset($_POST['create_new_colorbox_template'])) {
	$new_template = json_decode(urldecode($_POST['create_new_colorbox_template']), true);

	// get last key index for setting template_id
	end($colorbox_templates);
	$key = key($colorbox_templates);

	$new_template['template_id'] = $key + 1;
	save_colorbox_template($new_template);
} else if (isset($_GET['delete_colorbox_template'])) {
	$template_key = get_colorbox_template_key($_GET['delete_colorbox_template']);
	if ($template_key !== null) {
		unset($colorbox_templates[$template_key]);
		scp_set_option('colorbox_templates', $colorbox_templates);
	}
} else if (isset($_GET['duplicate_colorbox_template'])) {
	$template_key = get_colorbox_template_key($_GET['duplicate_colorbox_template']);
	if ($template_key !== null) {
		$copy_template = $colorbox_templates[$template_key];
		$copy_template['template_id'] = time()*1000;
		save_colorbox_template($copy_template);
		header('Location: /wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php');
		die();
	}
}


function print_colorbox_template_example_iframe($colorbox) {
	echo '<iframe scrolling="yes" width="100%" height="300" src="/wp-content/plugins/sharketing-content-pimper/colorbox-iframe.php?_before_after_text=0&' . http_build_query($colorbox) . '"/></iframe>';
}

?>
<script>
(function($) {
	$(document).on('click', '#scp-save-colorbox-button', function() {
		var settings = scp_get_colorbox_params();
		$('<form method="POST"><input type="hidden" name="save_colorbox_template" value="' + encodeURIComponent(JSON.stringify(settings)) + '"></form>').appendTo('body').submit();
	});

	$(document).on('mousedown', '#scp-add-colorbox-button', function(e) {
		e.preventDefault();
		scp_close_thickbox();

		var name = prompt('Name of colorbox template:', '');
		if (!name) name = 'template' + (+new Date);
		var settings = scp_get_colorbox_params();
		settings.template_name = name;
		$('<form method="POST"><input type="hidden" name="create_new_colorbox_template" value="' + encodeURIComponent(JSON.stringify(settings)) + '"></form>').appendTo('body').submit();
	});
})(jQuery);
function edit_colorbox_template(props) {
	scp_button_modal('colorbox',false,true);
	jQuery('#scp-add-colorbox-button').hide();
	jQuery('#scp-save-colorbox-button, .show-colorbox-template-edit').show();
	scp_colorbox_modal_fill(props);
	scp_resize_thickbox();
}
function create_colorbox_template() {
	jQuery('#scp-add-colorbox-button').show();
	jQuery('#scp-save-colorbox-button, .show-colorbox-template-edit').hide();
	scp_colorbox_modal_fill({});
	scp_button_modal('colorbox',false,true);
}
function toggle_active_colorbox_template(template_id) {
	jQuery('<form method="POST"><input type="hidden" name="toggle_active_colorbox_template" value="' + template_id + '"></form>').appendTo('body').submit();
}
</script>

<form action="" method="post" enctype="multipart/form-data" style="position:absolute;width:1px;height:1px;opacity:0;top:-99999px;">
<input type="file" name="import_colorbox_templates" id="import_colorbox_templates" onchange="this.parentNode.submit()" style="position:absolute;width:1px;height:1px;opacity:0;top:-99999px;">
</form>
			
<h3 style="margin-bottom:0px">Colorboxes (<?php echo count($colorbox_templates); ?>)
<button class="button" type="button" onclick="create_colorbox_template()">Create new template</button>
<button class="button" type="button" onclick="jQuery('#import_colorbox_templates').click()">Import templates</button>
<a class="button" type="button" href="/wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php&scp_export_colorbox_templates=all">Export templates</a>

</h3>
<?php foreach ($colorbox_templates as $colorbox_template) { ?>
	<div style="width:40%;float:left;background:#cdcdcd;padding:1%;margin:1%;">
		<?php if (!$colorbox_template['active']) { ?><a href="/wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php&delete_colorbox_template=<?php echo $colorbox_template['template_id']; ?>" onclick="if(!confirm('Are you sure? Do you want to delete this template?'))return false;" class="button" style="float:right">Delete</a><?php } ?>
		<a href="/wp-admin/options-general.php?page=sharketing-content-pimper%2Foptions.php&duplicate_colorbox_template=<?php echo $colorbox_template['template_id']; ?>" class="button" style="float:right;<?php if (!$colorbox_template['active']) { ?>margin-right:10px;<?php } ?>">Duplicate</a>
		<a href="javascript:;" onclick='edit_colorbox_template(<?php echo json_encode($colorbox_template); ?>)' class="button" style="float:right;margin-right:10px;">Edit</a>						
		<label style="float:right;margin-right:10px;line-height:25px;"><input type="checkbox" <?php checked($colorbox_template['active']); ?> onchange="toggle_active_colorbox_template(<?php echo $colorbox_template['template_id']; ?>)">Active</label>
		<h2 style="padding:0px;"><?php echo $colorbox_template['template_name']; ?> <span style="font-size:11px">(template id:<?php echo $colorbox_template['template_id']; ?>)</span></h2>
		<br><?php print_colorbox_template_example_iframe($colorbox_template); ?>
	</div>
<?php } ?>