<?php

function scp_introtext($content, $ignore_introtext = false) {
	$introtext_settings = scp_get_option('introtext_settings') ?: array();
	if (isset($introtext_settings['scp-introtext-enabled'])) {
		$contains_nointro_tag = strpos($content, '[no_intro]') !== false || strpos($content, '[no_introtext]') !== false;
		$content = str_replace(array('[no_intro]', '[no_introtext]'), '', $content);
		if (!$ignore_introtext && !$contains_nointro_tag) {
			$content = get_post_field('post_content', get_the_ID());
			$has_more_tag_html = strpos($content, 'id="more-' . get_the_ID()) !== false;
			if (strpos($content, '<!--more-->') !== false || $has_more_tag_html) {
				$content_arr = get_extended($content);
				$introtext = scp_create_introtext($content_arr['main']);
				//$more_tag = '<!--more-->';
				//if ($has_more_tag_html)
				$more_tag = '<p><span id="more-' . get_the_ID() . '"></span></p>';
			
				if (is_singular(get_post_type())) {
					// if single post show full content (aka introtext + more tag + extended)
					return $introtext . $more_tag . $content_arr['extended'];
				} else {
					// if not single post show only introtext + more tag
					return $introtext . $more_tag;
				}
			}
		}
	}
	return $content;
}
add_filter('the_content', 'scp_introtext', 0, 2);

function scp_create_introtext($content) {
	$introtext_settings = scp_get_option('introtext_settings') ?: array();

	if (!$introtext_settings['scp-introtext-enabled']) return $content;

	$fontsize = $introtext_settings['scp-introtext-fontsize'] ?: 2;
	$fontsize += get_theme_mod('content_fontsize_paragraph');

	if(isset($introtext_settings['scp-introtext-first-char-big'])) {		
		//$content = strip_tags($content);

		// make first character bigger
		$lines = 3;
		$ratio = 1.235294117647059;
		$first_char_size = $introtext_settings['scp-introtext-first-char-size'] > 0 ? $introtext_settings['scp-introtext-first-char-size'] : $fontsize*$lines*$ratio;
		//$first_char = $content{0};
		$color_html = $introtext_settings['scp-introtext-first-char-color'] ? 'color:' . $introtext_settings['scp-introtext-first-char-color'] . ';' : '';
		$first_char_content = '<div class="scp-introtext-first-char" style="font-size:' . $first_char_size . 'px;line-height:' . ($first_char_size*.8) . 'px;padding-right:5px;margin-left:-2px;position:relative;' . $color_html . '"></div>';
		//$content = $first_char_content . substr($content, 1);
		$content = $first_char_content . $content;
	}

	$bold_style = '';
	if (isset($introtext_settings['scp-introtext-bold'])) {
		$bold_style = 'font-weight:bold;';
	}

	$introtext_content = '<div class="scp-introtext">' . wpautop($content) . '</div><style>.scp-introtext,.scp-introtext>p,.scp-introtext ul li{font-size:' . $fontsize . 'px;line-height:' . ($fontsize*1.2) . 'px;' . $bold_style . '}</style>';
	return $introtext_content;
}