<?php

if (!class_exists('mealLoader')) {

	class mealLoader {
		
		function __construct() {
			$this->load_options();
			if (is_admin()) {	
				require_once(dirname (__FILE__) . '/admin.php');
				$this->mealAdminPanel = new mealAdminPanel($this);
			} else {
				require_once(dirname (__FILE__) . '/meal-add-anchor-links.php');
				$this->mealAddAnchorLinks = new mealAddAnchorLinks($this);
			}
			register_activation_hook(__FILE__, array(&$this, 'install'));
		}

		function load_options() {
			$this->options = get_option('meal_options');
		}

		function save_options(array $options = null) {
			update_option('meal_options', $options ?: $this->options);
		}

		function get_option($option) {
			return $this->options[$option];
		}

		function set_option($option, $val) {
			$this->options[$option] = $val;
			$this->save_options();
		}		

		function get_the_post() {
			return get_post(get_the_ID() ?: $_GET['post']);
		}

		function install() {
			if (!$this->options || count($this->options) == 0) {
				$this->options = array(
					'activate_clear_both_css' => false,
					'display_title' => '<b>Contents:</b>',
					'showtags' => 'No, I will do it manually with the shortcode',
					'noMoreTag' => 'Then don`t add anchor links there',
					'anchorCount' => 1,
					'is_single' => true,
					'is_page' => true,
					'is_numbering' => true,
					'head_start' => 1,
					'head_end' => 3,
					'use_heading_indent' => true

				);
				$this->save_options();
			}
		}

		function show_error($message) {
			echo '<div class="wrap"><h2></h2><div class="error" id="error"><p>' . $message . '</p></div></div>' . "\n";
		}
		
		function show_message($message) {
			echo '<div class="wrap"><h2></h2><div class="updated fade" id="message"><p>' . $message . '</p></div></div>' . "\n";
		}
	
	}
	//Start Loader
	global $mealLoader;
	$mealLoader = new mealLoader();
}