<?php

add_filter('scp_pimper_options', function($options) {
	$options['list'] = 'Lijst';
	return $options;
});

add_action('scp_pimper_option_list', function() {
	$icons = explode(' ', 'arrow-circle-right arrow-right check check-circle chevron-circle-right exclamation-circle exclamation-triangle hand-o-right thumbs-down thumbs-o-down thumbs-o-up thumbs-up times times-circle');

?>

	<h3>1. Choose your bulletpoint</h3>
	<div style="float:left;width:30%;"><label><input type="radio" name="scp-list-icon-option" value="" checked /> (default)</label></div>
	<?php foreach ($icons as $icon) { ?>
		<div style="float:left;width:30%;"><label><input type="radio" name="scp-list-icon-option" value="<?php echo $icon; ?>" /> <i class="fa fa-<?php echo $icon; ?>"></i></label></div>
	<?php } ?>

	<div style="clear:both;"></div>

	<h3>2. Select color</h3>
	<div><label><input type="radio" name="scp-list-icon-color" value="" checked /> (default)</label></div>
	<div><label><input type="radio" name="scp-list-icon-color" value="00B200" /> <div style="width:12px;height:12px;background-color:#00B200;border-radius:4px;display:inline-block;"></div></label></div>
	<div><label><input type="radio" name="scp-list-icon-color" value="D90000" /> <div style="width:12px;height:12px;background-color:#D90000;border-radius:4px;display:inline-block;"></div></label></div>
	<div><label><input type="radio" name="scp-list-icon-color" value="999999" /> <div style="width:12px;height:12px;background-color:#999999;border-radius:4px;display:inline-block;"></div></label></div>
	<div><input type="radio" name="scp-list-icon-color" value="color_picker" /> <input type="text" id="scp-list-icon-color-picker" name="scp-list-icon-color-picker" /></div>

	<h3>3. Live example</h3>
	<iframe id="scp-list-example" src="" width="100%" height="300"></iframe>

	<input class="button button-primary button-large" id="scp-add-list-button" value="Add list" type="button">
	<input class="button button-large" id="scp-remove-list-button" value="Remove list" type="button" style="margin-left:15px;display:none;">

	<a id="scp-list-modal-button" href="#TB_inline?width=600&height=700&inlineId=scp-list-modal" class="thickbox"></a>
	<!--<style>
		#scp-list-modal-content .wp-picker-container {
			position: absolute;
			background: white;
		}
	</style>-->
	<script>
		(function($) {
			$('[name="scp-list-icon-option"]').on('change', function() {
				var selected = $('[name="scp-list-icon-option"]:checked').val();
				if (selected == '') {
					$('[name="scp-list-icon-color"][value=""]').prop('checked', true);
				} else if (selected == 'check') {
					$('[name="scp-list-icon-color"][value="00B200"]').prop('checked', true);
				} else if (selected == 'exclamation-circle' || selected == 'exclamation-triangle' || selected == 'times' || selected == 'times-circle') {
					$('[name="scp-list-icon-color"][value="D90000"]').prop('checked', true);
				}
			});

			$('#scp-list-icon-color-picker').wpColorPicker({change: function() {
				setTimeout(function() {
					$('[name="scp-list-icon-color"][value="color_picker"]').prop('checked', true).trigger('change');
				});
			}});
		})(jQuery);
	</script>
<?php
});

function sharketing_content_pimper_list($atts, $content) {
	$uid = 'scplist' . uniqid();

	if ($atts['icon_color'] && $atts['icon_color'][0] != '#') {
		$atts['icon_color'] = '#' . $atts['icon_color'];
	}

	if ($icon = $atts['icon']) {
		$icon_color_style = '<style>#' . $uid . ' ul li .fa {';
		
		$icon_color_style .= 'color:' . ($atts['icon_color'] ?: get_theme_mod('content_color_bulletpoints')) . ';font-size:' . (get_theme_mod('content_fontsize_paragraph') + 2) . 'px;left:' . (2-get_theme_mod('content_fontsize_paragraph')) . 'px;';
		
		$icon_color_style .= '}</style>';
		
		$icon_html = '<i class="fa fa-' . $icon . '"></i>';
		$content = str_replace('</li>', $icon_html . '</li>', $content);
	} else {
		// default bulletpoint is used, so only set color
		if ($icon_color = $atts['icon_color']) {
			$icon_color_style = '<style>#' . $uid . ' ul li:before {';
			$icon_color_style .= 'content: url("/wp-content/themes/senhtheme/bulletpoint.php?size=' . get_theme_mod('content_thickness_bulletpoints') . '&color=' . urlencode($icon_color) . '");';
			$icon_color_style .= '</style>';
		}
	}

	// remove empty paragraph
	$content = str_replace(array('<p>', '</p>'), '', $content);

	$content = '<div id="' . $uid . '" class="scp-list' . ($icon ? ' scp-iconized' : '') . '">' . $content . '</div>' . $icon_color_style;

	return $content;
}
add_shortcode('list', 'sharketing_content_pimper_list');

add_action('wp_enqueue_scripts', function() {
    wp_enqueue_style('font-awesome', plugins_url('fontawesome/css/fontawesome.min.css', __FILE__));
});

add_action('admin_enqueue_scripts', function() {
	add_thickbox();
	wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('scp-list', plugin_dir_url( __FILE__ ) . 'list.js', array('jquery', 'wp-color-picker'));
	wp_enqueue_style('sharketing-content-pimper', plugins_url('style.css', __FILE__));	
	wp_enqueue_style('font-awesome', plugins_url('fontawesome/css/fontawesome.min.css', __FILE__));
});

function sharketing_content_pimper_list_modal() {

	$icons = explode(' ', 'arrow-circle-right arrow-right check check-circle chevron-circle-right exclamation-circle exclamation-triangle hand-o-right thumbs-down thumbs-o-down thumbs-o-up thumbs-up times times-circle');

?>
	<div id="scp-list-modal" style="display:none;">
		<div id="scp-list-modal-content">
			<h3>1. Choose your bulletpoint</h3>
			<div style="float:left;width:30%;"><label><input type="radio" name="scp-list-icon-option" value="" checked /> (default)</label></div>
			<?php foreach ($icons as $icon) { ?>
				<div style="float:left;width:30%;"><label><input type="radio" name="scp-list-icon-option" value="<?php echo $icon; ?>" /> <i class="fa fa-<?php echo $icon; ?>"></i></label></div>
			<?php } ?>

			<div style="clear:both;"></div>

			<h3>2. Select color</h3>
			<div><label><input type="radio" name="scp-list-icon-color" value="" checked /> (default)</label></div>
			<div><label><input type="radio" name="scp-list-icon-color" value="00B200" /> <div style="width:12px;height:12px;background-color:#00B200;border-radius:4px;display:inline-block;"></div></label></div>
			<div><label><input type="radio" name="scp-list-icon-color" value="D90000" /> <div style="width:12px;height:12px;background-color:#D90000;border-radius:4px;display:inline-block;"></div></label></div>
			<div><label><input type="radio" name="scp-list-icon-color" value="999999" /> <div style="width:12px;height:12px;background-color:#999999;border-radius:4px;display:inline-block;"></div></label></div>
			<div><input type="radio" name="scp-list-icon-color" value="color_picker" /> <input type="text" id="scp-list-icon-color-picker" name="scp-list-icon-color-picker" /></div>

			<h3>3. Live example</h3>
			<iframe id="scp-list-example" src="" width="100%" height="300"></iframe>

			<input class="button button-primary button-large" id="scp-add-list-button" value="Add list" type="button">
			<input class="button button-large" id="scp-remove-list-button" value="Remove list" type="button" style="margin-left:15px;display:none;">
		</div>
	</div>
	<a id="scp-list-modal-button" href="#TB_inline?width=600&height=700&inlineId=scp-list-modal" class="thickbox"></a>
	<style>
		#scp-list-modal-content .wp-picker-container {
			position: absolute;
			background: white;
		}
	</style>
	<script>
		(function($) {
			$('[name="scp-list-icon-option"]').on('change', function() {
				var selected = $('[name="scp-list-icon-option"]:checked').val();
				if (selected == '') {
					$('[name="scp-list-icon-color"][value=""').prop('checked', true);
				} else if (selected == 'check') {
					$('[name="scp-list-icon-color"][value="00B200"').prop('checked', true);
				} else if (selected == 'exclamation-circle' || selected == 'exclamation-triangle' || selected == 'times' || selected == 'times-circle') {
					$('[name="scp-list-icon-color"][value="D90000"').prop('checked', true);
				}
			});

			$('#scp-list-icon-color-picker').wpColorPicker({change: function() {
				setTimeout(function() {
					$('[name="scp-list-icon-color"][value="color_picker"').prop('checked', true).trigger('change');
				});
			}});
		})(jQuery);
	</script>
<?php
}
//add_action('admin_footer', 'sharketing_content_pimper_list_modal');

add_action('wp_footer', function() {
?>
<style>
.scp-list ul li .fa {
	line-height: <?php echo get_theme_mod('content_lineheight_paragraph', 19); ?>px;
}
</style>
<?php
});