<?php
/*
Plugin Name: Sharketing Content Pimper
Plugin URI: http://sharketing.nl/
Description: Create more dynamic content
Author: sharketing
Version: 0.3.29
Author URI: http://sharketing.nl/?scp
*/

require_once(dirname(__FILE__) . '/admin.php');
require_once(dirname(__FILE__) . '/videolist.php');
require_once(dirname(__FILE__) . '/list.php');
require_once(dirname(__FILE__) . '/quote.php');
require_once(dirname(__FILE__) . '/headers.php');
require_once(dirname(__FILE__) . '/blogposts.php');
require_once(dirname(__FILE__) . '/introtext.php');

require_once(dirname(__FILE__) . '/scp-button.php');
require_once(dirname(__FILE__) . '/colorbox.php');
require_once(dirname(__FILE__) . '/textcolor.php');
require_once(dirname(__FILE__) . '/column.php');
require_once(dirname(__FILE__) . '/table.php');

require_once(dirname(__FILE__) . '/anchor-links/anchor-links.php');
require_once(dirname(__FILE__) . '/featured-image-blogposts/featured-image-blogposts.php');

function scp_add_style() {
	wp_enqueue_style('sharketing-content-pimper', plugins_url('style.css', __FILE__));
	wp_enqueue_script('sharketing-content-pimper-frontend', plugins_url('scp-frontend.js', __FILE__));
}
add_action('wp_enqueue_scripts', 'scp_add_style', 50);

function scp_parse_colorcss($color) {
	if (preg_match('/^[a-f0-9]{6}$/i', $color)) return '#' . $color;
	return $color;
}

function scp_add_editor_styles() {
    add_editor_style(plugins_url('editor-style.css', __FILE__));
}
add_action('admin_init', 'scp_add_editor_styles');

add_action('admin_footer', function() {
?><script>var scp_codes = <?php echo json_encode(array_keys(apply_filters('scp_pimper_options', array()))); ?>;</script><?php
});

add_filter('the_content', function($content) {
	// remove empty lines
	$content = str_replace(array('<p></p>', '<br />', '<p class="scp-code scp-code-start">', '<p class="scp-code scp-code-end">'), '', $content);
	$content = str_replace('"></p>', '">', $content);
	$content = str_replace('v></p>', 'v>', $content);
	return $content;
}, 99);