<?php

function sharketing_content_pimper_videolist($atts) {
	global $scp_playvideo_js_init;

	$atts['width'] = $atts['width'] ?: '314';
	$atts['height'] = $atts['height'] ?: '157';

	$videolist = '';

	if (!$scp_playvideo_js_init) {
		$scp_playvideo_js_init = true;
	}
	
	ksort($atts);

	$videos = sharketing_content_pimper_videolist_get_videos($atts);


	$videolist .= sharketing_content_pimper_videolist_embed($atts['width'], $atts['height']);
	$videolist .= sharketing_content_pimper_videolist_list($videos, $atts['width'], $atts['height']);

	return $videolist;
}
add_shortcode('videolist', 'sharketing_content_pimper_videolist');

function sharketing_content_pimper_videolist_get_videos($atts) {
	$videos = array();
	foreach ($atts as $k => $v) {
		if (strpos($k, 'video') !== false) {
			$parts = explode('|', $v);
			$type = isset($parts[2]) ?: 'youtube';
			$videos[$type . '_' . $parts[1]] = $parts[0];
		}
	}
	return $videos;
}

function sharketing_content_pimper_videolist_embed($width, $height) {
	$embed = '<div class="scp-video" style="width:' . (is_numeric($width) ? $width . 'px' : $width) . ';height:' . (is_numeric($height) ? $height . 'px' : $height) . ';"><div class="scp-video-embed"></div></div>';
	return $embed;
}

function sharketing_content_pimper_videolist_list($videos, $width, $height) {
	$list = '<ul class="scp-videolist">';
	foreach ($videos as $video_id => $name) {
		$p = explode('_', $video_id);
		$video_id = $p[1];
		$video_type = $p[0];
		$list .= '<li><a href="javascript:;" onclick="scp_playvideo(this, \'' . $video_type . '\', \'' . $video_id . '\', \'' . $width . '\', \'' . $height . '\')" class="scp-videolist-li">' . $name . '</a></li>';
	}
	$list .= '</ul>';
	return $list;
}

function sharketing_content_pimper_js_init() {
	return '<script>function scp_playvideo(el,videoType,videoId, width, height){var $ = jQuery;var videoUrl=videoType=="youtube"?"//www.youtube.com/embed/" + videoId + "?rel=0&showinfo=0&controls=0&modestbranding=true&showinfo=0":"//fast.wistia.net/embed/iframe/" + videoId;$(el).closest(\'.scp-videolist\').prev().find(\'.scp-video-embed\').fadeOut(400, function(){$(el).closest(\'.scp-videolist\').prev().html(\'<div class="scp-video-embed" style="display:none;"><iframe width="\' + width + \'" height="\' + height + \'" src="\' + videoUrl + \'" frameborder="0" allowfullscreen></iframe></div>\');$(el).closest(\'.scp-videolist\').prev().find(\'.scp-video-embed\').delay(100).fadeIn(800);});$(el).parent().parent().children().removeClass(\'current\');$(el).parent().addClass(\'current\');}jQuery(function() {jQuery(\'.scp-videolist\').each(function(){jQuery(this).children().first().children().first().trigger(\'click\');});})</script>';
}
add_action('wp_footer', function() {
	global $scp_playvideo_js_init;
	if ($scp_playvideo_js_init) {
		echo sharketing_content_pimper_js_init();
	}
});