<?php
/*
Plugin Name: Sharketing Easy Post Promotions
Plugin URI: http://sharketing.nl/
Description: 
Author: sharketing
Version: 1.3.16
Author URI: http://sharketing.nl/?epp
*/

if (!class_exists('espLoader')) {

	class espLoader {
		
		function __construct() {
			$this->load_options();
			if (is_admin() && !defined('DOING_AJAX')) {	
				require_once(dirname (__FILE__) . '/admin.php');
				$this->espAdminPanel = new espAdminPanel($this);
			} else {
				require_once(dirname (__FILE__) . '/esp-hooks.php');
			}
			//register_activation_hook(__FILE__, array(&$this, 'install'));
		}

		function load_options() {
			$this->options = get_option('esp_options');
		}

		function save_options(array $options = null) {
			if ($options) {
				$this->options = $options;
			}
			update_option('esp_options', $options ?: $this->options);
		}

		function get_option($option) {
			return $this->options[$option];
		}

		function set_option($option, $val) {
			$this->options[$option] = $val;
			$this->save_options();
		}

		/*function getAllSignatures() { die('deperecated getallsignatres');
			$signatures = $this->get_option('all_signatures') ?: array();

			foreach ($promotions as $k => $promotion) {
				if ($promotion['_trashed']) unset($promotions[$k]);
			}

			$a = function($a, $b) {
			    return $a['id'] > $b['id'] ? 1 : -1;
			};
			usort($signatures, $a);

			return $signatures;
		}*/

		function getSignatureById($id) {
			foreach ($this->get_all_promotions() as $signature) {
				if ($signature['id'] == $id) return $signature;
			}
		}

		/*function deleteSignatureById($id) {
			$allSignatures = $this->getAllSignatures();
			foreach ($allSignatures as $key => $signature) {
				if ($signature['id'] == $id) {
					unset($allSignatures[$key]);
					break;
				}
			}
			$this->set_option('all_signatures', $allSignatures);
		}*/

		function get_promotion($id) {
			foreach ($this->get_all_promotions() as $promotion) {
				if ($promotion['id'] == $id) return $promotion;
			}
		}

		function get_all_promotions() {
			$promotions = $this->get_option('all_signatures') ?: array();

			$a = function($a, $b) {
			    return $a['id'] > $b['id'] ? 1 : -1;
			};
			usort($promotions, $a);

			return $promotions;
		}

		function get_promotions() {
			$promotions = $this->get_all_promotions();

			foreach ($promotions as $k => $promotion) {
				if ($promotion['_trashed']) unset($promotions[$k]);
			}

			return $promotions;
		}

		function get_trashed_promotions() {
			$promotions = $this->get_all_promotions();

			foreach ($promotions as $k => $promotion) {
				if (!$promotion['_trashed']) unset($promotions[$k]);
			}

			return $promotions;
		}

		public function delete_promotion($id) {
			$promotions = $this->get_all_promotions();
			foreach ($promotions as $key => $promotion) {
				if ($promotion['id'] == $id) {
					unset($promotions[$key]);
					break;
				}
			}
			$this->set_option('all_signatures', $promotions);
		}

		public function is_duplicate($signature) {
			global $espLoader;
			foreach ($espLoader->get_all_promotions() as $signa) {
				if ($signa['id'] != $signature['id'] && $signa['enabled'] && $this->is_duplicate_of($signature, $signa)) return $signa['id'];
			}
		}

		public function is_duplicate_of($signature, $otherSignature) {
			$testAuthors = array_intersect($signature['authors'] ?: array(), $otherSignature['authors'] ?: array());
			$testCategories = array_intersect($signature['categories'] ?: array(), $otherSignature['categories'] ?: array());
			$testBlogPages = $signature['display_from'] == $otherSignature['display_from'] && $signature['display_to'] == $otherSignature['display_to'];
			$testPromotionOn = $signature['signature_position'] == $otherSignature['signature_position'];
			if ($testPromotionOn && $signature['signature_position'] == 'above_heading') {
				$testPromotionOn = $signature['signature_position_heading'] == $otherSignature['signature_position_heading'];
			}
			return count($testAuthors) == count($signature['authors']) && count($signature['authors']) == count($otherSignature['authors']) && count($signature['categories']) == count($otherSignature['categories']) && count($testCategories) == count($signature['categories']) && $testBlogPages && $testPromotionOn;
		}
		
		public function get_signature_data($postData, $signatureData = null) {
			$vars = array('display_title', 'authors', 'categories', 'display_from', 'display_to', 'content', 'signature_position', 'signature_position_heading', 'promotions', 'views', '_trashed', 'lock_visitor_to_subpromo',

				'banner_left_from_the_content_responsive', 'banner_left_from_the_content_responsive_max_width', 'banner_left_from_the_content_position', 'banner_left_from_the_content_position_scrolling', 'banner_left_from_the_content_offset', 'banner_left_from_the_content_show_on_homepage', 'banner_left_from_the_content_show_on_blogpage', 'after_n_comments_position'
			);
			$data = array();
			foreach ($vars as $name) $data[$name] = @$postData[$name];
			if (empty($data['promotions'])) $data['promotions'] = array(array());
			else if (isset($postData['promotions']['content'])) {
				$promotions = array();
				foreach ($data['promotions']['content'] as $i => $content) {
					$promotions[$i]['id'] = $i;
					$promotions[$i]['content'] = str_replace(array('\\'), '', $content);
					$promotions[$i]['custom_html_css'] = str_replace(array('\\'), '', $data['promotions']['custom_html_css'][$i]);
					$promotions[$i]['use_custom_html_css_code'] = $data['promotions']['use_custom_html_css_code'][$i];
					$promotions[$i]['name'] = $data['promotions']['name'][$i];
					if ($signatureData) {
						$promotions[$i]['views'] = $signatureData['promotions'][$i]['views'];
						$promotions[$i]['cdate'] = $signatureData['promotions'][$i]['cdate'] ?: time();
					}
				}
				$data['promotions'] = $promotions;
			}
			if (isset($postData['promotions']['content']) && $signatureData) {
				$data['views'] = $signatureData['views'];
				$data['cdate'] = $signatureData['cdate'] ?: time();
				$data['_trashed'] = $signatureData['_trashed'];
			}
			$data['lock_visitor_to_subpromo'] = !!$data['lock_visitor_to_subpromo'];
			// add new promotion
			if ($_POST['addpromotion']) {
				$data['promotions'] []= array();
			}
			// delete promotion
			if ($_POST['deletepromotion']) {
				unset($data['promotions'][$_POST['deletepromotion']]);
			}
			return $data;
		}

		public function get_promotion_views_count($signature_id) {
			$esp_views = get_option('esp_views');
			return $esp_views[$signature_id]['total'] ?: 0;
		}

		public function get_subpromotion_views_count($signature_id, $promotion_id) {
			$esp_views = get_option('esp_views');
			return $esp_views[$signature_id]['promo' . $promotion_id] ?: 0;
		}

		public function save_signature($id, $data) {
			$allSignatures = $this->get_all_promotions();

			$foundSignature = $id ? $this->getSignatureById($id) : array();

			// only enable signature
			if (isset($_POST['enabled'])) {
				$signature = $foundSignature;
				$signature['enabled'] = !!$data['enabled'];

			// only trash or restore
			} else if (isset($_POST['_trashed'])) {
				$signature = $foundSignature;
				$signature['_trashed'] = $_POST['_trashed'];

			// only reset views
			} else if (isset($_POST['resetviews'])) {
				$signature = $foundSignature;

				$esp_views = get_option('esp_views');
				$esp_views[$signature['id']] = array();
				update_option('esp_views', $esp_views);

				/*$signature['views'] = 0;
				foreach ($signature['promotions'] as &$promotion) {
					$promotion['views'] = 0;
				}*/

			// save signature data
			} else {
				if (!isset($foundSignature['enabled'])) {
					$foundSignature['enabled'] = false;
				}
				$signature = array_merge($foundSignature, $this->get_signature_data($data, $foundSignature));
			}

			if (!$id) {
				$last = end($allSignatures);
				$signature['id'] = $last['id'] + 1;
			} else {
				//$this->deleteSignatureById($id);
				//$allSignatures = $this->getAllSignatures();
				$newSignaturesList = $this->remove_signature($id);
				$allSignatures = $newSignaturesList;
			}
			
			$duplicate = $this->is_duplicate($signature);

			// disable duplicate
			if ($duplicate) {
				$signature['enabled'] = false;
			}

			$allSignatures []= $signature;

			$this->set_option('all_signatures', $allSignatures);

			return $signature;
		}

		public function remove_signature($id) {
			$allSignatures = $this->get_all_promotions();
			foreach ($allSignatures as $key => $signature) {
				if ($signature['id'] == $id) {
					unset($allSignatures[$key]);
					break;
				}
			}
			return $allSignatures;
		}

		public function get_locations() {
			return array('at_the_end' => 'At the end', 'above_the_title' => 'Above the title', 'above_heading' => 'Just above a header', 'banner_left_from_the_content' => 'Banner left from the content', 'above_footer' => 'Above footer', 'after_n_comments' => 'After 1,2,n comments');
		}

		function install() {
			if (!$this->options || count($this->options) == 0) {
				/*$this->options = array(
					'activate_clear_both_css' => false,
					'display_title' => '<b>Contents:</b>',
					'showtags' => 'No, I will do it manually with the shortcode',
					'noMoreTag' => 'Then don`t add anchor links there',
					'anchorCount' => 1,
					'is_single' => true,
					'is_page' => true,
					'is_numbering' => true,
					'head_start' => 1,
					'head_end' => 3,
					'use_heading_indent' => true

				);
				$this->save_options();*/
			}
		}
	
	}
	//Start Loader
	global $espLoader;
	$espLoader = new espLoader();
}