<?php

class msbfAdminPanel{

	public function __construct(){
		add_action('admin_menu', array(&$this,'loadAdminOptions'));

		add_action( 'admin_enqueue_scripts', 'mw_enqueue_color_picker' );
		function mw_enqueue_color_picker( $hook_suffix ) {
			// first check that $hook_suffix is appropriate for your admin page
			wp_enqueue_script('wp-color-picker' );
			wp_enqueue_style( 'wp-color-picker' );
		}

		$this->handleFeedbackToggle();
		
		add_action('admin_footer', array(&$this,'adminFooter'));
	}
	
	public function adminFooter() {
		?>
		<script>
			(function($) {
				$('form#post').submit(function() {
					setCookie('savescroll', $(window).scrollTop());
				});
				
				if (getCookie('savescroll') > 0) {
					jQuery(function() {
						$("html, body").animate({ scrollTop: getCookie('savescroll') + "px" });
						setCookie('savescroll', 0);
					});
				}
				
				function setCookie(key, value) {
		            var expires = new Date();
		            expires.setTime(expires.getTime() + (1 * 24 * 60 * 60 * 1000));
		            document.cookie = key + '=' + value + ';expires=' + expires.toUTCString();
		        }
		
		        function getCookie(key) {
		            var keyValue = document.cookie.match('(^|;) ?' + key + '=([^;]*)(;|$)');
		            return keyValue ? keyValue[2] : null;
		        }
			})(jQuery);
		</script>	
		<?php
	}

	public function saveOptions(array $options, array $optionNames = null) {
		global $msbfLoader;
		if (!is_array($optionNames)) $optionNames = array_keys($options);
		foreach ($optionNames as $option) {
			$option = trim($option);
			if (substr($option, 0, 1) == '_') continue;
			$value = trim($options[$option]);
			$msbfLoader->options[$option] = $value;
		}
		$msbfLoader->save_options();
	}

	public function loadAdminOptions(){
		if (function_exists('add_options_page')) {
            add_options_page('Sharketing Smart Blogger Feedback','Sharketing Smart Blogger Feedback', 8, MSBF_FOLDER . '/admin/options.php');
        }
	}

	public function getFeedbackChecks() {
		global $msbfLoader;
		return $msbfLoader->feedbackHandler->feedbackChecks;
	}
	
	public function getDefaultCaseWords() {
		$defaults = array(
			'en_EN' => 'the it a an and this that these for with after as of in to over or still about too from',
			'nl_NL' => 'de het een en dit dat die deze door voor aan uit via met na als van bij tot dan of naar in nog over ook om te'
		);
		return $defaults[langtoiso(getOption('feedbackLanguage'))];
	}

	public function getAllPostsWithErrors() {
		if (!isset($this->postsWithErrors)) {
			global $msbfLoader;
			$errors = $msbfLoader->options['feedbackErrors'];
			$posts = array();
			// first re-check all posts
			foreach ($errors as $postId => $feedback) {
				if ($post = get_post($postId)) {
					$msbfLoader->feedbackHandler->checkForFeedback($post);
				}
			}
			$randomize_postviews = rand(1456, 8765);
			foreach ($errors as $postId => $feedback) {
				$post = get_post($postId);	
				if (!$post || ($post->post_status != 'publish' && $post->post_status != 'future') || (!is_truly_admin() && $post->post_author != get_current_user_id())) continue;
				$postData = array('post' => $post, 'feedback' => $feedback, 'feedbackMessage' => $msbfLoader->feedbackHandler->getAdminMessage($post, $feedback, false), 'author' => $post->post_author, 'permalink' => get_permalink($post->ID), 'editlink' => get_edit_post_link($post->ID), 'ignorelink' => admin_url('options-general.php?page=sharketing-smart-blogger-feedback/admin/options.php&ignoreFeedback=' . $post->ID), 'enablelink' => admin_url('options-general.php?page=sharketing-smart-blogger-feedback/admin/options.php&enableFeedback=' . $post->ID), 'resetFeedback' => admin_url('options-general.php?page=sharketing-smart-blogger-feedback/admin/options.php&resetFeedback=' . $post->ID));
				$postData['modified_date'] = $post->post_modified;
				if (is_plugin_active('wp-postviews/wp-postviews.php')) {
					// increment wpviews by random value, so the order is the same, but the value isn't tracable
					$postData['wppostviews'] = (get_post_meta($post->ID, 'views', true) + $randomize_postviews)*$randomize_postviews;
				}
				$posts []= $postData;
			}
			// sorteren wordt nu via frontend gedaan
			// orders posts on modfied date
			//usort($posts, function($a, $b) {
			//	return $a['post']->post_modified > $b['post']->post_modified ? -1 : 1;
			//});
			$this->postsWithErrors = $posts;
		}
		return $this->postsWithErrors;
	}

	public function getFeedbackPosts($ignored, $indexed = true) {
		$posts = $this->getAllPostsWithErrors();
		$list = array();
		foreach($posts as $post) {
			if ($ignored != is_post_feedback_ignored($post['post']->ID)) continue;
			if ($post['post']->post_type == 'post' && !getOption('applyToPosts')) continue;
			if ($post['post']->post_type == 'page' && !getOption('applyToPages')) continue;
			if ($indexed == true) {
				if ($post['post']->post_type == 'post') {
					$list['posts'] []= $post;	
				} else if ($post['post']->post_type == 'page') {
					$list['pages'] []= $post;
				}
			} else {
				$list []= $post;
			}
		}
		return $list;
	}

	public function getOpenFeedbackPosts($indexed = true) {
		return $posts = $this->getFeedbackPosts(false, $indexed);
		$list = array();
		foreach($posts as $post) {
			if ($indexed == true) {
				if ($post['post']->post_type == 'post') {
					$list['posts'] []= $post;	
				} else if ($post['post']->post_type == 'page') {
					$list['pages'] []= $post;
				}
			} else {
				$list []= $post;
			}
		}
		return $list;
	}

	public function getIgnoredFeedbackPosts($indexed = true) {
		return $posts = $this->getFeedbackPosts(true, $indexed);
		$list = array();
		foreach($posts as $post) {
			if ($this->isPostFeedbackIgnored($post['post']->ID) || empty($msbfLoader->options['feedbackErrors'][$post['post']->ID])) continue;
			if ($indexed == true) {
				if ($post['post']->post_type == 'post') {
					$list['posts'] []= $post;	
				} else if ($post['post']->post_type == 'page') {
					$list['pages'] []= $post;
				}
			} else {
				$list []= $post;
			}
		}
		return $list;
	}

	public function getOpenFeedbackOverview() {
		$list = $this->getOpenFeedbackPosts();
		$overview = array();
		if ($list['posts']) {
			$overview['posts'] = 'Blogposts (' . count($list['posts']) . ')';
		}
		if ($list['pages']) {
			$overview['pages'] = 'Pages (' . count($list['pages']) . ')';
		}
		return $overview;
	}

	public function getCountOpenFeedback() {
		return count($this->getOpenFeedbackPosts(false));
	}

	public function getOpenFeedbackAuthors() {
		$list = $this->getOpenFeedbackPosts(false);
		$authors = array('All Authors');
		foreach ($list as $post) {
			if (isset($authors[$post['post']->post_author])) continue;
			$user_info = get_userdata($post['post']->post_author);
			$authors[$post['post']->post_author] = $user_info->user_login ?: '???';
		}
		return $authors;
	}

	public function getIgnoredFeedbackOverview() {
		$list = $this->getIgnoredFeedbackPosts();
		$overview = array();
		if ($list['posts']) {
			$overview['posts'] = 'Blogposts (' . count($list['posts']) . ')';
		}
		if ($list['pages']) {
			$overview['pages'] = 'Pages (' . count($list['pages']) . ')';
		}
		return $overview;
	}

	public function getCountIgnoredFeedback() {
		return count($this->getIgnoredFeedbackPosts(false));
	}
	
	public function handleFeedbackToggle() {
		if (!is_truly_admin()) return;
		if (isset($_GET['ignoreFeedback']) && $postId = $_GET['ignoreFeedback']) {
			$ignored = getOption('ignoredFeedbackPosts') ?: array();
			if (!in_array($postId, $ignored)) {
				$ignored []= $postId;
				setOption('ignoredFeedbackPosts', $ignored);

				if ($_GET['returnpost']) {
					wp_redirect(admin_url('post.php?post=' . $postId . '&action=edit')); exit;
				}
			}
		} else if (isset($_GET['enableFeedback']) && $postId = $_GET['enableFeedback']) {
			$ignored = getOption('ignoredFeedbackPosts') ?: array();
			if (in_array($postId, $ignored)) {
				if(($key = array_search($postId, $ignored)) !== false) {
					unset($ignored[$key]);
				}
				setOption('ignoredFeedbackPosts', $ignored);
			}
		} else if (isset($_GET['resetFeedback']) && $postId = $_GET['resetFeedback']) {
			global $msbfLoader;
			unset($msbfLoader->options['feedbackErrors'][$postId]);
			$msbfLoader->save_options();
		}
	}

}

?>
