<?php

class BlankLines extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'One or more blank lines in article';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You used one or more blank lines in your article!',
			'nl_NL' => 'LET OP! Je hebt één of meer lege witruimtes in je artikel!'
		);
		$this->sort = 11;
	}

	public function isValid($post) {
		if ($_GET['msbf'] == 'add-blank-lines-exception') {
			$this->ignorePost($post);
		}

		if ($this->ignoredPost($post)) return true;

		$pattern = '/&nbsp;/s';
		preg_match_all($pattern, get_the_post_content($post), $matches, PREG_SET_ORDER);
		$numDoubleLines = count($matches);

		if ($numDoubleLines > 0 && $_GET['msbf'] == 'delete-blank-lines') {
			$newContent = str_replace("&nbsp;", '', get_the_post_content($post));
			wp_update_post(array(
				'ID' => $post->ID,
				'post_content' => $newContent
			));
			// refetch post for latest version
			$post = get_post($post->ID);
			// re-validate this feedbackcheck
			return $this->isValid($post);
		}

		return $numDoubleLines == 0;
	}
}