<?php

class ToFewItemsInList extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too few lists';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You have to few lists! You should have a minimum of [min_lists] lists.',
			'nl_NL' => 'LET OP! Je hebt te weinig lijsten! Je moet minimaal [min_lists] opsommingen gebruiken.'
		);
		$this->sort = 14;
		$this->errorVars = array(
			'min_lists' => intOptionOr('minLists', 2)
		);
	}

	public function isValid($post) {
		$content = get_the_post_content($post);
		return !$content || $this->getNumLists($content) >= intOptionOr('minLists', 2);
	}
	
	public function getNumLists($content) {
		$dom = new DOMDocument();
		$dom->loadHTML($content);
		$uls = $dom->getElementsByTagName('ul');
		$ols = $dom->getElementsByTagName('ol');

		return $uls->length + $ols->length;

	}

	/*public function validLists($content, $min_items) {		
		$dom = new DOMDocument();
		$dom->loadHTML($content);
		$uls = $dom->getElementsByTagName('ul');
		$ols = $dom->getElementsByTagName('ol');

		$validLists = function($lists) use ($min_items) {
			foreach ($lists as $list) {
				if ($list->getElementsByTagName('li')->length < $min_items) {
					return false;
				}
			}
			return true;
		};

		if (!$validLists($uls) || !$validLists($ols)) {
			return false;
		}

		return true;
	}*/
}