<?php

class TooFewImages extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too few images';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You have to few images! There should be a minimum of [min_images] images.',
			'nl_NL' => 'LET OP! Je hebt te weinig afbeeldingen! Er moeten minimaal [min_images] afbeeldingen gebruikt worden.'
		);
		$this->sort = 17;
		$this->errorVars = array(
			'min_images' => intOptionOr('minImages', 2)
		);
	}

	public function isValid($post) {
		$content = get_the_post_content($post);
		return !$content || $this->getNumImages($content) >= intOptionOr('minImages', 2);
	}

	public function getNumImages($content) {
		$dom = new DOMDocument();
		$dom->loadHTML($content);
		$imgs = $dom->getElementsByTagName('img');
		return $imgs->length;
	}
}