<?php

class TooFewInternalLinks extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too few internal links';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! You have to few internal links! There should be a minimum of [min_links] internal link(s) to other post(s), don`t put this link in the last paragraph.',
			'nl_NL' => 'LET OP! Je hebt te weinig interne links! Gebruik minimaal [min_links] interne link(s) naar een andere post(s), maar plaatst deze niet in de laatste alinea.'
		);
		$this->sort = 18;
		$this->errorVars = array(
			'min_links' => intOptionOr('minInternalLinks', 1)
		);
	}

	public function isValid($post) {
		$content = get_the_post_content($post);
		return !$content || $this->getNumInternalLinks($content) >= intOptionOr('minInternalLinks', 1);
	}

	public function getNumInternalLinks($content) {
		$count = 0;
		$dom = new DOMDocument();
		$dom->loadHTML($content);
		$as = $dom->getElementsByTagName('a');
		foreach ($as as $a) {
			if (strpos(str_replace(array('https', 'http'), '', $a->getAttribute('href')), str_replace(array('https', 'http'), '', get_site_url())) !== false) {
				$count++;
			}
		}
		return $count;
	}
}