<?php

class TooLongArticleTitle extends AFeedbackCheck {
	public function __construct() {
		$this->name = 'Too long article title';
		$this->defaultError = array(
			'en_EN' => 'ATTENTION! Your article title is too long! Make it maximum [min_tit] characters and minimum [max_tit].',
			'nl_NL' => 'LET OP! Je artikel titel is te lang! Maak het maximaal [min_tit] tekens en minimaal [max_tit].'
		);
		$this->sort = 2.2;
		$this->errorVars = array(
			'min_tit' => intOptionOr('minArticleTitle', 30),
			'max_tit' => intOptionOr('maxArticleTitle', 80),
		);
	}

	public function isValid($post) {
		$len = strlen($post->post_title);
		return $len <= intOptionOr('maxArticleTitle', 80);
	}
}