<?php

/**
 * Plugin Update Methods
 *
 * @package WishListMember
 */

namespace WishListMember;

use WishListMember\GroundLevel\Mothership\Api\Request\Products;

/**
* Plugin Update Methods trait
*/
trait Plugin_Update_Methods
{
    /**
     * Get plugin download URL
     *
     * @param  string $version Plugin version. Empty for $_GET['wlm3_rollback'] or 'latest'.
     * @return string
     */
    public function plugin_download_url($version = null)
    {
        static $url;

        if (empty($version)) {
            if (wlm_arrval($_REQUEST, 'wlm3_rollback')) {
                $version = wlm_arrval($_REQUEST, 'wlm3_rollback');
            } else {
                $version = 'latest';
            }
        }

        if (1 != $this->get_option('LicenseStatus')) {
            return false;
        }

        $license_key = wlm_trim($this->get_option('LicenseKey'));
        if (empty($license_key)) {
            return 'WLMNOLICENSEKEY';
        }

        if (! $url) {
            $result = Products::getVersion(WLM_PRODUCT_SLUG, $version);
            if ($result->isError()) {
                return '';
            }
            $url = $result->url;
        }
        return $url;
    }

    /**
     * Get WordPress plugin update URL
     *
     * @return string
     */
    public function plugin_update_url()
    {
        return wp_nonce_url('update.php?action=upgrade-plugin&plugin=' . $this->plugin_file, 'upgrade-plugin_' . $this->plugin_file);
    }

    /**
     * Get plugin latest verison
     *
     * @return string
     */
    public function plugin_latest_version()
    {
        static $latest_wpm_ver;
        $transient_name = 'WishListMember_Latest_Plugin_Version';
        $check_version  = isset(wlm_get_data()['checkversion']);
        if (empty($latest_wpm_ver) || $check_version) {
            $latest_wpm_ver = get_transient($transient_name);
            if (empty($latest_wpm_ver) || $check_version) {
                $latest_wpm_ver = Products::getVersion(WLM_PRODUCT_SLUG, 'latest');
                $latest_wpm_ver = $latest_wpm_ver->isSuccess() ? $latest_wpm_ver->number : $this->version;
                set_transient($transient_name, $latest_wpm_ver, 60 * 60 * 24);
            }
        }
        return $latest_wpm_ver;
    }

    /**
     * Check if plugin is latest version.
     *
     * @return boolean
     */
    public function plugin_is_latest()
    {
        $latest_ver = $this->plugin_latest_version();
        $ver        = $this->version;
        if (preg_match(implode('', ['/^{', 'WLP_VERSION}/']), $this->version, $match)) {
            return true;
        }
        return version_compare($latest_ver, $ver, '<=');
    }
}
