<div id="activecampaign-lists-table" class="table-wrapper"></div>
<script type="text/template" id="activecampaign-lists-template">
	<h3 class="mt-4 mb-2">{%- data.label %}</h3>
	<table class="table table-striped">
		<colgroup>
			<col>
			<col width="1%">
		</colgroup>
		<thead>
			<tr>
				<th>Name</th>
				<th></th>
			</tr>
		</thead>
		<tbody>
			{% _.each(data.levels, function(level) { %}
			<tr>
				<td><a href="#" data-toggle="load-modal" data-target="{%- level.id %}">{%= level.name %}</a></td>
				<td class="text-right" style="vertical-align: middle">
					<div class="btn-group-action">
						<a href="#" data-toggle="load-modal" data-target="{%- level.id %}" class="btn -tags-btn" title="Edit"><i class="wlm-icons md-24">edit</i></a>
					</div>
				</td>
			</tr>
			{% }); %}
		</tbody>
	</table>
</script>

<div id="activecampaign-list-modal-container"></div>

<script type="text/javascript">
	$('#activecampaign-lists-table').empty();
	$.each(all_levels, function(k, v) {
		var data = {
			label: post_types[k].labels.name,
			levels: v
		}
		var tmpl = _.template($('script#activecampaign-lists-template').html(), {
			variable: 'data'
		});
		var html = tmpl(data);
		$('#activecampaign-lists-table').append(html);
	});

    // Click handler for loading list modal markup.
    $(document).on('click', '#activecampaign-lists-table a[data-toggle="load-modal"]', function(e) {
        $.post(
            ajaxurl,
            {
                'level' : $(this).data('target'),
                'action' : 'wlm3_get_list_modal',
                [WLM3VARS.nonce_field]: WLM3VARS.nonce
            },
            function(data) {
                $('#activecampaign-list-modal-container').html(data);
                $('#activecampaign-list-modal-container').transformers();
                (new wlm3_modal(
                    '#' + $('#activecampaign-list-modal-container [data-process="modal"]').attr('id'),
                    {
                        before_open : function() {
                            $(this).transformers();
                            WLM3ThirdPartyIntegration.activecampaign.fxn.set_list_options();
                        }
                    }
                )).open();
            }
        );
    })
</script>
