<?php

/**
 * Infusionsoft init
 *
 * @package WishListMember/Payments
 */

if (! class_exists('WLM3_Infusionsoft_Hooks')) {
    /**
     * WLM3_Infusionsoft_Hooks class
     */
    class WLM3_Infusionsoft_Hooks
    {
        /**
         * Constructor
         */
        public function __construct()
        {
            add_action('wp_ajax_wlm3_infusionsoft_test_keys', [$this, 'test_keys']);
        }

        /**
         * Test keys
         */
        public function test_keys()
        {
            $save = wlm_post_data()['data']['save'] ?? '';
            $isapikey = wlm_post_data()['data']['isapikey'];
            $data = [
                'status' => false,
                'message' => '',
            ];
            if (class_exists('\WishListMember\Infusionsoft\WLM_Infusionsoft')) {
                $oauth_token = wishlistmember_instance()->get_option('keap_oauth_token_payment');
                $transient_name = $oauth_token ? $oauth_token->accessToken : $isapikey;
                $transient_name = empty($transient_name) ? 'x' : $transient_name;
                $transient_name = 'wlmis_' . md5($transient_name);
                if ($save) {
                    if ($isapikey) {
                        wishlistmember_instance()->save_option('isapikey', $isapikey);
                    }
                } else {
                    $transient_result = get_transient($transient_name);
                    if ($transient_result) {
                        $transient_result['cached'] = 1;
                        wp_die(wp_json_encode($transient_result));
                    }
                }

                $con_message = '';
                if ($oauth_token) {
                    $ifsdk = new \WishListMember\Infusionsoft\WLM_Infusionsoft();
                    $con_message = 'WishList Member could not establish a connection to Infusionsoft using OAuth. Please try again.';
                } else {
                    if ($isapikey) {
                        $ifsdk = new \WishListMember\Infusionsoft\WLM_Infusionsoft('payment', $isapikey);
                        $con_message = 'WishList Member could not establish a connection to Infusionsoft using the App Name and Encrypted Key that you entered. Please make sure that the information you entered are correct and Infusionsoft is not blocked by your server';
                    }
                }

                if ($ifsdk && $ifsdk->is_api_connected()) {
                    $is_tags_category = $ifsdk->get_tag_categories();
                    $is_tags = $ifsdk->get_tags();
                    $is_tags_category = (array) $is_tags_category;
                    $is_tags_category[0] = __('- No Category -', 'wishlist-member');
                    $oauth_app = wishlistmember_instance()->get_option('keap_oauth_app_payment');
                    asort($is_tags_category);
                    $data['tagscategory'] = $is_tags_category;
                    $data['tags'] = $is_tags;
                    $data['status'] = true;
                    if ($oauth_app) {
                        $data['message'] = 'Connected to <strong>' . $oauth_app . '</strong>';
                    } else {
                        $data['message'] = 'Connected';
                    }
                    set_transient($transient_name, $data, 60 * 15);
                } else {
                    $data['message'] = $con_message;
                }
            } else {
                $data['message'] = 'WLM_Infusionsoft not found';
            }
            wp_die(wp_json_encode($data));
        }
    }
    new WLM3_Infusionsoft_Hooks();
}
