<?php
/**
 * @license MIT
 *
 * Modified by caseproof on 06-January-2025 using Strauss.
 * @see https://github.com/BrianHenryIE/strauss
 */ namespace Infusionsoft\Api\Rest;

use WishListMember\Infusionsoft\Api\Rest\Traits\CannotModel;
use WishListMember\Infusionsoft\Api\Rest\Traits\CannotSync;

class WishListMember_FileService extends WishListMember_RestModel
{
    use CannotSync, CannotModel;

    public $full_url = 'https://api.infusionsoft.com/crm/rest/v1/files';
    public $return_key = 'files';

    public function getIdAttribute() {
        if(isset($this->attributes['id'])) {
            return $this->attributes['id'];
        }
        if(isset($this->attributes['file_descriptor'])) {
            return $this->attributes['file_descriptor']['id'];
        }
    }
}