<?php

add_action('customize_register', 'senhblog_mainmenu_customize_register');
function senhblog_mainmenu_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_mainmenu', array(
        'title'    => customize_options_language('5a. Main menu', '5a. Hoofdmenu'),
        'description' => '',
        'priority' => 124,
    ));
 
	$wp_customize->add_setting('mainmenu_height', array(
		 'default'        => 40,
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'mainmenu_height', array(
        'label'      => customize_options_language('Main menu height', 'Hoofdmenu hoogte') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_height',
		'slider_min' => 20,
		'slider_max' => 200,
		'default' => 40
    )));

	/*$wp_customize->add_setting('mainmenu_fullwidth', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_fullwidth', array(
        'label'      => customize_options_language('Main menu fullwidth', 'Hoofdmenu volledige breedte'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_fullwidth',
		'type'		=> 'checkbox'
    ));*/

	$wp_customize->add_setting('mainmenu_alignment', array(
        'default'        => 'left',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_alignment', array(
        'label'      => customize_options_language('Main menu alignment', 'Hoofdmenu uitlijnen') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_alignment',
		'type'		=> 'select',
		'choices'	=> array('left' => customize_options_language('Left', 'Links'), 'right' => customize_options_language('Right', 'Rechts'), 'center' => customize_options_language('Center', 'Gecentreerd'))
    ));

	$wp_customize->add_setting('mainmenu_enable_searchbox', array(
        'default'        => true,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_enable_searchbox', array(
        'label'      => customize_options_language('Searchbox right on mainmenu', 'Zoekveld rechts op het hoofdmenu') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_enable_searchbox',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('mainmenu_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_color',
		array(
			'label'      => customize_options_language('Main menu color', 'Hoofdmenu kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_color'
		)
	));

	$wp_customize->add_setting('mainmenu_border_bottom_width', array(
        'default'        => '0',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_border_bottom_width', array(
        'label'      => customize_options_language('Mainmenu border bottom width', 'Hoofdmenu onderkant omlijning dikte') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_border_bottom_width',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('mainmenu_border_bottom_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_border_bottom_color',
		array(
			'label'      => customize_options_language('Mainmenu border bottom color', 'Hoofdmenu onderkant omlijning kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_border_bottom_color'
		)
	));

	$wp_customize->add_setting('mainmenu_border_top_width', array(
        'default'        => '0',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_border_top_width', array(
        'label'      => customize_options_language('Mainmenu border top width', 'Hoofdmenu bovenkant omlijning dikte') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_border_top_width',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('mainmenu_border_top_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_border_top_color',
		array(
			'label'      => customize_options_language('Mainmenu border top color', 'Hoofdmenu bovenkant omlijning kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_border_top_color'
		)
	));

	$wp_customize->add_setting('mainmenu_shadow_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_shadow_color',
		array(
			'label'      => customize_options_language('Mainmenu shadow color', 'Hoofdmenu schaduw kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_shadow_color'
		)
	));

	$wp_customize->add_setting('mainmenu_marginleft', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'mainmenu_marginleft', array(
        'label'      => customize_options_language('Main menu margin left', 'Hoofdmenu afstand links') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_marginleft',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('mainmenu_marginright', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'mainmenu_marginright', array(
        'label'      => customize_options_language('Main menu margin right', 'Hoofdmenu afstand rechts') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_marginright',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('mainmenu_margintop', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'mainmenu_margintop', array(
        'label'      => customize_options_language('Main menu margin top', 'Hoofdmenu afstand boven') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_margintop',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('mainmenu_marginbottom', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'mainmenu_marginbottom', array(
        'label'      => customize_options_language('Main menu margin bottom', 'Hoofdmenu afstand beneden') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_marginbottom',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('mainmenu_fontfamily', array(
        'default'        => 'Verdana',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_fontfamily', array(
        'label'      => customize_options_language('Main menu font', 'Hoofdmenu lettertype') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_fontfamily',
		'type'		=> 'select',
		'choices' => array('Arial' => 'Arial', 'OpenSans' => 'Open Sans', 'Roboto' => 'Roboto', 'Verdana' => 'Verdana', 'Helvetica' => 'Helvetica', 'HelveticaNeue' => 'Helvetica Neue', 'Lato' => 'Lato', 'SansSerif' => 'sans-serif')
    ));

	$wp_customize->add_setting(
		'mainmenu_fontcolor',
		array(
			'default' => '#FFFFFF',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'mainmenu_fontcolor',
			array(
				'label'      => customize_options_language('Main menu font color', 'Hoofdmenu tekstkleur') . ':',
				'section'    => 'senhblog_mainmenu',
				'settings'   => 'mainmenu_fontcolor'
			)
		)
	);

	$wp_customize->add_setting('mainmenu_fontsize', array(
        'default'        => '13',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_fontsize', array(
        'label'      => customize_options_language('Main menu font size', 'Hoofdmenu lettertype grootte') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_fontsize',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('mainmenu_uppercase', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_uppercase', array(
        'label'      => customize_options_language('Use only uppercase?', 'Alles met hoofdletters?'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_uppercase',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('mainmenu_toggle_icon', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_toggle_icon', array(
        'label'      => customize_options_language('Show toggle icon when has subitems', 'Toon toggle teken wanneer er subitems zijn'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_toggle_icon',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('mainmenu_bold', array(
        'default'        => true,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_bold', array(
        'label'      => customize_options_language('Make bold', 'Maak dikgedrukt'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_bold',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('mainmenu_subitems_fontsize', array(
        'default'        => '12',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_subitems_fontsize', array(
        'label'      => customize_options_language('Main menu subitems font size', 'Hoofdmenu subitems lettertype grootte') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_subitems_fontsize',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('mainmenu_subitems_uppercase', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_subitems_uppercase', array(
        'label'      => customize_options_language('Use only uppercase subitems?', 'Alles met hoofdletters subitems?'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_subitems_uppercase',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('mainmenu_subitems_hover_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_subitems_hover_color',
		array(
			'label'      => customize_options_language('Mainmenu subitems hover color', 'Hoofdmenu subitems hover kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_subitems_hover_color'
		)
	));

	$wp_customize->add_setting('mainmenu_hover_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_hover_color',
		array(
			'label'      => customize_options_language('Main menu hover color', 'Hoofdmenu hover kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_hover_color'
		)
	));

	$wp_customize->add_setting('mainmenu_hover_fontcolor', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_hover_fontcolor',
		array(
			'label'      => customize_options_language('Main menu hover font color', 'Hoofdmenu hover lettertype kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_hover_fontcolor'
		)
	));

	$wp_customize->add_setting('mainmenu_hover_underline', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_hover_underline', array(
        'label'      => customize_options_language('Main menu underline on hover', 'Hoofdmenu onderstrepen bij hover'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_hover_underline',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('mainmenu_active_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_active_color',
		array(
			'label'      => customize_options_language('Main menu active color', 'Hoofdmenu actieve kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_active_color'
		)
	));

	$wp_customize->add_setting('mainmenu_active_fontcolor', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_active_fontcolor',
		array(
			'label'      => customize_options_language('Main menu active font color', 'Hoofdmenu actief lettertype kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_active_fontcolor'
		)
	));

	$wp_customize->add_setting('mainmenu_hover_border_bottom_width', array(
        'default'        => '0',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_hover_border_bottom_width', array(
        'label'      => customize_options_language('Main menu hover border bottom width', 'Hoofdmenu hover onderkant omlijning dikte'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_hover_border_bottom_width',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('mainmenu_hover_border_bottom_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_hover_border_bottom_color',
		array(
			'label'      => customize_options_language('Main menu hover border bottom color', 'Hoofdmenu hover onderkant omlijning kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_hover_border_bottom_color'
		)
	));

	$wp_customize->add_setting('mainmenu_enable_seperator', array(
        'default'        => true,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_enable_seperator', array(
        'label'      => customize_options_language('Main menu enable seperator |', 'Hoofdmenu activeer afscheiding |'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_enable_seperator',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('mainmenu_seperator_width', array(
        'default'        => 1,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_seperator_width', array(
        'label'      => customize_options_language('Main menu seperator width', 'Hoofdmenu afscheiding breedte') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_seperator_width',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('mainmenu_seperator_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_seperator_color',
		array(
			'label'      => customize_options_language('Main menu seperator color', 'Hoofdmenu afscheiding kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_seperator_color'
		)
	));

	$wp_customize->add_setting('mainmenu_enable_homebutton', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_enable_homebutton', array(
        'label'      => customize_options_language('Main menu enable homebutton', 'Hoofdmenu activeer homeknop'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_enable_homebutton',
		'type'		=> 'checkbox'
    ));

    $wp_customize->add_setting('mainmenu_homebutton_size', array(
        'default'        => 17,
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control('mainmenu_homebutton_size', array(
        'label'      => customize_options_language('Main menu homebutton size', 'Hoofdmenu homebutton grootte') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_homebutton_size',
		'type' => 'number'
    ));

	$wp_customize->add_setting('mainmenu_allow_scroll', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_allow_scroll', array(
        'label'      => customize_options_language('Main menu allow scroll', 'Hoofdmenu mee laten scrollen'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_allow_scroll',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('mainmenu_scrolling_fontsize', array(
        'default'        => '100',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'mainmenu_scrolling_fontsize', array(
        'label'      => customize_options_language('Main menu font size on scroll', 'Hoofdmenu lettertype grootte bij scroll'),
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_scrolling_fontsize',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 100,
		'extra_select_name' => '',
		'extra_select_choices' => array('%' => '%')
    )));

	$wp_customize->add_setting('mainmenu_show_mobile', array(
        'default'        => 'yes',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_show_mobile', array(
        'label'      => customize_options_language('Main menu show on mobile', 'Hoofdmenu weergeven op mobiel') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_show_mobile',
		'type'		=> 'select',
		'choices' => array('yes' => customize_options_language('Yes', 'Ja'), 'no' => customize_options_language('No', 'Nee'), 'only_toggle' => customize_options_language('Only on toggle', 'Alleen bij uitklappen'))
    ));

	$wp_customize->add_setting('mainmenu_togglebutton_position', array(
        'default'        => 'left',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_togglebutton_position', array(
        'label'      => customize_options_language('Main menu mobile toggle button position', 'Hoofdmenu mobiel uitklapsymbool positie') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_togglebutton_position',
		'type'		=> 'select',
		'choices'	=> array('left' => customize_options_language('Left', 'Links'), 'right' => customize_options_language('right', 'Rechts'))
    ));

	$wp_customize->add_setting('mainmenu_display_mobile', array(
        'default'        => 'inline',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_display_mobile', array(
        'label'      => customize_options_language('Main menu alignment on mobile toggle', 'Hoofdmenu opstelling op mobiel bij uitklappen') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_display_mobile',
		'type'		=> 'select',
		'choices' => array('inline' => customize_options_language('Inline', 'Naast elkaar'), 'list' => customize_options_language('List', 'Onder elkaar'))
    ));
    
    

	$wp_customize->add_setting('mainmenu_show_mobile_items', array(
        'default'        => 'no',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('mainmenu_show_mobile_items', array(
        'label'      => customize_options_language('Main menu mobile toggle hidden items', 'Hoofdmenu mobiel uitklapsymbool verborgen items') . ':',
        'section'    => 'senhblog_mainmenu',
        'settings'   => 'mainmenu_show_mobile_items',
		'type'		=> 'select',
		'choices' => array('yes' => customize_options_language('Yes', 'Ja'), 'no' => customize_options_language('No', 'Nee'))
    ));    
    
	$wp_customize->add_setting('mainmenu_togglebutton_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_togglebutton_color',
		array(
			'label'      => customize_options_language('Main menu toggle color', 'Hoofdmenu uitklapsymbool kleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_togglebutton_color'
		)
	));

	$wp_customize->add_setting('mainmenu_togglebutton_backgroundcolor', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'mainmenu_togglebutton_backgroundcolor',
		array(
			'label'      => customize_options_language('Main menu toggle background color', 'Hoofdmenu uitklapsymbool achtergrondkleur') . ':',
			'section'    => 'senhblog_mainmenu',
			'settings'   => 'mainmenu_togglebutton_backgroundcolor'
		)
	));

}