<?php
/**
 * Cart Menu Icon
 *
 * @uses $wp_customize
 * @since 1.7.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$listify_new_skin = get_theme_mod( 'color-scheme' );	
$listify_cart = 'left';
if( isset($listify_new_skin) && $listify_new_skin == "listify-new-skin" ){
	$listify_cart = 'none';
}
$wp_customize->add_setting(
	'nav-cart',
	array(
		'default' => $listify_cart,
	)
);

$wp_customize->add_control(
	'nav-cart',
	array(
		'label'    => __( 'Cart Icon', 'listify' ),
		'type'     => 'select',
		'choices'  => array(
			'left'  => __( 'Left', 'listify' ),
			'right' => __( 'Right', 'listify' ),
			'none'  => __( 'None', 'listify' ),
		),
		'priority' => 10,
		'section'  => 'nav-menus',
	)
);
