<?php
	function admin_enqueue_scripts( $hook ) {
		// Enqueue the scripts only on the plugin page.
		//if ( $this->plugin_page === $hook || ( 'admin.php' === $hook && $this->plugin_page_setup['menu_slug'] === esc_attr( $_GET['import'] ) ) ) {
			//wp_enqueue_script( 'ocdi-listify-js', get_template_directory_uri() . '/assets/js/main.js' , array( 'jquery' ) );

			// Get theme data.
			$theme = wp_get_theme();

			wp_localize_script( 'ocdi-listify-js', 'ocdi',
				array(
					'ajax_url'         => admin_url( 'admin-ajax.php' ),
					'ajax_nonce'       => wp_create_nonce( 'ocdi-ajax-verification' ),
					'wp_customize_on'  => apply_filters( 'ocdi/enable_wp_customize_save_hooks', true ),
					'texts'            => array(
						'missing_preview_image'    => esc_html__( 'No preview image defined for this import.', 'listify' ),
						'dialog_title'             => esc_html__( 'Are you sure?', 'listify' ),
						'dialog_no'                => esc_html__( 'Cancel', 'listify' ),
						'dialog_yes'               => esc_html__( 'Yes, import!', 'listify' ),
						'selected_import_title'    => esc_html__( 'Selected demo import:', 'listify' ),
						'installing'               => esc_html__( 'Installing...', 'listify' ),
						'importing'                => esc_html__( 'Importing...', 'listify' ),
						'successful_import'        => esc_html__( 'Successfully Imported!', 'listify' ),
						'install_plugin'           => esc_html__( 'Install Plugin', 'listify' ),
						'installed'                => esc_html__( 'Installed', 'listify' ),
						'import_failed'            => esc_html__( 'Import Failed', 'listify' ),
						'import_failed_subtitle'   => esc_html__( 'Whoops, there was a problem importing your content.', 'listify' ),
						'plugin_install_failed'    => esc_html__( 'Looks like some of the plugins failed to install. Please try again. If this issue persists, please manually install the failing plugins and come back to this step to import the theme demo data.', 'listify' ),
						'content_filetype_warn'    => esc_html__( 'Invalid file type detected! Please select an XML file for the Content Import.', 'listify' ),
						'widgets_filetype_warn'    => esc_html__( 'Invalid file type detected! Please select a JSON or WIE file for the Widgets Import.', 'listify' ),
						'customizer_filetype_warn' => esc_html__( 'Invalid file type detected! Please select a DAT file for the Customizer Import.', 'listify' ),
						'redux_filetype_warn'      => esc_html__( 'Invalid file type detected! Please select a JSON file for the Redux Import.', 'listify' ),
					),
				)
			);

		
}
add_action( 'admin_enqueue_scripts', 'admin_enqueue_scripts');

// listify Demos
function listify_import_files() {
	return [
	  [
		'import_file_name'           => 'Business Directory',
		'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/default/content.xml',
		'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/default/widget.wie',
		'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/default/customize.dat',
		'import_preview_image_url'   => get_template_directory_uri() . '/inc/setup/assets/images/content-default.png',
		'preview_url'                => 'https://listify-demos.astoundify.com/classic//',
	  ],
      [
		'import_file_name'           => 'Rentals',
		'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/rentals/content.xml',
		'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/rentals/widget.wie',
		'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/rentals/customize.dat',
		'import_preview_image_url'   => get_template_directory_uri() . '/inc/setup/assets/images/content-rentals.png',
		'preview_url'                => 'https://listify-demos.astoundify.com/rentals/',
	  ],
      [
		'import_file_name'           => 'Vintage',
		'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/skin/content.xml',
		'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/skin/widget.wie',
		'local_import_customizer_file' => trailingslashit( get_template_directory() ) . 'inc/setup/import-content/skin/customize.dat',
		'import_preview_image_url'   => get_template_directory_uri() . '/inc/setup/assets/images/listify_new_skin.png',
		'preview_url'                => 'https://listify-demos.astoundify.com/vintage/',
	  ],
	];
}
add_filter( 'ocdi/import_files', 'listify_import_files' );

// Front Page Code
function ocdi_after_import_setup() {
		 
	$main_menu = get_term_by( 'name', 'Primary', 'nav_menu' );
 
    set_theme_mod( 'nav_menu_locations', [
            'primary' => $main_menu->term_id,
        ]
    );

	// Assign front page and posts page (blog page).
	update_option( 'show_on_front', 'page' );

	$front_page_id = get_page_by_title( 'Stay in Style' );
	if(!empty($front_page_id)){
		update_option( 'page_on_front', $front_page_id->ID );
	}
	$front_page_id = get_page_by_title( 'Explore This City' );
	if(!empty($front_page_id)){
		update_option( 'page_on_front', $front_page_id->ID );
	}

	$blog_page_id  = get_page_by_path( 'blog' );
	if(!empty($blog_page_id)){
		update_option( 'page_for_posts', $blog_page_id->ID );
	} 
}
add_action( 'ocdi/after_import', 'ocdi_after_import_setup' );