var gulp = require('gulp');
var template = require('gulp-template');
var fs = require('fs');
var concat = require('gulp-concat');
var pump = require('pump');
var pkg = JSON.parse(fs.readFileSync('./package.json'));

var cleanCss = require('gulp-clean-css');
var scsslint = require('gulp-csslint');

var wpPot = require('gulp-wp-pot');
var checktextdomain = require('gulp-checktextdomain');

var zip = require('gulp-zip');
var clean = require('gulp-clean');

var uglify = require('gulp-uglify');
var jshint = require('gulp-jshint');

var sourcemaps = require('gulp-sourcemaps');

var watch = require('gulp-watch');

var phpcs = require('gulp-phpcs');

/**
 * JS Hint
 *
 * @since 1.0.0
 */
gulp.task('js:hint', function (cb) {
	pump([
		gulp.src([
			'resources/assets/**/*.js',
		]),
		jshint('.jshintrc'),
		jshint.reporter('default'),
		jshint.reporter('fail')
	], cb);
});

/**
 * JS Minify
 *
 * @since 1.0.0
 */
gulp.task('js:minify', async function (done) {
	await gulp.src('resources/assets/js/content-importer.js')
		.pipe(sourcemaps.init())
		.pipe(concat('content-importer.min.js'))
		.pipe(uglify())
		.pipe(sourcemaps.write('./'))
		.pipe(gulp.dest('public/js'));
	await gulp.src('resources/assets/js/settings.js')
		.pipe(sourcemaps.init())
		.pipe(concat('settings.min.js'))
		.pipe(uglify())
		.pipe(sourcemaps.write('./'))
		.pipe(gulp.dest('public/js'));
	done()
});

/**
 * CSS Lint
 *
 * @since 1.0.0
 */
gulp.task('css:lint', function (cb) {
	pump([
		gulp.src([
			'resources/assets/css/*.css',
			'resources/assets/css/**/*.css'
		]),
		scsslint({
			'maxBuffer': 10007200,
			'reporterOutputFormat': 'Stats'
		})
	], cb);
});

/**
 * CSS Minify
 *
 * @since 1.0.0
 */
gulp.task('css:minify', async function (done) {
	await gulp.src('resources/assets/css/content-importer.css')
		.pipe(concat('content-importer.min.css'))
		.pipe(cleanCss())
		.pipe(gulp.dest('public/css'));
	await gulp.src('resources/assets/css/settings.css')
		.pipe(concat('settings.min.css'))
		.pipe(cleanCss())
		.pipe(gulp.dest('public/css'));
	done()
});

/* Minify */
gulp.task('minify', gulp.series('css:minify', 'js:minify'));

/** Assets */
gulp.task('assets', gulp.series('minify'));

/**
 * Watch
 *
 * @since 1.0.0
 */
gulp.task('watch', async function (done) {
	// watch JS
	await gulp.watch('resources/assets/js/*.js', gulp.series('js:minify'));
	// watch CSS
	await gulp.watch('resources/assets/css/*.css', gulp.series('css:minify'));

	done()
});

/**
 * Check Textdomain
 *
 * @since 1.0.0
 */
gulp.task('checktextdomain', function () {
	return gulp.src(['*.php', 'app/**/**.php', 'resources/**/**.php', '!node_modules/'])
		.pipe(checktextdomain({
			text_domain: 'astoundify-contentimporter',
			correct_domain: true,
			force: true,
			keywords: [
				'__:1,2d',
				'_e:1,2d',
				'_x:1,2c,3d',
				'esc_html__:1,2d',
				'esc_html_e:1,2d',
				'esc_html_x:1,2c,3d',
				'esc_attr__:1,2d',
				'esc_attr_e:1,2d',
				'esc_attr_x:1,2c,3d',
				'_ex:1,2c,3d',
				'_n:1,2,4d',
				'_nx:1,2,4c,5d',
				'_n_noop:1,2,3d',
				'_nx_noop:1,2,3c,4d'
			],
		}));
});

/**
 * Make POT
 *
 * @since 1.0.0
 */
gulp.task('makepot', function () {
	return gulp.src(['*/*.php', '**/*.php', '!vendor/', '!node_modules/'])
		.pipe(wpPot({
			domain: 'astoundify-contentimporter',
		}))
		.pipe(gulp.dest('resources/languages/astoundify-contentimporter.pot'));
});

/* POT */
gulp.task('pot', gulp.series('checktextdomain', 'makepot'));

/**
 * PHP Code Sniffer
 *
 * @since 1.0.0
 */
gulp.task('php', function () {
	return gulp.src([
		'app/*.php',
		'app/**/*.php',
		'bootstrap/*.php',
		'resources/*.php',
		'resources/**.php'
	])
		.pipe(phpcs({
			'standard': './phpcs.ruleset.xml'
		}))
		.pipe(phpcs.reporter('log'))
});

/**
 * Clean build files.
 *
 * @since 1.0.0
 */
gulp.task('clean', function () {
	return gulp.src(['./astoundify-contentimporter', '*.zip'], {
		read: false,
		allowEmpty: true
	})
		.pipe(clean());
});

/**
 * Move distribution files to a /dist directory.
 *
 * @since 1.0.0
 */
gulp.task('bundle', gulp.series('clean', 'assets', 'makepot', function (cb) {
	gulp.src([
		'astoundify-contentimporter.php',
		'app/*',
		'app/**',
		'bootstrap/*',
		'resources/*',
		'resources/**',
		'public/*',
		'public/**',
		'vendor/autoload.php',
		'vendor/composer/*',
		'vendor/composer/**',
		'vendor/astoundify/*',
		'vendor/astoundify/**',
		'LICENSE',
		'readme.txt'
	], {
		base: './',
		allowEmpty: true
	})
		.pipe(gulp.dest('astoundify-contentimporter'));

	cb();
}));

/**
 * ZIP
 *
 * @since 1.0.0
 */
gulp.task('zip', function () {
	return gulp.src(['<%= slug %>/**'], {
		base: './'
	})
		.pipe(zip('astoundify-contentimporter-' + pkg.version + '.zip'))
		.pipe(gulp.dest('.'));
});
