<?php

add_action('customize_register', 'senhblog_comments_customize_register');
function senhblog_comments_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_comments', array(
        'title'    => customize_options_language('9. Comments', '9. Reacties'),
        'description' => '',
        'priority' => 128,
    ));

	$wp_customize->add_setting('comments_give_response_text', array(
        'default'        => 'Geef een reactie:',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('comments_give_response_text', array(
        'label'      => customize_options_language('Comments give response-text', 'Reacties geef een reactie-tekst') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_give_response_text'
    ));

	$wp_customize->add_setting('comments_show_input_website', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('comments_show_input_website', array(
        'label'      => customize_options_language('Comments show website input field', 'Reacties weergeef website invoerveld'),
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_show_input_website',
		'type'	=> 'checkbox'
    ));

	$wp_customize->add_setting('comments_before_notes', array(
        'default'        => 'Verplichte velden zijn gemarkeerd met <span class="required">*</span>',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('comments_before_notes', array(
        'label'      => customize_options_language('Comments info text', 'Reacties info tekst') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_before_notes'
    ));

	$wp_customize->add_setting('comments_border_width', array(
        'default'        => '0',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('comments_border_width', array(
        'label'      => customize_options_language('Comments border width', 'Reacties omlijning dikte'),
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_border_width',
		'type'	=> 'number'
    ));

	$wp_customize->add_setting('comments_border_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'comments_border_color',
		array(
			'label'      => customize_options_language('Comments border color', 'Reacties omlijning kleur') . ':',
			'section'    => 'senhblog_comments',
			'settings'   => 'comments_border_color'
		)
	));
		
	$wp_customize->add_setting('comments_shadow_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'comments_shadow_color',
		array(
			'label'      => customize_options_language('Comments shadow color', 'Reacties schaduw kleur') . ':',
			'section'    => 'senhblog_comments',
			'settings'   => 'comments_shadow_color'
		)
	));

	$wp_customize->add_setting('comments_background_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'comments_background_color',
		array(
			'label'      => customize_options_language('Commentform background color', 'Reactieformulier achtergrondkleur') . ':',
			'section'    => 'senhblog_comments',
			'settings'   => 'comments_background_color'
		)
	));

	$wp_customize->add_setting('comments_response_button_text', array(
        'default'        => 'Reactie plaatsen',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('comments_response_button_text', array(
        'label'      => customize_options_language('Comments response button text', 'Reacties response button tekst') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_button_text'
    ));

	$wp_customize->add_setting('comments_response_button_style', array(
        'default'        => 'default'
    )); 
    $wp_customize->add_control('comments_response_button_style', array(
        'label'      => customize_options_language('Comments response button style', 'Reactie plaatsen-knop stijl'),
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_button_style',
		'type'	=> 'select',
		'choices' => array('default' => 'Zelfde eigenschappen lees-meer knop', 'custom' => 'Eigenschappen kiezen')
    ));

	$wp_customize->add_setting('comments_response_button_fontsize', array(
        'default'        => '14',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_response_button_fontsize', array(
        'label'      => customize_options_language('Comments response button font size', 'Reactie plaatsen-knop lettertype grootte') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_button_fontsize',
		'type' => 'number'
    ));

	$wp_customize->add_setting(
		'comments_response_button_backgroundcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'comments_response_button_backgroundcolor',
			array(
				'label'      => customize_options_language('Comments response button backgrond color', 'Reactie plaatsen-knop achtergrondkleur') . ':',
				'section'    => 'senhblog_comments',
				'settings'   => 'comments_response_button_backgroundcolor'
			)
		)
	);

	$wp_customize->add_setting('comments_response_button_border_width', array(
        'default'        => '0',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_response_button_border_width', array(
        'label'      => customize_options_language('Comments response button border width', 'Reactie plaatsen-knop omlijning dikte') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_button_border_width',
		'type' => 'number'
    ));

	$wp_customize->add_setting(
		'comments_response_button_border_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'comments_response_button_border_color',
			array(
				'label'      => customize_options_language('Comments response button border color', 'Reactie plaatsen-knop omlijning kleur') . ':',
				'section'    => 'senhblog_comments',
				'settings'   => 'comments_response_button_border_color'
			)
		)
	);

	$wp_customize->add_setting(
		'comments_response_button_fontcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'comments_response_button_fontcolor',
			array(
				'label'      => customize_options_language('Comments response button font color', 'Reactie plaatsen-knop lettertype kleur') . ':',
				'section'    => 'senhblog_comments',
				'settings'   => 'comments_response_button_fontcolor'
			)
		)
	);

	$wp_customize->add_setting(
		'comments_response_button_hover_fontcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'comments_response_button_hover_fontcolor',
			array(
				'label'      => customize_options_language('Comments response button hover font color', 'Reactie plaatsen-knop hover lettertype kleur') . ':',
				'section'    => 'senhblog_comments',
				'settings'   => 'comments_response_button_hover_fontcolor'
			)
		)
	);

	$wp_customize->add_setting(
		'comments_response_button_hover_backgroundcolor',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'comments_response_button_hover_backgroundcolor',
			array(
				'label'      => customize_options_language('Comments response button hover background color', 'Reactie plaatsen-knop hover achtergrondkleur') . ':',
				'section'    => 'senhblog_comments',
				'settings'   => 'comments_response_button_hover_backgroundcolor'
			)
		)
	);

	$wp_customize->add_setting('comments_response_button_padding_horizontal', array(
        'default'        => '12',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_response_button_padding_horizontal', array(
        'label'      => customize_options_language('Comments response button padding horizontal', 'Reactie plaatsen-knop afstand horizontaal') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_button_padding_horizontal',
		'type' => 'number'
    ));

	$wp_customize->add_setting('comments_response_button_padding_vertical', array(
        'default'        => '6',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_response_button_padding_vertical', array(
        'label'      => customize_options_language('Comments response button padding vertical', 'Reactie plaatsen-knop afstand verticaal') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_button_padding_vertical',
		'type' => 'number'
    ));

	$wp_customize->add_setting(
		'comments_response_name_date_color',
		array(
			'default' => '',
			'transport'	=> 'refresh'
		)
	);
	$wp_customize->add_control(
		new WP_Customize_Color_Control(
			$wp_customize,
			'comments_response_name_date_color',
			array(
				'label'      => customize_options_language('Comment name and date font color', 'Reactie naam en datum lettertype kleur') . ':',
				'section'    => 'senhblog_comments',
				'settings'   => 'comments_response_name_date_color'
			)
		)
	);

	$wp_customize->add_setting('comments_response_name_date_fontsize', array(
        'default'        => '16',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_response_name_date_fontsize', array(
        'label'      => customize_options_language('Comment name and date font size', 'Reactie naam en datum lettertype grootte') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_name_date_fontsize',
		'type' => 'number'
    ));

	$wp_customize->add_setting('comments_response_name_date_fontweight', array(
        'default'        => 'bold',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('comments_response_name_date_fontweight', array(
        'label'      => customize_options_language('Comment name and date font weight', 'Reactie naam en datum lettertype dikte') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_name_date_fontweight',
		'type'		=> 'select',
		'choices'	=> array('100' => '100', '200' => '200', '300' => '300', 'normal' => 'normal', '500' => '500', '600' => '600', 'bold' => 'bold', '800' => '800', '900' => '900')
    ));

	$wp_customize->add_setting('comments_response_on_text', array(
        'default'        => 'Reageeren op [author]',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_response_on_text', array(
        'label'      => customize_options_language('Respond to-text', 'Reageer op-tekst') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_response_on_text'
    ));

	$wp_customize->add_setting('comments_nesting_responses', array(
        'default'        => true,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_nesting_responses', array(
        'label'      => customize_options_language('Allow nested responses', 'Geneste reacties toestaan'),
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_nesting_responses',
		'type' => 'checkbox'
    ));

	$wp_customize->add_setting('comments_nesting_responses_max', array(
        'default'        => 5,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_nesting_responses_max', array(
        'label'      => customize_options_language('Maximum nested responses', 'Maximum geneste reacties') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_nesting_responses_max',
		'type' => 'number'
    ));

	$wp_customize->add_setting('comments_gravatar_fullsize', array(
        'default'        => false,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_gravatar_fullsize', array(
        'label'      => customize_options_language('Avatar location', 'Avatar locatie') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_gravatar_fullsize',
		'type' => 'select',
		'choices' => array(false => customize_options_language('Before comment (inside)', 'Voor de reactie (binnenkant)'), true => customize_options_language('Next to comment (outside)', 'Naast reactie (buiten)'))
    ));

	$wp_customize->add_setting('comments_gravatar_fullsize_size', array(
        'default'        => 100,
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('comments_gravatar_fullsize_size', array(
        'label'      => customize_options_language('Avatar size', 'Avatar grootte') . ':',
        'section'    => 'senhblog_comments',
        'settings'   => 'comments_gravatar_fullsize_size',
		'type' => 'number'
    ));

}