<?php

class WP_Slider_Control extends WP_Customize_Control {
	public $type = 'slider';

	public function __construct($wp_customize, $id, $options) {
		$this->slider_min = $options['slider_min'] ?: 0;
		$this->slider_max = $options['slider_max'] ?: 100;
		$this->extra_select_name = $options['extra_select_name'];
		$this->extra_select_choices = $options['extra_select_choices'];
		$this->extra_select_default = $options['extra_select_default'];
		$this->extra_select_disabled = $options['extra_select_disabled'];
		$this->default = $options['default'];
		parent::__construct($wp_customize, $id, $options);
	}

	public function render_content() {
	?>

	<label>
		<span class="customize-control-title"><?php echo $this->label; ?> <small>(<a href="javascript:;" onclick="jQuery('#<?php echo $this->id; ?>').val(<?php echo $this->default; ?>).trigger('keyup')">reset</a>)</small></span>
		<div style="width:50%;float:left;">
			<input id="<?php echo $this->id; ?>" type="number" value="<?php echo $this->value(); ?>" <?php echo $this->get_link(); ?> style="width:50%" />
			<?php if (isset($this->extra_select_choices)) { ?>
			<select <?php echo $this->extra_select_disabled ? 'disabled' : ''; ?> <?php if (!$this->extra_select_disabled) { ?>name="<?php echo $this->extra_select_name; ?>" id="<?php echo $this->extra_select_name; ?>" <?php } ?> data-customize-setting-link="<?php echo $this->extra_select_name; ?>" style="width:auto;min-width:1px;" onchange="jQuery('#<?php echo $this->id; ?>').trigger('keyup')">
			<?php foreach ($this->extra_select_choices as $n => $v) { ?>
			<option value="<?php echo $n; ?>" <?php echo get_theme_mod($this->extra_select_name, $this->extra_select_default) === $v ? 'selected' : ''; ?>><?php echo $v; ?></option>
			<?php } ?>
			</select>
			<?php } ?>
		</div>
		<div style="width:40%;float:right;margin-top:6px;">
			<div id="slider-control-<?php echo $this->id; ?>"></div>
		</div>
	</label>

	<script>
	jQuery(function() {
		jQuery('#slider-control-<?php echo $this->id; ?>').slider({
			min: <?php echo intval($this->slider_min); ?>,
			max: <?php echo intval($this->slider_max); ?>,
			value: <?php echo intval($this->value()); ?>,
			slide: function (e,ui) {
				jQuery('#<?php echo $this->id; ?>').val(ui.value).trigger('keyup');
			}
		});
		jQuery('#<?php echo $this->id; ?>').on('keyup', function() {
			this.value = parseInt(this.value) || 0;
			jQuery('#slider-control-<?php echo $this->id; ?>').slider('value', this.value);
		});
	});
	</script>

	<?php
	}

	public function enqueue() {
		wp_enqueue_script('jquery-ui-slider');
		wp_enqueue_style('wpslider-contrl-admin-ui-css',
						'//ajax.googleapis.com/ajax/libs/jqueryui/1.8.21/themes/smoothness/jquery-ui.css',
						false,
						PLUGIN_VERSION,
						false);
	}
}