<?php

add_filter('senhblog_is_visible', function($visible, $el) {
	$post = senhblog_get_queried_post();
	if (is_singular($post->post_type)) {
		$ste = get_post_meta($post->ID, '_senhblog_toggle_elements', true);
		if (is_array($ste) && $ste[$el] == 'on') {
			return false;
		}
	}
	return $visible;
}, 99, 2);

function senhblog_toggle_elements_add_custom_box() {
    $screens = array( 'post', 'page' );
    foreach ($screens as $screen) {
        add_meta_box(
            'senhblog_toggle_elements_metaid',
            __('Hide elements for this post/page', 'senhblog'),
            'senhblog_toggle_elements_custom_box',
            $screen
        );
    }
}

function senhblog_toggle_elements_custom_box($post) {
	wp_nonce_field( plugin_basename( __FILE__ ), 'senhblog_ste_noncename' );
	$ste = get_post_meta($post->ID, '_senhblog_toggle_elements', true);

	senhblog_toggle_elements_selectboxes($ste);
	
}

function senhblog_toggle_elements_save_postdata( $post_id ) {
	if ( 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) return;
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) ) return;
	}
	
	if ( ! isset( $_POST['senhblog_ste_noncename'] ) || ! wp_verify_nonce( $_POST['senhblog_ste_noncename'], plugin_basename( __FILE__ ) ) )
		return;
	
	$ste = $_POST['senhblog_toggle_elements'];
	add_post_meta($post_id, '_senhblog_toggle_elements', $ste, true) or update_post_meta($post_id, '_senhblog_toggle_elements', $ste);
}

add_action('add_meta_boxes', 'senhblog_toggle_elements_add_custom_box');
add_action('save_post', 'senhblog_toggle_elements_save_postdata');

function senhblog_toggle_elements_selectboxes($toggled_elements) {
	$elements = array('header' => 'Header', 'extra-header-menu' => 'Extra Header Menu', 'mainmenu' => 'Mainmenu', 'submenu' => 'Submenu', 'breadcrumbs' => 'Breadcrumbs', 'biography' => 'Biography', 'sidebar' => 'Sidebar', 'footer-widgets' => 'Footer Widgets', 'featured-image' => 'Featured Image');

	foreach ($elements as $element => $name) {
		echo '<div><label><input type="checkbox" name="senhblog_toggle_elements[' . $element . ']" ', checked(!!$toggled_elements[$element]) ,'>' . $name . '</label></div>';
	}
}