<?php

add_filter('pre_option_thread_comments', function($str) {
	return (int) get_theme_mod('comments_nesting_responses', true);
});

add_filter('pre_option_thread_comments_depth', function($str) {
	return get_theme_mod('comments_nesting_responses_max', 5);
});


add_filter('get_comment_date', 'senhblog_format_comment_date', 1);	
function senhblog_format_comment_date($strdate) {
	if (is_admin()) {
		return $strdate;
	}
    return "<style>#div-comment-" . get_comment_ID() . " .comment-author:after { content: ' | " . date('d-m-Y', strtotime(get_comment(get_comment_ID())->comment_date)) . "'; } </style>";
}

add_filter('comment_reply_link', function($link) {
	if ($str = get_theme_mod('comments_response_on_text', 'Reageeren op [author]')) {
		return str_replace('Beantwoorden', str_replace('[author]', get_comment_author(), $str), $link);
	}
	return '';
});

add_filter('comment_form_defaults', 'changing_comment_form_defaults');
function changing_comment_form_defaults($defaults){
	if ($before_notes = get_theme_mod('comments_before_notes', 'Verplichte velden zijn gemarkeerd met <span class="required">*</span>')) {
		$defaults['comment_notes_before'] = '<p class="comment-notes">' . $before_notes . '</p>';
	} else {
		$defaults['comment_notes_before'] = '';
	}
	if (!get_theme_mod('comments_show_input_website'))
		unset($defaults['fields']['url']);
	$defaults['label_submit'] = get_theme_mod('comments_response_button_text', $defaults['label_submit']);
	return $defaults;
}

function senhblog_comments() {
	comments_template('/templates/comments.php');
	wp_enqueue_script('comment-reply');
}

function senhblog_comment_template($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}

	$args['avatar_size'] = get_theme_mod('comments_gravatar_fullsize_size', 100);

?>
	<<?php echo $tag ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
	<div class="comment-author vcard">
	<?php if (!($comment_user = get_user_by('email', get_comment_author_email())) || !(user_can($comment_user->ID, 'administrator') || user_can($comment_user->ID, 'editor'))) {
			// dont show avatar for users which cant edit posts
		} else if (function_exists('avatar_manager_get_avatar') && ($avatar_html = avatar_manager_get_avatar(false, get_comment_author_email(), $args['avatar_size']))) { ?>
		<?php echo $avatar_html; ?>
	<?php } else if (wp_comment_has_avatar($comment->comment_ID)) {
		 if ( $args['avatar_size'] != 0 ) echo get_avatar(get_comment_author_email(), $args['avatar_size']); ?>
	<?php } else if (get_theme_mod('comments_gravatar_fullsize') == true) {
			// when here, it means, there is no existing avatar for this user but the avatar is forced to full size before commen
			// so display empty avatar image
			?>
			<img class="avatar" src="https://secure.gravatar.com/avatar/1ea87d5ecfe12f970e750ded1fec761c?s=150&d=mm&r=g" />
	<?php } ?>
	<?php printf( __( '<cite class="fn" style="display:inline-block;">%s</cite> <span class="says">says:</span>' ), get_comment_author_link() ); ?>
	</div>
	<?php if ( $comment->comment_approved == '0' ) : ?>
		<em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.' ); ?></em>
		<br />
	<?php endif; ?>

	<div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ); ?>">
		<?php
			/* translators: 1: date, 2: time */
			printf( __('%1$s at %2$s'), get_comment_date(),  get_comment_time() ); ?></a><?php edit_comment_link( __( '(Edit)' ), '  ', '' );
		?>
	</div>

	<?php /*ob_start(); comment_text(); $comment_text = ob_get_contents(); ob_end_clean();*/
		
		$comment_text = wpautop(linkify($comment->comment_content));
		
		 echo '<p>' . str_replace('|b|r|', '</p><p>', strip_tags(str_replace('</p>', '|b|r|', $comment_text), '<a><br>')) . '</p>'; ?>

	<div class="reply">
	<?php comment_reply_link( array_merge( $args, 
		array( 
		'add_below' => $add_below, 
		'depth' => $depth, 
		'max_depth' => current_user_can('editor') || current_user_can('administrator') || user_can($comment->user_id, 'administrator') || user_can($comment->user_id, 'editor') ? 9999 : $args['max_depth'] // admin/author and normal user can talk infinitely with eachother
		) 
		) ); ?>
	</div>
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
<?php
	do_action('senhblog_after_comment_template');
}

function linkify($value, $protocols = array('http', 'mail'), array $attributes = array())
{
    // Link attributes
    $attr = '';
    foreach ($attributes as $key => $val) {
        $attr = ' ' . $key . '="' . htmlentities($val) . '"';
    }
    
    $links = array();
    
    // Extract existing links and tags
    $value = preg_replace_callback('~(<a .*?>.*?</a>|<.*?>)~i', function ($match) use (&$links) { return '<' . array_push($links, $match[1]) . '>'; }, $value);
    
    // Extract text links for each protocol
    foreach ((array)$protocols as $protocol) {
        switch ($protocol) {
            case 'http':
            case 'https':   $value = preg_replace_callback('~(?:(https?)://([^\s<]+)|(www\.[^\s<]+?\.[^\s<]+))(?<![\.,:])~i', function ($match) use ($protocol, &$links, $attr) { if ($match[1]) $protocol = $match[1]; $link = $match[2] ?: $match[3]; return '<' . array_push($links, "<a $attr href=\"$protocol://$link\">$link</a>") . '>'; }, $value); break;
            case 'mail':    $value = preg_replace_callback('~([^\s<]+?@[^\s<]+?\.[^\s<]+)(?<![\.,:])~', function ($match) use (&$links, $attr) { return '<' . array_push($links, "<a $attr href=\"mailto:{$match[1]}\">{$match[1]}</a>") . '>'; }, $value); break;
            case 'twitter': $value = preg_replace_callback('~(?<!\w)[@#](\w++)~', function ($match) use (&$links, $attr) { return '<' . array_push($links, "<a $attr href=\"https://twitter.com/" . ($match[0][0] == '@' ? '' : 'search/%23') . $match[1]  . "\">{$match[0]}</a>") . '>'; }, $value); break;
            default:        $value = preg_replace_callback('~' . preg_quote($protocol, '~') . '://([^\s<]+?)(?<![\.,:])~i', function ($match) use ($protocol, &$links, $attr) { return '<' . array_push($links, "<a $attr href=\"$protocol://{$match[1]}\">{$match[1]}</a>") . '>'; }, $value); break;
        }
    }
    
    // Insert all link
    return preg_replace_callback('/<(\d+)>/', function ($match) use (&$links) { return $links[$match[1] - 1]; }, $value);
}