<?php

add_action('customize_register', 'senhblog_search_customize_register');
function senhblog_search_customize_register($wp_customize) {
    
    $wp_customize->add_section('senhblog_search', array(
        'title'    => customize_options_language('5c. Searchbox', '5c. Zoekveld'),
        'description' => '',
        'priority' => 124.1,
    ));

	/*$wp_customize->add_setting('searchbox_visible', array(
        'default'        => true,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('searchbox_visible', array(
        'label'      => customize_options_language('Searchbox visible', 'Zoekveld weergeven'),
        'section'    => 'senhblog_search',
        'settings'   => 'searchbox_visible',
		'type'		=> 'checkbox'
    ));*/

	$wp_customize->add_setting('searchbox_show_on_toggle', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('searchbox_show_on_toggle', array(
        'label'      => customize_options_language('Searchbox visible on toggle', 'Zoekveld ingeklapt weergeven'),
        'section'    => 'senhblog_search',
        'settings'   => 'searchbox_show_on_toggle',
		'type'		=> 'checkbox'
    ));

	$wp_customize->add_setting('searchbox_searchtoggle_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'searchbox_searchtoggle_color',
		array(
			'label'      => customize_options_language('Search icon color in menu', 'Zoek icoon kleur in menu') . ':',
			'section'    => 'senhblog_search',
			'settings'   => 'searchbox_searchtoggle_color'
		)
	));

	$wp_customize->add_setting('search_width', array(
        'default'        => '170',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'search_width', array(
        'label'      => customize_options_language('Searchbox width', 'Zoekveld breedte') . ':',
        'section'    => 'senhblog_search',
        'settings'   => 'search_width',
		'slider_min' => 50,
		'slider_max' => 500,
		'default' => 170
    )));

	$wp_customize->add_setting('search_height', array(
        'default'        => '28',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'search_height', array(
        'label'      => customize_options_language('Searchbox height', 'Zoekveld hoogte') . ':',
        'section'    => 'senhblog_search',
        'settings'   => 'search_height',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 28
    )));

	$wp_customize->add_setting('search_margintop', array(
        'default'        => '6',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'search_margintop', array(
        'label'      => customize_options_language('Searchbox margin top', 'Zoekveld afstand boven') . ':',
        'section'    => 'senhblog_search',
        'settings'   => 'search_margintop',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 6
    )));

	$wp_customize->add_setting('search_marginbottom', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'search_marginbottom', array(
        'label'      => customize_options_language('Searchbox margin bottom', 'Zoekveld afstand onder') . ':',
        'section'    => 'senhblog_search',
        'settings'   => 'search_marginbottom',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('search_marginright', array(
        'default'        => '0',
        'transport'     => 'postMessage'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'search_marginright', array(
        'label'      => customize_options_language('Searchbox margin right', 'Zoekveld afstand rechts') . ':',
        'section'    => 'senhblog_search',
        'settings'   => 'search_marginright',
		'slider_min' => 0,
		'slider_max' => 500,
		'default' => 0
    )));

	$wp_customize->add_setting('search_placeholder', array(
        'default'        => customize_options_language('Search...', 'Zoeken...'),
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control('search_placeholder', array(
        'label'      => customize_options_language('Searchbox placeholder text', 'Zoekveld begin tekst') . ':',
        'section'    => 'senhblog_search',
        'settings'   => 'search_placeholder'
    ));

	$wp_customize->add_setting('search_fontsize', array(
        'default'        => '12',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('search_fontsize', array(
        'label'      => customize_options_language('Search font size', 'Zoekveld lettertype grootte') . ':',
        'section'    => 'senhblog_search',
        'settings'   => 'search_fontsize',
		'type'		=> 'number'
    ));

	$wp_customize->add_setting('searchbox_visible_mobile', array(
        'default'        => 'hide',
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('searchbox_visible_mobile', array(
        'label'      => customize_options_language('Searchbox visible on mobile', 'Zoekveld weergeven op mobiel'),
        'section'    => 'senhblog_search',
        'settings'   => 'searchbox_visible_mobile',
		'type'		=> 'select',
		'choices'	=> array('hide' => customize_options_language('Hide on mobile', 'Verbergen op mobiel'), 'mainmenu' => customize_options_language('In main menu on toggle', 'In het hoofdmenu bij uitklapoptie'), 'right_search' => customize_options_language('Right at header with icon', 'Rechts bij hoofd met icoon'))
    ));

	$wp_customize->add_setting('searchbox_collapsed_on_mobile', array(
        'default'        => false,
        'transport'     => 'refresh'
    )); 
    $wp_customize->add_control('searchbox_collapsed_on_mobile', array(
        'label'      => customize_options_language('Searchbox collapsed on mobile', 'Zoekveld ingeklapt weergeven op mobiel'),
        'section'    => 'senhblog_search',
        'settings'   => 'searchbox_collapsed_on_mobile',
		'type'		=> 'checkbox'
    ));

	/*$wp_customize->add_setting('searchbox_search_color', array(
		'default' => '',
		'transport'	=> 'refresh'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control(
		$wp_customize,
		'searchbox_search_color',
		array(
			'label'      => customize_options_language('Searchbox icon color', 'Zoekveld icoon kleur') . ':',
			'section'    => 'senhblog_search',
			'settings'   => 'searchbox_search_color'
		)
	));*/

	$wp_customize->add_setting('search_scrolling_fontsize', array(
        'default'        => '100',
        'transport'     => 'refresh'
    ));
	$wp_customize->add_control(new WP_Slider_Control($wp_customize, 'search_scrolling_fontsize', array(
        'label'      => customize_options_language('Searchbox font size on scroll', 'Zoekveld lettertype grootte bij scroll'),
        'section'    => 'senhblog_search',
        'settings'   => 'search_scrolling_fontsize',
		'slider_min' => 0,
		'slider_max' => 100,
		'default' => 100,
		'extra_select_name' => '',
		'extra_select_choices' => array('%' => '%')
    )));

}