<?php

add_filter('widget_text', 'do_shortcode');

add_action('wp_enqueue_scripts', function() {
	wp_enqueue_script('jquery');
});

function senhtheme_is_singular() {
	return is_singular(get_post_type()) || get_post_type() == 'quiz';
}

function senhblog_get_queried_post() {
	global $wp_query;
	return $wp_query->post;
}

function senhblog_wp_set_option($option_name, $new_value) {
	if (get_option($option_name) !== false) {
		update_option($option_name, $new_value);
	} else {
		add_option($option_name, $new_value, null, 'no');
	}
}

function senhtheme_get_all_options() {
	return get_option('senhtheme_options');
}

function senhtheme_set_all_options($senhtheme_all_options) {
	if (get_option('senhtheme_options') !== false) {
		update_option('senhtheme_options', $senhtheme_all_options);
	} else {
		add_option('senhtheme_options', $senhtheme_all_options, null, 'yes');
	}
}

function senhtheme_get_option($option_name) {
	$senhtheme_options = senhtheme_get_all_options();
	return $senhtheme_options[$option_name];
}

function senhtheme_set_options($new_values) {
	$senhtheme_all_options = senhtheme_get_all_options();
	foreach ($new_values as $option_name => $new_value) {
		$senhtheme_all_options[$option_name] = $new_value;
	}
	senhtheme_set_all_options($senhtheme_all_options);
}

function senhtheme_set_option($option_name, $new_value) {
	$new_values = array();
	$new_values[$option_name] = $new_value;
	senhtheme_set_options($new_values);
}

function senhblog_get_current_url() {
	return (is_ssl() ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
}

function senhblog_parse_https($url) {
	return str_replace('http://', 'https://', $url);
}

add_filter('body_class', 'senhblog_add_body_classes');
function senhblog_add_body_classes($classes) {
	if ($layout_themefont = get_theme_mod('layout_themefont', 'Verdana.css')) {
		$classes []= 'ThemeFont_' . str_replace('.css', '', $layout_themefont);
	}
	if (($headings_themefont = get_theme_mod('content_headings_fontfamily')) || ($heading_themefont = $layout_themefont)) {
		$classes []= 'ThemeFont_Headings_' . str_replace('.css', '', $headings_themefont);
	}
	return $classes;
}

function senhblog_post_description($post) {
	$show = get_theme_mod('blog_post_description', 'meta_description');
	if ($show == 'meta_description') {
		return get_post_meta(get_the_ID(), '_yoast_wpseo_metadesc', true);
	}

	// show content before more tag
	$content_arr = get_extended($post->post_content);//get_the_content($post));
	return apply_filters('the_content', $content_arr['main']);
}

function senhblog_get_closest_thumbnail_size($size) {
	if ($size > 300*1.5)
		return 'large';
	else if ($size > 150*1.5)
		return 'medium';
	else
		return array(150,150); // thumbnail
}

function senhblog_blog_featured_image_width() {
	// estimation
	$w = get_theme_mod('layout_container_width', '1150');
	if (senhblog_is_visible('sidebar')) {
		$w -= get_theme_mod('layout_sidebar_width', '300');
	}
	$w /= get_theme_mod('blog_num_posts_row', 2);
	return $w;
}

function senhblog_post_content_width() {
	// estimate post width
	$w = get_theme_mod('layout_container_width', '1150');
	if (senhblog_is_visible('sidebar')) {
		$w -= get_theme_mod('layout_sidebar_width', '300');
	}
	return $w;
}

function senhblog_is_layout_boxed() {
	return !get_theme_mod('layout_fullwidth_header_footer', true);
}

function senhblog_is_visible($el) {
	return apply_filters('senhblog_is_visible', true, $el);
}

add_filter('senhblog_is_visible', function($visible, $el) {
	if ($el == 'sidebar') {
		$sidebar_visibility = get_theme_mod('layout_sidebar_visibility', 'show_sidebar');
		if ($sidebar_visibility == 'show_sidebar') {
			$visible = true;
		} else if ($sidebar_visibility == 'hide_sidebar_on_archive' && is_singular()) {
			$visible = true;
		} else {
			$visible = false;
		}
	} else if ($el == 'post_details') {
		// by default only posts have post_details
		if (is_single()) {
			$visible = true;
		} else {
			$visible = false;
		}
	}
	return $visible;
}, 10, 2);

add_action('senhblog_before_blogheader', 'senhblog_before_blogheader');
function senhblog_before_blogheader() {
	if (is_single()) {
		if (has_post_thumbnail() && get_theme_mod('content_image_position', 'on_first_line') == 'above_title' && senhblog_is_visible('featured-image')) { ?>
		<div class="post-featured-image-container">
		<?php the_post_thumbnail(senhblog_get_closest_thumbnail_size(senhblog_post_content_width()),array('class' => 'post-featured-image')); ?>
		</div>
		<?php } else {
		    echo '<div class="empty-blog-header" style="height: 50px;"></div>';
        }
	}
}

add_action('senhblog_before_blogtitle', 'senhblog_before_blogtitle');
function senhblog_before_blogtitle() {
	if (senhblog_is_visible('post_details')) {
		if (get_theme_mod('content_details_position') == 'above_title') {
			senhblog_post_metadata_icons();
		}
	}
}

function senhblog_post_metadata_icons($print = true) {
	$details_position = get_theme_mod('content_details_position', 'below_title');
	$details = explode(',', get_theme_mod('blog_post_details_order_' . $details_position, 'author,category,date,comments'));

	$metaicons = array();
	foreach ($details as $icon) {
		if (get_theme_mod('blog_post_show_' . $icon) && get_theme_mod('blog_post_' . $icon . '_position', 'below_title') == $details_position) {
			$metaicons []= $icon;
		}
	}

	if (get_theme_mod('content_show_gravatar', false)) {
		array_unshift($metaicons, 'avatar');
	}

	ob_start();
	if (function_exists('get_field') && get_field('show_new_metadata_format', 'option')) {
	    set_new_post_details();
    } else {
        echo '<div class="post-details ' . (!empty($metaicons) && is_array($metaicons) ? 'has-' . join(' has-', $metaicons) : '') . '">';
        senhblog_metadata_icons(join(',', $metaicons) . ',edit', '', get_theme_mod('content_seperator_post_details', '|'));
        echo '</div>';
    }
	$content = ob_get_contents();
	ob_end_clean();

	if ($print)
		echo $content;
	else
		return $content;
}

add_filter('senhblog_blogtitle', 'senhblog_get_blogtitle');
function senhblog_get_blogtitle($blogtitle) {
	if (is_home()) {
		if (is_plugin_active('wordpress-seo/wp-seo.php') && get_theme_mod('blog_title_use_yoast_meta_title') && class_exists('WPSEO_Frontend')) {
			$blogtitle = WPSEO_Frontend::get_instance()->get_title_from_options('title-home-wpseo');
		} else if (is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php') && get_theme_mod('blog_title_use_yoast_meta_title')) {
			$aiosp = new All_in_One_SEO_Pack();
			$blogtitle = $aiosp->get_aioseop_title(null);
		} else {
			$blogtitle = get_theme_mod('blogheader_title');
		}
	} else if (is_single()) {
		$blogtitle = get_the_title();
	} else if (is_category() || is_tag() || is_search()) {
		$title_show_option = get_theme_mod('blogheader_title_cts_show', 'show_title');
		if ($title_show_option == 'hide_title') return;
		if ($title_show_option == 'show_title') {
			if (is_category()) {
				$blogtitle = 'Categorie: ' . single_cat_title('', false);
			} else if (is_tag()) {
				$blogtitle = 'Onderwerp: ' . single_tag_title('', false);
			} else if (is_search()) {
				$blogtitle = __('Search') . ': ' . get_search_query();
			}
		} else if ($title_show_option == 'show_default_title') {
			if (is_category()) {
				if ($t = get_term_by('id', get_query_var('cat'), 'category')) {
					$blogtitle = get_option('category_' . $t->term_id . '_default_title');
				}
			} else if (is_tag()) {
				$blogtitle = 'Onderwerp: ' . single_tag_title('', false);
			} else if (is_search()) {
			$blogtitle = __('Search') . ': ' . get_search_query();
			}
		} else if ($title_show_option = 'use_seo_title') {
			if (is_plugin_active('wordpress-seo/wp-seo.php') && class_exists('WPSEO_Frontend')){
				$blogtitle = WPSEO_Frontend::get_instance()->title('');
			} else if (is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php')) {
				$aiosp = new All_in_One_SEO_Pack();
				$blogtitle = $aiosp->get_original_title();
			}
		}
	} else if (is_page() || get_post_type() == 'quiz') {
		$blogtitle = get_the_title();
	} else if (is_author()) {
		$blogtitle = 'Auteur: ' . get_the_author();
	} else if (is_404()) {
		$blogtitle = __('Niets gevonden');
	}
	return $blogtitle;
}

add_filter('senhblog_blogdescription', 'senhblog_get_blogdescription');
function senhblog_get_blogdescription($desc) {
	global $post;
	if (is_home()) {
		if (is_plugin_active('wordpress-seo/wp-seo.php') && get_theme_mod('blog_title_use_yoast_meta_description') && class_exists('WPSEO_Frontend')) {
			$desc = WPSEO_Frontend::get_instance()->get_title_from_options('metadesc-home-wpseo');
		} else if (is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php') && get_theme_mod('blog_title_use_yoast_meta_description')) {
			$aiosp = new All_in_One_SEO_Pack();
			$desc = $aiosp->apply_description_format($aiosp->get_main_description());
		} else {
			$desc = get_theme_mod('blogheader_description');
		}
	} else if (senhtheme_is_singular()) {
		if (senhblog_is_visible('post_details')) {
			/*$newdetails = array();
			$blogdetails = explode(',', get_theme_mod('blog_post_details_order_below_title', 'author,category,date,comments'));
			foreach ($blogdetails as $detail) {
				if (get_theme_mod('content_' . $detail . '_position') != 'above_title') {
					$newdetails []= $detail;
				}
			}*/
			if (get_theme_mod('content_details_position', 'below_title') != 'above_title') {
				$desc .= senhblog_post_metadata_icons(false);
			}
		}
	} else if (is_category() || is_tag() || is_tax()) {
		$title_desc_option = get_theme_mod('blogheader_description_cts_show', 'show_description');
		if ($title_desc_option == 'hide_description') return;
		if ($title_desc_option == 'show_description') {
			if (is_category()) {
				$desc = category_description();
			} else if (is_tag()) {
				$desc = tag_description();
			}
		}
		if (is_plugin_active('wordpress-seo/wp-seo.php') && $title_desc_option == 'use_seo_description') {
			global $wp_query;
			$term = $wp_query->get_queried_object();
			$metadesc_override = WPSEO_Taxonomy_Meta::get_term_meta($term, $term->taxonomy, 'desc');
			$desc = $metadesc_override;
		} else if (is_plugin_active('all-in-one-seo-pack/all_in_one_seo_pack.php') && $title_desc_option == 'use_seo_description') {
			$aiosp = new All_in_One_SEO_Pack();
			$desc = $aiosp->apply_description_format($aiosp->get_main_description());
		}
	}
	return do_shortcode($desc);
}




add_action('senhblog_content_404', 'senhblog_content_404');
function senhblog_content_404() {
	$sidebar_enabled = senhblog_is_visible('sidebar');// && get_theme_mod('layout_sidebar_enabled', true);
	$blogtitle = apply_filters('senhblog_blogtitle', '');
	$blogdescription = apply_filters('senhblog_blogdescription', '');
?>
	<div class="<?php echo $sidebar_enabled ? 'col-md-8' : 'col-xs-12'; ?>">
		<div class="main-content row">
			<div class="col-xs-12">
				<div class="blog-header">
					<?php do_action('senhblog_before_blogtitle'); ?>
					<?php if ($blogtitle) { ?><h1 class="blog-title"><?php echo $blogtitle; ?></h1><?php } ?>
					<?php if ($blogdescription) { ?><div class="blog-description"><?php echo $blogdescription; ?></div><?php } ?>
				</div>
			</div>
		</div>
		<?php senhblog_template('404'); ?>
	</div>
<?php
}


add_action('senhblog_content_default', 'senhblog_content_default');
function senhblog_content_default() {
	$sidebar_enabled = senhblog_is_visible('sidebar');// && get_theme_mod('layout_sidebar_enabled', true);
	$blogtitle = apply_filters('senhblog_blogtitle', '');
	$blogdescription = apply_filters('senhblog_blogdescription', '');
?>
	<div class="<?php echo $sidebar_enabled ? 'col-md-8' : 'col-xs-12'; ?>">
		<div class="main-content row">
			<div class=" col-xs-12">
				<div class="main-content-inner <?php echo is_single() ? 'post-content' : 'page-content'; ?>">
					<?php do_action('senhblog_before_blogheader'); ?>
					<?php if ($blogtitle || $blogdescription) { ?>
					<div class="blog-header">
						<div class="col-xs-12">
                            <?php if (function_exists('get_field') && get_field('show_new_metadata_format', 'option')): ?>
                                <?php if (is_single()) echo '<div class="senh_breadcrumbs">' . do_shortcode('[wpseo_breadcrumb]') . '</div>' ?>
                                <?php if ($blogtitle) { ?><h1 class="<?php echo (is_single() || is_page()) ? 'post-title post-title--new' : 'blog-title blog-title--new'; ?>"><?php echo $blogtitle; ?></h1><?php } ?>
                                <?php if ($blogdescription) { ?><div class="blog-description"><?php echo $blogdescription; ?></div><?php } ?>
                                <?php do_action('senhblog_before_blogtitle'); ?>
                            <?php else: ?>
                                <?php do_action('senhblog_before_blogtitle'); ?>
                                <?php if ($blogtitle) { ?><h1 class="<?php echo (is_single() || is_page()) ? 'post-title' : 'blog-title'; ?>"><?php echo $blogtitle; ?></h1><?php } ?>
                                <?php if ($blogdescription) { ?><div class="blog-description"><?php echo $blogdescription; ?></div><?php } ?>
                            <?php endif; ?>

						</div>
					</div>
					<?php } ?>
					<div class="inner-content" qqqq>
						<?php //(is_single() || is_page()) ? senhblog_template(is_single() ? 'post-single' : 'page') : senhblog_post_loop('<div class="col-xs-' . (12/get_theme_mod('blog_num_posts_row', 2)) . '">', '</div>'); ?>
						<?php
						$colclass = '';
						$numcols = get_theme_mod('blog_num_posts_row', 2);
						if ($numcols == 1) {
							$colclass = 'col-xs-12';
						} else if ($numcols < 4) {
							$colclass = 'col-xs-6 col-sm-' . (12/$numcols);
						} else {
							$colclass = 'col-xs-6 col-sm-4 col-md-' . (12/$numcols);
						}
						
						// the_content();
						senhblog_post_loop(senhtheme_is_singular() ? '' : '<div class="' . $colclass . '">', senhtheme_is_singular() ? '' : '</div>'); ?>
					</div>
				</div>
			</div>

			<div class="col-xs-12">

			<?php
			if (is_single() && get_theme_mod('content_show_biography'))
				senhblog_author_biography();

			if (comments_open(senhblog_get_queried_post()->ID)) {
				senhblog_comments();
			}
			?>

			<?php
			if (get_theme_mod('blog_pagination_position', 'below_content') == 'below_content') {
				echo '<div style="text-align:' . get_theme_mod('blog_pagination_position_alignment', 'left') . '">';
				senhblog_pagination();
				echo '</div>';
			}
			?>
			</div>
		</div>
	</div>
<?php
}

add_action('senhblog_content', 'senhblog_do_content');
function senhblog_do_content() {
	// set global post to primary queried post
	global $post;
	$post = senhblog_get_queried_post();


	//$type = is_home() ? 'home' : 'category';
	$type = ''; 
	if (is_404()) {
		$type = '404';
	}

	$action = 'senhblog_content_' . $type;
	if (!has_action($action))
		$action = 'senhblog_content_default';
	do_action($action);
}


function senhblog_author_biography() {
	if (senhblog_is_visible('biography')) {
		senhblog_template('author-biography');
	}
}


add_action('senhblog_blogheader', 'senhblog_blogheader');
function senhblog_blogheader() {
//	senhblog_template('blogheader');
}

add_action('wp_footer', 'senhblog_footer');
function senhblog_footer() {
	senhblog_template('footer');
}

function senhblog_post_loop($before_post = '', $after_post = '') {
    global $wp_query;

	if (!senhtheme_is_singular()) {
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$showposts = get_theme_mod('blog_num_posts_per_page', get_option('posts_per_page'));

		$general_query_args = array(
			'cat' => get_query_var('cat'),
			'post__not_in' => get_option('sticky_posts'),
		);

		if (get_search_query()) {
			$general_query_args['s'] = get_search_query();
		}

		if ($author = get_query_var('author')) {
			$general_query_args['author'] = $author;
		}

		$show_sticky = true;
		$show_sticky_on_all_pages = false;
		if ($show_sticky) {
			if ($show_sticky_on_all_pages || $paged == 1) {
				$has_sticky = false;
				$sticky_query = new WP_Query(array_merge($general_query_args, array(
					'posts_per_page' => 1,
					'post__in' => get_option('sticky_posts'),
					'ignore_sticky_posts' => '1'
				)));
				if ($sticky_query->have_posts()) {
					$posts = $sticky_query->get_posts();
					//make sure post is a sticky post
					if (is_sticky($posts[0]->ID)) {
						$showposts -= 1;
						$has_sticky = true;
					}
				}
				if (!$has_sticky) {
					// destroy sticky query
					$sticky_query = null;
				}
			}
		}

		// fix empty search results when using plugin relevanssi
		// bug description: http://www.relevanssi.com/knowledge-base/query_posts/
		if (!is_plugin_active('relevanssi/relevanssi.php')) {
			query_posts(array_merge($general_query_args, array(
				'showposts' => $showposts,
				'paged' => $paged,
				'post__not_in' => get_option('sticky_posts'), // don't fetch sticky posts
				'ignore_sticky_posts' => '1'
			)));
		}
	}

	// init post counter
	$i = 0;

	// if sticky post is required, loop the sticky posts query before the main query
	if (isset($sticky_query)) {
		senhblog_post_looper($sticky_query, $i, $before_post, $after_post, true);
	}

	// loop the main query
	senhblog_post_looper($wp_query, $i, $before_post, $after_post, false);
}

function senhblog_post_looper($the_query, &$i, $before_post, $after_post, $allow_sticky) {
	
	while ($the_query->have_posts()) {
	
		$the_query->the_post(); 

		// wtf wordpress
		if (!is_single() && is_sticky(get_the_ID()) && !$allow_sticky) continue;

		if ((!is_single() && !is_page()) && $i == get_theme_mod('promotionwidget_afternumposts')) {
			//senhblog_template('promotion-widget');
			dynamic_sidebar('promotion-widget');
		}

		echo $before_post;
		//senhblog_template('post-home');

		if (is_page() || get_post_type() == 'quiz') {
			$format = 'page';
		} else if (!is_single()) {
			$format = 'preview';
		}

		if (isset($format) && locate_template('templates/content-' . $format . '.php') != '') {
			get_template_part('templates/content', $format);
		} else {
			get_template_part('templates/content', 'default');
		}

		echo $after_post;

		$i++;

		if ((!is_single() && !is_page()) && $i == get_theme_mod('promotionwidget_afternumposts')) {
			dynamic_sidebar('promotion-widget');
		}
	}
	wp_reset_postdata();
}

function senhblog_template($name) {
	include __DIR__ . '/../templates/' . $name . '.php';
}

function senhblog() {
	do_action('senhblog_init');
	get_header();
	do_action('senhblog_content');
	get_footer();
}

add_action('after_setup_theme', 'senhblog_setup');
function senhblog_setup() {
	if (current_user_can('manage_options')) {
		show_admin_bar(true);

		//enable link relationship xfn
		//add_filter('pre_option_link_manager_enabled', '__return_true');
	}

	add_theme_support('post-thumbnails', array('post', 'page'));
	//add_image_size('thumb-home', 170, 225, true);
	//add_image_size('thumb-recent', 75, 99, true);
	//add_image_size('detail', 688, 368, true);
	add_post_type_support('page', 'excerpt');
	remove_action('wp_head', 'wp_generator');


	// remove style from queue
	wp_deregister_style('meal-add-anchor-links');

	// problem with regenerating post thumbnails on dchange of size
	//add_theme_support('post-thumbnails');
	//set_post_thumbnail_size(get_theme_mod('blog_post_imagecontainer_maxheight', 100), get_theme_mod('blog_post_imagecontainer_maxheight', 200));

	update_option('thumbnail_size_w', 256);
	update_option('thumbnail_size_h', 144);
}

function set_new_post_details() {
    // Get post details
    $post_id = get_the_ID();
    $title = get_the_title($post_id);
    $user_id = get_the_author_meta('ID');
    $author_page = get_author_posts_url($user_id);
    $author = get_the_author();
    $publish_date = get_the_date();
    $modified_date = get_the_modified_date();
    $comments_count = get_comments_number();

    $has_reviewer = get_field('reviewer_group', 'option')['has_reviewer'];
    $has_special_reviewer = get_field('special_reviewer_group', 'option')['has_special_reviewer'];

    // Start the output buffer
    ob_start();

    // Declare and initialize string with class
    // echo '<div class="details-list metadata-icons" sqsq>';

    // echo '<a href="' . $author_page . '" class="post-avatar">' . str_replace('http:', '', get_avatar(get_the_author_meta('user_email', $user_id))) . '</a>' . $content;

    // echo '<div>';
	
	?>

	<div class="details-list metadata-icons" sqsq>
		 
		<a href="<?= $author_page;?>" class="post-avatar"><?= str_replace('http:', '', get_avatar(get_the_author_meta('user_email', $user_id)));?></a><?=  $content;?>

    <div>
	
	<?php
	
    // Set author
    printf('%s <a href="%s">%s</a>',
        __('Geschreven door', 'senhtheme'),
        $author_page,
        $author);

    // Set date
    if (strtotime(get_the_date('d-m-Y')) > strtotime('-1 year')) printf(' %s %s',
        __('op', 'senhtheme'),
        $publish_date);

    if (!is_home() && !is_front_page() && get_post_type() === 'post') {
        // Set reviewer
        if ($has_reviewer) {
            $reviewer = get_userdata(get_field('reviewer', $post_id));
            $reviewer_page = get_author_posts_url($reviewer->ID);

            if (!empty($reviewer)) {
                printf(' - %s <a href="%s">%s</a>',
                    __('Gereviewd door', 'senhtheme'),
                    !empty($reviewer_page) ? $reviewer_page : '/blog',
                    $reviewer->display_name);
            }
        }

        // Set special reviewer
        if ($has_special_reviewer) {
            $special_reviewer = get_userdata(get_field('special_reviewer', $post_id));

            if (!empty($special_reviewer)) {
                $text = get_field('special_reviewer_group', 'option')['special_reviewer_text'];
                $special_reviewer_text = !empty($text) ? $text : 'Medisch gereviewd door';
                $special_reviewer_page = get_author_posts_url($reviewer->ID);

                printf(' - %s <a href="%s">%s</a>',
                    __($special_reviewer_text, 'senhtheme'),
                    !empty($special_reviewer_page) ? $special_reviewer_page : '/blog',
                    $special_reviewer->display_name);
            }
        }
    }

    // Set modified date
    if (strtotime(get_the_modified_date('d-m-Y')) > strtotime('-1 year') && get_post_meta($post_id, 'use_custom_modified_date', true)) printf(' - %s %s',
        __('Bijgewerkt op', 'senhtheme'),
        $modified_date);

    // Comments count
    if ($comments_count > 0) {
        printf(' - <a href="#comments">%d %s</a>',
            $comments_count,
            $comments_count == 1 ? __('reactie', 'senhtheme') : __('reacties', 'senhtheme'));
    }

    // Set edit post link
    edit_post_link(__('Artikelen bewerken', 'senhtheme'), ' - ', '');


    // Close string with closing div tag
   // echo '</div>';
    //echo '</div>';
	?>
</div></div>
	<?php
//    echo $title;

    // return ob_flush();
    //return 
	echo ob_get_clean();
}
