<?php

add_filter('embed_oembed_html', 'senhtheme_oembed_filter', 10, 4);
function senhtheme_oembed_filter($html, $url, $attr, $post_ID) {
	$rel = get_theme_mod('blog_post_video_dont_include_rel', false) ? '0' : '1';
	$html = str_replace('?feature=oembed"', '?feature=oembed&rel=' . $rel . '"', $html);
    $return = '<div class="video-container">' . $html . '</div>';
    return $return;
}

add_action('senhtheme_customize_css', 'senhtheme_video_style');
function senhtheme_video_style() {
	$video_width = get_theme_mod('blog_post_video_width', 550);
	$video_height_ratio = 9/16;
	$video_height = $video_width*$video_height_ratio;
?>
	.video-container {
		margin-bottom: 12px;
	}
	.video-container > iframe {
		width: <?php echo $video_width; ?>px !important;
		height: <?php echo $video_height; ?>px !important;
	}
<?php
}

add_action('senhtheme_js', 'senhtheme_video_js');
function senhtheme_video_js() {
	$video_height_ratio = 9/16;
?>
	function senhtheme_video_update_maxheight() {
		$('.video-container > iframe').each(function() {
			$(this).css('max-height', $(this).width()*<?php echo $video_height_ratio; ?>);
		});
	}
	senhtheme_video_update_maxheight();
	$(window).resize(senhtheme_video_update_maxheight);
<?php
}

add_filter('embed_defaults', 'senhtheme_embed_defaults');
function senhtheme_embed_defaults() {
	$video_width = get_theme_mod('blog_post_video_width', 550);
	$video_height_ratio = 9/16;
	$video_height = $video_width*$video_height_ratio;
	return array(
		'width' => $video_width,
		'height' => $video_height
	);
}

// backwards compatibility for httpv protocol
add_filter('the_content', function($content) {
	$content = str_replace(array('httpv://youtube.com', 'httpv://www.youtube.com'), 'https://youtube.com', $content);
	return $content;
}, 1);