<?php

require_once(DIR_SYSTEM . '/engine/neoseo_controller.php');
require_once(DIR_SYSTEM . '/engine/neoseo_view.php');

class ControllerExtensionModuleNeoSeoCategoryWallBlock extends NeoSeoController
{

	private $error = array();

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_moduleSysName = "neoseo_category_wall_block";
        $this->_module_code = "neoseo_firestore_free";
		$this->_modulePostfix = "";
		$this->_logFile = $this->_moduleSysName() . ".log";
		$this->debug = $this->config->get($this->_moduleSysName() . "_debug") == 1;
	}

	public function index()
	{

		$this->upgrade();

		$this->load->model('extension/' . $this->_route . '/' . $this->_moduleSysName());
		$data = $this->load->language('extension/' . $this->_route . '/' . $this->_moduleSysName());
		$this->document->setTitle($this->language->get('heading_title_raw'));

		$this->load->model('setting/setting');
		$this->load->model('setting/module');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			$globalModuleData[$this->_moduleSysName() . '_debug'] = $this->request->post[$this->_moduleSysName() . '_debug'];
			$this->model_setting_setting->editSetting($this->_moduleSysName(), $globalModuleData);

			$moduleData = array();
			foreach ($this->request->post as $key => $value) {
				$shortKey = str_replace($this->_moduleSysName() . "_", "", $key);
				if (in_array($shortKey, array("action", "debug"))) {
					continue;
				}
				$moduleData[$shortKey] = $value;
			}
			if (!isset($this->request->get['module_id'])) {
				$this->model_setting_module->addModule($this->_moduleSysName(), $moduleData);
				$module_id = $this->db->getLastId();
			} else {
				$this->model_setting_module->editModule($this->request->get['module_id'], $moduleData);
				$module_id = $this->request->get['module_id'];
			}

			$this->session->data['success'] = $this->language->get('text_success');

			if ($this->request->post['action'] == 'save') {
				$this->response->redirect($this->url->link('extension/' . $this->_route . '/' . $this->_moduleSysName(), "module_id=" . $module_id . '&user_token=' . $this->session->data['user_token'], 'SSL'));
			} else {
				$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'], 'SSL'));
			}
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		}

		$data = $this->initBreadcrumbs(array(
			array('marketplace/extension', 'text_module'),
			array('extension/' . $this->_route . '/' . $this->_moduleSysName(), "heading_title_raw")), $data);

		if (!isset($this->request->get['module_id'])) {
			$data['save'] = $this->url->link('extension/' . $this->_route . '/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'], 'SSL');
			$data['save_and_close'] = $this->url->link('extension/' . $this->_route . '/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . "&close=1", 'SSL');
		} else {
			$data['save'] = $this->url->link('extension/' . $this->_route . '/' . $this->_moduleSysName(), 'module_id=' . $this->request->get['module_id'] . '&user_token=' . $this->session->data['user_token'], 'SSL');
			$data['save_and_close'] = $this->url->link('extension/' . $this->_route . '/' . $this->_moduleSysName(), 'module_id=' . $this->request->get['module_id'] . '&user_token=' . $this->session->data['user_token'] . "&close=1", 'SSL');
		}
		$data = $this->initButtons($data);
		$data['user_token'] = $this->session->data['user_token'];

		$data['modules'] = array();

		$this->load->model('localisation/language');
		$languages = array();
		foreach ($this->model_localisation_language->getLanguages() as $language) {
			$languages[$language['language_id']] = $language['name'];
		}
		$data['languages'] = $languages;
		$data['full_languages'] = $this->model_localisation_language->getLanguages();

		$defaultTitle = array();
		foreach ($data['languages'] as $language_id => $name) {
			$defaultTitle[$language_id] = $this->language->get('text_default_title');
		}

		$defaultDescription = array();
		foreach ($data['languages'] as $language_id => $name) {
			$defaultDescription[$language_id] = $this->language->get('text_default_description');
		}

		$this->load->model('tool/neoseo_menu');
		$categories = $this->model_tool_neoseo_menu->getMenus();
		if ($categories) {
			foreach ($categories as $category) {
				$data['categories'][$category['menu_id']] = $category['title'];
			}
		}

		$data = $this->initModuleParams(array(
			array($this->_moduleSysName() . '_status', 1),
			array($this->_moduleSysName() . '_debug', 0),
			array($this->_moduleSysName() . '_name', ""),
			array($this->_moduleSysName() . '_type', 1),
			array($this->_moduleSysName() . '_title', $defaultTitle),
			array($this->_moduleSysName() . '_description', $defaultDescription),
			array($this->_moduleSysName() . '_categories_id'),
			array($this->_moduleSysName() . '_icon_width', 200),
			array($this->_moduleSysName() . '_icon_height', 200),
			array($this->_moduleSysName() . '_template', "default"),
		), $data, $this->_moduleSysName());

		//$data = $this->initParams(array(array($this->_moduleSysName() . '_debug', 0),), $data, $this->_moduleSysName());
		$data = $this->initParamsListEx($this->{"model_extension_" . $this->_route . "_" . $this->_moduleSysName()}->getParams(), $data);


		$data['templates'] = array();

		$template_files = glob(DIR_CATALOG . 'view/theme/neoseo_firestore/template/extension/' . $this->_route . '/' . $this->_moduleSysName() . '_*');

		if ($template_files) {
			foreach ($template_files as $template_file) {
				$template_file_name = str_replace($this->_moduleSysName() . "_", "", basename($template_file));
				$data['templates'][$template_file_name] = $this->language->get('text_template') . " - " . $template_file_name;
			}
		}

		$widgets = new NeoSeoWidgets($this->_moduleSysName() . '_', $data);
		$widgets->text_select_all = $this->language->get('text_select_all');
		$widgets->text_unselect_all = $this->language->get('text_unselect_all');
		$data['widgets'] = $widgets;

		$data['params'] = $data;

		$data["logs"] = $this->getLogs();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/' . $this->_route . '/' . $this->_moduleSysName(), $data));
	}

	private function validate()
	{
		if (!$this->user->hasPermission('modify', 'extension/' . $this->_route . '/' . $this->_moduleSysName())) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		if (isset($this->request->post[$this->_moduleSysName() . '_module'])) {
			foreach ($this->request->post[$this->_moduleSysName() . '_module'] as $key => $value) {
				if (!$value['image_width'] || !$value['image_height']) {
					$this->error['image'][$key] = $this->language->get('error_image');
				}
			}
		}

		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}

}

?>