<?php

require_once( DIR_SYSTEM . "/engine/neoseo_controller.php");
require_once( DIR_SYSTEM . '/engine/neoseo_view.php' );

class ControllerCatalogNeoSeoFilterPageGenerator extends NeoSeoController
{

	private $error = array();

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_moduleSysName = "neoseo_filter_page_generator";
		$this->_module_code = "neoseo_firestore_free";
		$this->_logFile = $this->_moduleSysName() . ".log";
		$this->debug = $this->config->get($this->_moduleSysName() . "_debug");
	}

	public function index()
	{
		$this->getList();
	}

	public function processFilterOption($data)
	{
		$this->load->model('catalog/neoseo_filter');
		// Нужно выделить все $option_ и записать их в одно значение options
		$result = array();
		$options = array();
		foreach ($data as $key => $value) {
			if ($key == 'filter_option') {
				foreach ($value as $option_id => $option_vules) {
					$options[] = $option_id . ModelCatalogNeoseoFilter::OPTION_VALUE_SEP . implode(ModelCatalogNeoseoFilter::VALUES_SEP, $option_vules);
					continue;
				}
			} else {
				$result[$key] = $value;
			}
		}

		if ($options) {
			$options_str = implode(ModelCatalogNeoseoFilter::OPTIONS_SEP, $options);

			// А теперь надо отсортировать согласно sort_order
			$options = $this->model_catalog_neoseo_filter->explodeFilterParam($options_str);
			$options_str = $this->model_catalog_neoseo_filter->buildFilterParam($options);
			$result['options'] = $options_str;
		} else {
			$result['options'] = '';
		}

		return $result;
	}

	public function add()
	{
		$data = $this->load->language('catalog/' . $this->_moduleSysName());

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/' . $this->_moduleSysName());

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$data = $this->processFilterOption($this->request->post);
			$rule_id = $this->model_catalog_neoseo_filter_page_generator->addRule($data);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_category'])) {
				$url .= '&filter_category=' . urlencode(html_entity_decode($this->request->get['filter_category'], ENT_QUOTES, 'UTF-8'));
			}

			if ($this->request->post['action'] == 'save') {
				$this->response->redirect($this->url->link('catalog/' . $this->_moduleSysName() . '/edit', 'user_token=' . $this->session->data['user_token'] . '&rule_id=' . $rule_id . $url, 'SSL'));
			} else {
				$this->response->redirect($this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
			}
		}

		$this->getForm();
	}

	public function edit()
	{
		$data = $this->load->language('catalog/' . $this->_moduleSysName());

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/' . $this->_moduleSysName());

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validateForm()) {
			$data = $this->processFilterOption($this->request->post);
			$this->model_catalog_neoseo_filter_page_generator->editRule($this->request->get['rule_id'], $data);

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_category'])) {
				$url .= '&filter_category=' . urlencode(html_entity_decode($this->request->get['filter_category'], ENT_QUOTES, 'UTF-8'));
			}

			if ($this->request->post['action'] == 'save') {
				$this->response->redirect($this->url->link('catalog/' . $this->_moduleSysName() . '/edit', 'user_token=' . $this->session->data['user_token'] . '&rule_id=' . $this->request->get['rule_id'] . $url, 'SSL'));
			} else {
				$this->response->redirect($this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
			}
		}

		$this->getForm();
	}

	public function delete()
	{
		$this->load->language('catalog/' . $this->_moduleSysName());

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/' . $this->_moduleSysName());

		$rules = array();
		if (isset($this->request->post['selected'])) {
			foreach ($this->request->post['selected'] as $rule_id) {
				$rules[] = $rule_id;
			}
		} else if (isset($this->request->get['rule_id'])) {
			$rules[] = (int) $this->request->get['rule_id'];
		}

		if ($rules && $this->validateDelete()) {
			foreach ($rules as $rule_id) {
				$this->model_catalog_neoseo_filter_page_generator->deleteRule($rule_id);
			}

			$this->session->data['success'] = $this->language->get('text_success');

			$url = '';

			if (isset($this->request->get['sort'])) {
				$url .= '&sort=' . $this->request->get['sort'];
			}

			if (isset($this->request->get['order'])) {
				$url .= '&order=' . $this->request->get['order'];
			}

			if (isset($this->request->get['page'])) {
				$url .= '&page=' . $this->request->get['page'];
			}

			if (isset($this->request->get['filter_h1'])) {
				$url .= '&filter_h1=' . urlencode(html_entity_decode($this->request->get['filter_h1'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_status'])) {
				$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_keyword'])) {
				$url .= '&filter_keyword=' . urlencode(html_entity_decode($this->request->get['filter_keyword'], ENT_QUOTES, 'UTF-8'));
			}

			if (isset($this->request->get['filter_category'])) {
				$url .= '&filter_category=' . urlencode(html_entity_decode($this->request->get['filter_category'], ENT_QUOTES, 'UTF-8'));
			}

			$this->response->redirect($this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));
		}

		$this->getList();
	}

	protected function getList()
	{
		$data = $this->load->language('catalog/' . $this->_moduleSysName());

		$this->document->addScript('view/javascript/bootstrap-toggle/js/bootstrap-toggle.min.js');
		$this->document->addStyle('view/javascript/bootstrap-toggle/css/bootstrap-toggle.min.css');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('catalog/' . $this->_moduleSysName());
		$this->load->model('catalog/category');
		$this->load->model('catalog/neoseo_filter');

		if (isset($this->request->get['filter_status'])) {
			$filter_status = $this->request->get['filter_status'];
		} else {
			$filter_status = null;
		}

		if (isset($this->request->get['filter_category'])) {
			$filter_category = $this->request->get['filter_category'];
		} else {
			$filter_category = null;
		}

		if (isset($this->request->get['sort'])) {
			$sort = $this->request->get['sort'];
		} else {
			$sort = 'fpg.status';
		}

		if (isset($this->request->get['order'])) {
			$order = $this->request->get['order'];
		} else {
			$order = 'DESC';
		}

		if (isset($this->request->get['page'])) {
			$page = $this->request->get['page'];
		} else {
			$page = 1;
		}

		$url = '';

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . urlencode(html_entity_decode($this->request->get['filter_category'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
		);

		$data['add'] = $this->url->link('catalog/' . $this->_moduleSysName() . "/add", 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		$data['delete'] = $this->url->link('catalog/' . $this->_moduleSysName() . "/delete", 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		$data['generate'] = 'tool/' . $this->_moduleSysName() . '/jsonGeneratePage';
		$data['generate_all'] = 'tool/' . $this->_moduleSysName() . '/jsonGeneratePageAllRule';
		$data['generate_selected_rule'] = 'tool/' . $this->_moduleSysName() . '/jsonGeneratePageSelectedRule';

		$data['list_generator'] = array();

		$limit = $this->config->get($this->_moduleSysName() . '_limit_pagination') ? $this->config->get($this->_moduleSysName() . '_limit_pagination') : 20;

		$filter_data = array(
			'filter_status' => $filter_status,
			'filter_category' => $filter_category,
			'sort' => $sort,
			'order' => $order,
			'start' => ($page - 1) * $limit,
			'limit' => $limit
		);

		$rules_total = $this->model_catalog_neoseo_filter_page_generator->getTotalRules($filter_data);

		// Categories
		$categories = array();
		$categories_filter_data = array(
			'sort' => 'name',
			'order' => 'ASC'
		);
		foreach ($this->model_catalog_category->getCategories($categories_filter_data) as $row) {
			$categories[$row['category_id']] = $row['name'];
		}
		$data['categories'] = $categories;

		$rules = $this->model_catalog_neoseo_filter_page_generator->getRules($filter_data);

		foreach ($rules as $value) {

			$options = $this->model_catalog_neoseo_filter->getFilterNames($value['options']);

			$data['list_generator'][] = array(
				'rule_id' => $value['rule_id'],
				'category' => ( isset($categories[$value['category_id']]) ? $categories[$value['category_id']] : "-"),
				'options' => utf8_substr(strip_tags(html_entity_decode($options)), 0, 100) . '..',
				'status' => $value['status'],
				'cron' => "php " . realpath(DIR_SYSTEM . "../cron/" . $this->_moduleSysName() . ".php") . " " . $value['rule_id'],
				'wget' => "wget " . trim(HTTPS_CATALOG, '/') . "/cron/" . $this->_moduleSysName() . ".php" . "?rule_id=" . $value['rule_id'],
				'edit' => $this->url->link('catalog/' . $this->_moduleSysName() . "/edit", 'user_token=' . $this->session->data['user_token'] . '&rule_id=' . $value['rule_id'] . $url, 'SSL'),
				'delete' => $this->url->link('catalog/' . $this->_moduleSysName() . "/delete", 'user_token=' . $this->session->data['user_token'] . '&rule_id=' . $value['rule_id'] . $url, 'SSL'),
			);
		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['selected'])) {
			$data['selected'] = (array) $this->request->post['selected'];
		} else {
			$data['selected'] = array();
		}

		$url = '';


		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . urlencode(html_entity_decode($this->request->get['filter_category'], ENT_QUOTES, 'UTF-8'));
		}

		if ($order == 'ASC') {
			$url .= '&order=DESC';
		} else {
			$url .= '&order=ASC';
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		$data['sort_status'] = $this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . '&sort=fp.status' . $url, 'SSL');

		$url = '';

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . urlencode(html_entity_decode($this->request->get['filter_category'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		$pagination = new Pagination();
		$pagination->total = $rules_total;
		$pagination->page = $page;
		$pagination->limit = $limit;
		$pagination->keyword = $this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');
		$pagination->url = $this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url . '&page={page}', 'SSL');

		$data['pagination'] = $pagination->render();

		$data['results'] = sprintf($this->language->get('text_pagination'), ($rules_total) ? (($page - 1) * $limit) + 1 : 0, ((($page - 1) * $limit) > ($rules_total - $limit)) ? $rules_total : ((($page - 1) * $limit) + $limit), $rules_total, ceil($rules_total / $limit));

		$data['filter_status'] = $filter_status;
		$data['filter_category'] = $filter_category;

		$data['sort'] = $sort;
		$data['order'] = $order;

		$data['language_id'] = $this->config->get('config_language_id');

		$data['user_token'] = $this->session->data['user_token'];
		$data['moduleSysName'] = $this->_moduleSysName();

		$widgets = new NeoSeoWidgets($this->_moduleSysName() . '_', $data);
		$data['widgets'] = $widgets;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/' . $this->_moduleSysName() . "_list", $data));
	}

	protected function getForm()
	{
		$this->load->model('catalog/category');
		$this->load->model('tool/image');

		$data = $this->load->language('catalog/' . $this->_moduleSysName());

		$data['text_form'] = !isset($this->request->get['rule_id']) ? $this->language->get('text_add') : $this->language->get('text_edit');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$url = '';

		if (isset($this->request->get['sort'])) {
			$url .= '&sort=' . $this->request->get['sort'];
		}

		if (isset($this->request->get['order'])) {
			$url .= '&order=' . $this->request->get['order'];
		}

		if (isset($this->request->get['page'])) {
			$url .= '&page=' . $this->request->get['page'];
		}

		if (isset($this->request->get['filter_status'])) {
			$url .= '&filter_status=' . urlencode(html_entity_decode($this->request->get['filter_status'], ENT_QUOTES, 'UTF-8'));
		}

		if (isset($this->request->get['filter_category'])) {
			$url .= '&filter_category=' . urlencode(html_entity_decode($this->request->get['filter_category'], ENT_QUOTES, 'UTF-8'));
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
		);

		if (!isset($this->request->get['rule_id'])) {
			$data['action'] = $this->url->link('catalog/' . $this->_moduleSysName() . "/add", 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');

			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_add'),
				'href' => $this->url->link('catalog/' . $this->_moduleSysName() . "/add", 'user_token=' . $this->session->data['user_token'] . $url, 'SSL')
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('text_edit'),
				'href' => $this->url->link('catalog/' . $this->_moduleSysName() . "/edit", 'user_token=' . $this->session->data['user_token'] . '&rule_id=' . $this->request->get['rule_id'] . $url, 'SSL')
			);

			$data['action'] = $this->url->link('catalog/' . $this->_moduleSysName() . "/edit", 'user_token=' . $this->session->data['user_token'] . '&rule_id=' . $this->request->get['rule_id'] . $url, 'SSL');
		}

		$data['cancel'] = $this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, 'SSL');
		$data['category_options'] = html_entity_decode($this->url->link('catalog/' . $this->_moduleSysName() . '/category_options', 'user_token=' . $this->session->data['user_token'] . $url, 'SSL'));

		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();


		$data['user_token'] = $this->session->data['user_token'];

		if (isset($this->request->get['rule_id'])) {
			$item_info = $this->model_catalog_neoseo_filter_page_generator->getRule($this->request->get['rule_id']);

			if (!$item_info) {
				$this->response->redirect($this->url->link('catalog/' . $this->_moduleSysName(), 'user_token=' . $this->session->data['user_token'] . $url, true));
			}

			$data['rule_id'] = $item_info['rule_id'];
			$data['category_id'] = isset($this->request->post['category_id']) ? $this->request->post['category_id'] : $item_info['category_id'];
			$data['status'] = isset($this->request->post['status']) ? $this->request->post['status'] : $item_info['status'];
			$data['options'] = isset($this->request->post['options']) && $this->request->post['options'] !== '' ? $this->request->post['options'] : $item_info['options'];
			$data['pattern_name'] = isset($this->request->post['pattern_name']) ? $this->request->post['pattern_name'] : unserialize($item_info['pattern_name']);
			$data['pattern_title'] = isset($this->request->post['pattern_title']) ? $this->request->post['pattern_title'] : unserialize($item_info['pattern_title']);
			$data['pattern_meta_description'] = isset($this->request->post['pattern_meta_description']) ? $this->request->post['pattern_meta_description'] : unserialize($item_info['pattern_meta_description']);
			$data['pattern_url'] = isset($this->request->post['pattern_url']) ? $this->request->post['pattern_url'] : unserialize($item_info['pattern_url']);
			$data['pattern_h1'] = isset($this->request->post['pattern_h1']) ? $this->request->post['pattern_h1'] : unserialize($item_info['pattern_h1']);
			$data['use_direct_link'] = isset($this->request->post['use_direct_link']) ? $this->request->post['use_direct_link'] : $item_info['use_direct_link'];
			$data['use_end_slash'] = isset($this->request->post['use_end_slash']) ? $this->request->post['use_end_slash'] : $item_info['use_end_slash'];
			$data['pattern_description'] = isset($this->request->post['pattern_description']) ? $this->request->post['pattern_description'] : unserialize($item_info['pattern_description']);
		} else {
			$data['status'] = isset($this->request->post['status']) ? $this->request->post['status'] : 0;
			$data['options'] = isset($this->request->post['options']) && $this->request->post['options'] !== '' ? $this->request->post['options'] : '';
			$data['category_id'] = 0;
			$data['pattern_name'] = isset($this->request->post['pattern_name']) ? $this->request->post['pattern_name'] : array();
			$data['pattern_title'] = isset($this->request->post['pattern_title']) ? $this->request->post['pattern_title'] : array();
			$data['pattern_meta_description'] = isset($this->request->post['pattern_meta_description']) ? $this->request->post['pattern_meta_description'] : array();
			$data['pattern_url'] = isset($this->request->post['pattern_url']) ? $this->request->post['pattern_url'] : array();
			$data['pattern_h1'] = isset($this->request->post['pattern_h1']) ? $this->request->post['pattern_h1'] : array();
			$data['pattern_description'] = isset($this->request->post['pattern_description']) ? $this->request->post['pattern_description'] : array();
			$data['use_direct_link'] = isset($this->request->post['use_direct_link']) ? $this->request->post['use_direct_link'] : 0;
			$data['use_end_slash'] = isset($this->request->post['use_end_slash']) ? $this->request->post['use_end_slash'] : 0;
		}
		// Убираем странный нотис при віводе локєйтинпут
		foreach ($this->model_localisation_language->getLanguages() as $language) {
			if (!isset($data['pattern_description'][$language['language_id']])) {
				$data['pattern_description'][$language['language_id']] = '';
			}
		}

		$data['language_id'] = $this->config->get('config_language_id');

		// Categories
		$this->load->model('catalog/category');
		$categories = array();
		$categories_filter_data = array(
			'sort' => 'name',
			'order' => 'ASC'
		);
		foreach ($this->model_catalog_category->getCategories($categories_filter_data) as $row) {
			$categories[$row['category_id']] = $row['name'];
		}
		$data['categories'] = $categories;

		$data['params'] = $data;

		$widgets = new NeoSeoWidgets('', $data);
		$widgets->text_select_all = $this->language->get('text_select_all');
		$widgets->text_unselect_all = $this->language->get('text_unselect_all');
		$data['widgets'] = $widgets;

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('catalog/' . $this->_moduleSysName() . "_form", $data));
	}

	protected function validateForm()
	{
		if (!$this->user->hasPermission('modify', 'catalog/' . $this->_moduleSysName())) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}

	protected function validateDelete()
	{
		if (!$this->user->hasPermission('modify', 'catalog/' . $this->_moduleSysName())) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		return !$this->error;
	}

	public function checkedStatus()
	{

		$this->load->language($this->_route . '/' . $this->_moduleSysName());
		$json = array();
		if (!$this->user->hasPermission('modify', $this->_route . '/' . $this->_moduleSysName()) || !isset($this->request->post['rule_id'])) {
			$json['error'] = $this->language->get('error_permission');
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput(json_encode($json));
			return;
		}

		$this->load->model($this->_route . '/' . $this->_moduleSysName());
		$this->model_catalog_neoseo_filter_page_generator->checkedStatus(
				$this->request->post['status'], $this->request->post['rule_id']
		);

		$json = array(
			'success' => true,
		);

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
		return;
	}

	public function category_options()
	{
		$data = $this->load->language($this->_route . '/' . $this->_moduleSysName());
		if (isset($this->request->post['category_id'])) {
			$category_id = (int) $this->request->post['category_id'];
			$selected_options_raw = $this->request->post['options'];

			$this->load->model('catalog/neoseo_filter');
			$filter_data = array(
				'filter_status' => 1,
				'filter_category' => $category_id,
			);

			$selected_options = $this->model_catalog_neoseo_filter->explodeFilterParam($selected_options_raw);

			$data['options'] = array();

			$manufacturers = $this->model_catalog_neoseo_filter->getManufacturersOptions($category_id);
			if ($manufacturers) {
				$values = array();
				foreach ($manufacturers as $manufacturer_id => $manufacturer_name) {
					$values[-$manufacturer_id] = array(
						"name" => $manufacturer_name,
						"selected" => isset($selected_options['m']) && in_array(-$manufacturer_id, $selected_options['m']),
					);
				}

				$data['options'][] = array(
					'option_id' => 'm',
					'name' => $this->language->get('text_manufacturer'),
					'values' => $values,
				);
			}
			$options = $this->model_catalog_neoseo_filter->getFilterOptions($filter_data);
			foreach ($options as $option) {

				$values = array();
				foreach ($this->model_catalog_neoseo_filter->getOptionValues($option['option_id']) as $option_value) {
					$values[$option_value['option_value_id']] = array(
						"name" => $option_value['name'],
						"selected" => isset($selected_options[$option['option_id']]) && in_array($option_value['option_value_id'], $selected_options[$option['option_id']]),
					);
				}
				$data['options'][] = array(
					'option_id' => $option['option_id'],
					'name' => $option['name'],
					'values' => $values,
				);
			}
		}


		$this->response->setOutput($this->load->view('catalog/' . $this->_moduleSysName() . '_product_options', $data));
	}

}
