<?php

require_once(DIR_SYSTEM . "/engine/neoseo_controller.php");

class ControllerExtensionModuleNeoseoQuickOrder extends NeoSeoController
{

	public function __construct($registry)
	{
		parent::__construct($registry);
		$this->_module_code = "neoseo_firestore_free";
		$this->_moduleSysName = "neoseo_quick_order";
		$this->_logFile = $this->_moduleSysName . ".log";
		$this->debug = $this->config->get($this->_moduleSysName . "_status") == 1;

	}

	public function index()
	{

		$data = $this->load->language("extension/module/" . $this->_moduleSysName);
		$data['mask'] = $this->config->get($this->_moduleSysName . "_phone_mask");

		$json = array();
		$json['result'] = "false";

		if (isset($this->request->post['type'])) {
			$type = $this->request->post['type'];
		} else {
			$type = 'one_product';
		}

		if (isset($this->request->post['product_id'])) {
			$product_id = $this->request->post['product_id'];
		} else {
			$product_id = 0;
		}

		$test_products = $product_id;

		$test_products = urldecode($test_products);
		$test_products = @unserialize($test_products);

		if ($type == 'one_product') {

			$post_products = $test_products;

			if (is_array($post_products) && count($post_products) == 0)
				$post_products[$product_id] = 1;

			if (!$post_products & isset($this->request->post['product_id']) & isset($this->request->post['min'])) {
				$post_products = array($this->request->post['product_id'] => $this->request->post['min']);
			}
		} else {
			$cart_products = $this->cart->getProducts();
			$post_products = $cart_products ? array() : $test_products;
			foreach ($cart_products as $product) {
				$post_products[$product['product_id']] = $product['quantity'];
			}
		}

		$data['text_agree'] = false;
		$agreement_id = $this->config->get($this->_moduleSysName . '_agreement_id');
		if ($agreement_id) {

			$this->load->model('catalog/information');
			$information_info = $this->model_catalog_information->getInformation($agreement_id);

			if ($information_info) {
				$data['text_agree'] = sprintf($this->language->get('text_agree'), $this->url->link('information/information', 'information_id=' . $agreement_id, 'SSL'), $information_info['title'], $information_info['title']);
			}
		}

		$data = $this->initSessionParams(array(
			array('agree', 'agree', $this->config->get($this->_moduleSysName . "_agreement_default")),
				), $data);

		$this->load->model('catalog/product');
		if (is_array($post_products)) {
			foreach ($post_products as $post_product_id => $post_quantity) {
				$product_info = $this->model_catalog_product->getProduct($post_product_id);
				if ($product_info) {
					$json['result'] = "true";

					$this->load->model('tool/image');
					if (isset($product_info['image']) && $product_info['image'] != '' && file_exists(DIR_IMAGE . $product_info['image'])) {
						$image = $this->model_tool_image->resize($product_info['image'], $this->config->get($this->_moduleSysName . "_image_width"), $this->config->get($this->_moduleSysName . "_image_height"));
					} else {
						$image = $this->model_tool_image->resize('placeholder.png', $this->config->get($this->_moduleSysName . "_image_width"), $this->config->get($this->_moduleSysName . "_image_height"));
					}

					if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
						$price = $this->currency->format($this->tax->calculate($product_info['price'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					} else {
						$price = false;
					}

					if ((float) $product_info['special']) {
						$special = $this->currency->format($this->tax->calculate($product_info['special'], $product_info['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
					} else {
						$special = false;
					}

					/* акцентр - конец */
					if (isset($product_info['customer_price']) && floatval($product_info['customer_price']) > 0) {
						$price = $this->currency->format($product_info['customer_price'], $this->session->data['currency']);
					}
					/* акцентр - конец */
					$json["product"][] = array(
						"product_id" => $product_info['product_id'],
						"image" => $image,
						"name" => $product_info["name"],
						"model" => $product_info['model'],
						"price" => $special ? $special : $price,
						"special" => $special,
						"href" => $this->url->link('product/product', 'product_id=' . $product_info['product_id']),
						"remove" => $this->url->link('account/wishlist', 'remove=' . $product_info['product_id'])
					);

					$data["product"] = $json["product"];
					if (!$this->customer->isLogged()) {
						$data["phone"] = '';
						$data["name"] = '';
					} else {
						$data["phone"] = $this->customer->getTelephone();
						$data["name"] = $this->customer->getFirstName();
					}
					$data["action"] = $this->url->link('extension/module/' . $this->_moduleSysName . '/process');
					$data[$this->_moduleSysName . '_phonemask'] = $this->config->get($this->_moduleSysName . '_phone_mask');
					if ($type == 'cart_product') {
						$data["check_min_amount"] = $this->dataCheckMinAmountCart();
					}
					$json['popup'] = $this->load->view('extension/module/' . $this->_moduleSysName . '_start', $data);
				}
			}
		}

		$this->response->setOutput(json_encode($json));
	}

	public function process()
	{
		$json = $this->checkOrderRestriction();
		if (isset($json['error'])) {
			$this->response->setOutput(json_encode($json));
			return;
		}

		$json['result'] = "false";

		if (!isset($this->request->post['product_id']) ||
				!isset($this->request->post['name']) ||
				!isset($this->request->post['phone'])) {
			$this->response->setOutput(json_encode($json));
			return;
		}


		if (isset($this->request->post['quantity'])) {
			$quantity = $this->request->post['quantity'];
		} else {
			$quantity = 1;
		}

		$data = $this->load->language("extension/module/" . $this->_moduleSysName);

		$data['invoice_prefix'] = $this->config->get('config_invoice_prefix');
		$data['store_id'] = $this->config->get('config_store_id');
		$data['store_name'] = $this->config->get('config_name');

		if ($data['store_id']) {
			$data['store_url'] = $this->config->get('config_url');
		} else {
			$data['store_url'] = HTTP_SERVER;
		}

		$data['customer_id'] = 0;
		$data['customer_group_id'] = (int) $this->config->get('config_customer_group_id');
		$data['email'] = "";
		$data['firstname'] = $this->request->post['name'];
		$data['telephone'] = $this->request->post['phone'];
		$data['lastname'] = "";
		$data['fax'] = "";

		$data['shipping_firstname'] = $this->request->post['name'];
		$data['shipping_lastname'] = '';
		$data['shipping_company'] = '';
		$data['shipping_address_1'] = '';
		$data['shipping_address_2'] = '';
		$data['shipping_city'] = $this->config->get($this->_moduleSysName . '_city');
		$data['shipping_postcode'] = '';
		$data['shipping_zone'] = '';
		$data['shipping_zone_id'] = '';
		$data['shipping_country'] = '';
		$data['shipping_country_id'] = $this->config->get($this->_moduleSysName . '_country_id');
		$data['shipping_address_format'] = '';

		if (!isset($this->session->data['shipping_methods'])) {
			$method_data = array();

			$this->load->model('setting/extension');

			$results = $this->model_setting_extension->getExtensions('shipping');

			foreach ($results as $result) {
				if ($this->config->get('shipping_' . $result['code'] . '_status')) {
					$this->load->model('extension/shipping/' . $result['code']);

					$quote = $this->{'model_extension_shipping_' . $result['code']}->getQuote([
						'country_id' => $this->config->get($this->_moduleSysName . '_country_id'),
						'zone_id' => 0
					]);

					if ($quote) {
						$method_data[$result['code']] = array(
							'title' => $quote['title'],
							'quote' => $quote['quote'],
							'sort_order' => $quote['sort_order'],
							'error' => $quote['error']
						);
					}
				}
			}

			$sort_order = array();

			foreach ($method_data as $key => $value) {
				$sort_order[$key] = $value['sort_order'];
			}

			array_multisort($sort_order, SORT_ASC, $method_data);

			$this->session->data['shipping_methods'] = $method_data;
		}

		if (!isset($this->session->data['shipping_method'])) {
			$shipping = $this->config->get($this->_moduleSysName . '_shipping_method');

			if ($shipping && isset($this->session->data['shipping_methods'][$shipping]['quote'][$shipping])) {
				$this->session->data['shipping_method'] = $this->session->data['shipping_methods'][$shipping]['quote'][$shipping];
			}
		}

		$data['shipping_method'] = isset($this->session->data['shipping_method']) ? $this->session->data['shipping_method']['title'] : $this->language->get('button_quick_order');
		$data['shipping_code'] = isset($this->session->data['shipping_method']) ? $this->session->data['shipping_method']['code'] : 'free.free';

		if ($this->customer->isLogged()) {
			$data['customer_id'] = $this->customer->getId();
			$data['customer_group_id'] = $this->customer->getGroupId();
			$data['email'] = $this->customer->getEmail();
			$data['lastname'] = $this->customer->getLastName();
			$data['shipping_lastname'] = $this->customer->getLastName();
			$data['fax'] = $this->customer->getFax();

			$this->load->model('account/address');
			$address = $this->model_account_address->getAddress($this->customer->getAddressId());
			if ($address) {
				$data['shipping_company'] = $address['company'];
				$data['shipping_address_1'] = $address['address_1'];
				$data['shipping_address_2'] = $address['address_2'];
				$data['shipping_city'] = $address['city'];
				$data['shipping_postcode'] = $address['postcode'];
				$data['shipping_zone'] = $address['zone'];
				$data['shipping_zone_id'] = $address['zone_id'];
				$data['shipping_country'] = $address['country'];
				$data['shipping_country_id'] = $address['country_id'];
			}
		}

		$data['payment_firstname'] = $this->request->post['name'];
		$data['payment_lastname'] = $data['lastname'];
		$data['payment_company'] = $data['shipping_company'];
		$data['payment_tax_id'] = "";
		$data['payment_address_1'] = $data['shipping_address_1'];
		$data['payment_address_2'] = $data['shipping_address_2'];
		$data['payment_city'] = $data['shipping_city'];
		$data['payment_postcode'] = $data['shipping_postcode'];
		$data['payment_zone'] = $data['shipping_zone'];
		$data['payment_zone_id'] = $data['shipping_zone_id'];
		$data['payment_country'] = $data['shipping_country'];
		$data['payment_country_id'] = $data['shipping_country_id'];
		$data['payment_address_format'] = "";

		if (!isset($this->session->data['payment_methods'])) {
			// Totals

			$totals = array();
			$taxes = $this->cart->getTaxes();
			$total = 0;

			// Because __call can not keep var references so we put them into an array.
			$total_data = array(
				'totals' => &$totals,
				'taxes' => &$taxes,
				'total' => &$total
			);

			$this->load->model('setting/extension');

			$sort_order = array();

			$results = $this->model_setting_extension->getExtensions('total');

			foreach ($results as $key => $value) {
				$sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
			}

			array_multisort($sort_order, SORT_ASC, $results);

			foreach ($results as $result) {
				if ($this->config->get('total_' . $result['code'] . '_status')) {
					$this->load->model('extension/total/' . $result['code']);

					$this->{'model_extension_total_' . $result['code']}->getTotal($total_data);
				}
			}

			// Payment Methods
			$method_data = array();

			$this->load->model('setting/extension');

			$results = $this->model_setting_extension->getExtensions('payment');

			foreach ($results as $result) {
				if ($this->config->get('payment_' . $result['code'] . '_status')) {
					$this->load->model('extension/payment/' . $result['code']);

					$method = $this->{'model_extension_payment_' . $result['code']}->getMethod([
						'country_id' => $this->config->get($this->_moduleSysName . '_country_id'),
						'zone_id' => 0
							], $total);

					if ($method) {
						$method_data[$result['code']] = $method;
					}
				}
			}

			$sort_order = array();

			foreach ($method_data as $key => $value) {
				$sort_order[$key] = $value['sort_order'];
			}

			array_multisort($sort_order, SORT_ASC, $method_data);

			$this->session->data['payment_methods'] = $method_data;
		}

		if (!isset($this->session->data['payment_method']) && isset($this->session->data['payment_methods'][$this->config->get($this->_moduleSysName . '_payment_method')])) {
			$this->session->data['payment_method'] = $this->session->data['payment_methods'][$this->config->get($this->_moduleSysName . '_payment_method')];
		}

		$data['payment_method'] = isset($this->session->data['payment_method']) ? $this->session->data['payment_method']['title'] : $this->language->get('button_quick_order');
		$data['payment_code'] = isset($this->session->data['payment_method']) ? $this->session->data['payment_method']['code'] : 'cod';

		if (isset($this->request->post['type'])) {
			$type = $this->request->post['type'];
		} else {
			$type = 'one_product';
		}

		$post_products = array();

		$test_products = !is_array($this->request->post["product_id"]) ? urldecode($this->request->post['product_id']) : $this->request->post['product_id'];

		if (is_array($this->request->post["product_id"]) || $type == 'cart_product') {
			$cart_products = $this->cart->getProducts();
			foreach ($cart_products as $product) {
				$post_products[$product['product_id']] = $product['quantity'];
			}
		} elseif ($this->is_serialized($test_products)) {
			$test_products = @unserialize($test_products);
			$post_products = $test_products;
		} else {
			$post_products[$this->request->post["product_id"]] = $quantity;
		}
		//$this->log(print_r($post_products,true));

		$product_data = array();

		$this->load->model('catalog/product');
		$this->load->model('catalog/category');
		$this->load->model('catalog/manufacturer');
		$products_total = 0;
		$products_total_full = 0;
		foreach ($post_products as $post_product_id => $post_quantity) {

			$product = $this->model_catalog_product->getProduct($post_product_id);

			// Определяем категорию товара для аналитики по е-коммерции
			$categories = $this->model_catalog_product->getCategories($product['product_id']);
			$category_id = 0;
			foreach ($categories as $category) {
				if (!$category_id) {
					$category_id = $category['category_id'];
				}
				if (isset($category['main_category']) && $category['main_category']) {
					$category_id = $category['category_id'];
					break;
				}
			}
			$category = '';
			if ($category_id) {
				$category_info = $this->model_catalog_category->getCategory($category_id);
				while ($category_info) {
					if ($category) {
						$category = $category_info['name'] . " / " . $category;
					} else {
						$category = $category_info['name'];
					}
					$category_info = $this->model_catalog_category->getCategory($category_info['parent_id']);
				}
			}

			// Определяем производителя товара для аналитики по е-коммерции
			$manufacturer = '';
			$manufacturer_info = $this->model_catalog_manufacturer->getManufacturer($product['manufacturer_id']);
			if ($manufacturer_info) {
				$manufacturer = $manufacturer_info['name'];
			}

			$price = $product['special'] ? $product['special'] : $product['price'];

			$bundle_id = isset($product['bundle_id']) ? $product['bundle_id'] : 0;
			$product_data[] = array(
				'product_id' => $product['product_id'],
				'bundle_id' => $bundle_id,
				'name' => $product['name'],
				'model' => $product['model'],
				'sku' => $product['sku'],
				'category' => $category,
				'manufacturer' => $manufacturer,
				'option' => array(),
				'download' => array(),
				'quantity' => $post_quantity,
				'subtract' => $product['subtract'],
				'price' => $price,
				'total' => round($post_quantity * $price, 4),
				'tax' => $this->tax->getTax($price, $product['tax_class_id']),
				'reward' => $product['reward']
			);
			$products_total += round($post_quantity * $price, 4);
			$products_total_full += $post_quantity * $this->tax->calculate($price, $product['tax_class_id'], $this->config->get('config_tax'));
		}
		$data['products'] = $product_data;
		$data['vouchers'] = array();
		$data['totals'] = array();
		$data['comment'] = ""; //$this->request->post['comment'];

		if (isset($this->request->cookie['tracking'])) {
			$data['tracking'] = $this->request->cookie['tracking'];

			// Affiliate
			$this->load->model('account/customer');
			$affiliate_info = $this->model_account_customer->getAffiliateByTracking($this->request->cookie['tracking']);

			if ($affiliate_info) {
				$data['affiliate_id'] = $affiliate_info['customer_id'];
				$data['commission'] = ($data['total']  / 100) * $affiliate_info['commission'];
			} else {
				$data['affiliate_id'] = 0;
				$data['commission'] = 0;
			}

			// Marketing
			$this->load->model('checkout/marketing');

			$marketing_info = $this->model_checkout_marketing->getMarketingByCode($this->request->cookie['tracking']);

			if ($marketing_info) {
				$order_data['marketing_id'] = $marketing_info['marketing_id'];
			} else {
				$order_data['marketing_id'] = 0;
			}
		} else {
			$data['affiliate_id'] = 0;
			$data['commission'] = 0;
			$data['tracking'] = '';
			$data['marketing_id'] = 0;
		}

		$data['language_id'] = $this->config->get('config_language_id');
		$data['currency_id'] = $this->currency->getId($this->session->data['currency']);
		$data['currency_code'] = $this->session->data['currency'];
		$data['currency_value'] = $this->currency->getValue($this->session->data['currency']);
		$data['ip'] = $this->request->server['REMOTE_ADDR'];

		if (!empty($this->request->server['HTTP_X_FORWARDED_FOR'])) {
			$data['forwarded_ip'] = $this->request->server['HTTP_X_FORWARDED_FOR'];
		} elseif (!empty($this->request->server['HTTP_CLIENT_IP'])) {
			$data['forwarded_ip'] = $this->request->server['HTTP_CLIENT_IP'];
		} else {
			$data['forwarded_ip'] = '';
		}

		if (isset($this->request->server['HTTP_USER_AGENT'])) {
			$data['user_agent'] = $this->request->server['HTTP_USER_AGENT'];
		} else {
			$data['user_agent'] = '';
		}

		if (isset($this->request->server['HTTP_ACCEPT_LANGUAGE'])) {
			$data['accept_language'] = $this->request->server['HTTP_ACCEPT_LANGUAGE'];
		} else {
			$data['accept_language'] = '';
		}

		$this->load->model('checkout/order');

		/* NeoSeo Order Referrer - begin */
		if (!isset($this->request->cookie['first_referrer'])) {
			$data['first_referrer'] = 'Direct';
		} else {
			$data['first_referrer'] = $this->request->cookie['first_referrer'];
		}
		if (!isset($this->request->cookie['last_referrer'])) {
			$data['last_referrer'] = 'Direct';
		} else {
			$data['last_referrer'] = $this->request->cookie['last_referrer'];
		}
		/* NeoSeo Order Referrer - end */

		$this->load->model('setting/extension');

		$sort_order = array();

		$total_data = array();
		$total = 0;

		$taxes = $this->cart->getTaxes();

		$results = $this->model_setting_extension->getExtensions('total');

		foreach ($results as $key => $value) {
			$sort_order[$key] = $this->config->get('total_' . $value['code'] . '_sort_order');
		}

		array_multisort($sort_order, SORT_ASC, $results);

		foreach ($results as $result) {
			if ($this->config->get('total_' . $result['code'] . '_status')) {

				if ($result['code'] == "sub_total") {
					// Иммитируем работу модуля предварительный итог,
					// потому что там начальное значение суммы берется из корзины,
					// а ее мы перетирать отработкой быстрого заказа не имеем права
					$sub_total = $products_total;

					$this->load->language('extension/total/sub_total');
					$total_data[] = array(
						'code' => 'sub_total',
						'title' => $this->language->get('text_sub_total'),
						'value' => $sub_total,
						'sort_order' => $this->config->get('sub_total_sort_order')
					);

					$total += $sub_total;
				} else {
					$this->load->model('extension/total/' . $result['code']);

					$this->{'model_extension_total_' . $result['code']}->getTotal(array("totals" => $total_data, "total" => $total, "taxes" => $taxes));
				}
			}
		}

		$sort_order = array();

		foreach ($total_data as $key => $value) {
			$sort_order[$key] = $value['sort_order'];
		}

		array_multisort($sort_order, SORT_ASC, $total_data);

		$data['totals'] = $total_data;
		$data['total'] = $products_total_full;
		$data['email'] = '@';
		$data['marketing_id'] = 0;
		$data["order_id"] = $this->model_checkout_order->addOrder($data);
		$this->model_checkout_order->addOrderHistory($data["order_id"], $this->config->get($this->_moduleSysName . '_order_status_id'));

		$data = array_merge($data, $this->load->language("extension/module/" . $this->_moduleSysName));

		$params = array(
			"{id}" => $data["order_id"],
		);
		//Определяем язык
		$language_id = $this->config->get('config_language_id');

		$text_complete = $this->config->get($this->_moduleSysName . "_text_complete");
		if (!isset($text_complete[$language_id])) {
			$text_complete = '';
		}

		$text = $text_complete[$language_id];
		$data["order_complete"] = html_entity_decode(str_replace(array_keys($params), array_values($params), $text));

		$json['result'] = "true";
		$json['order_id'] = $data["order_id"];
		$data['order_id'] = $data["order_id"];
		if ($this->config->get($this->_moduleSysName . "_ecommerce")) {
			$json['order_data'] = $data;
		}
		$json["popup"] = $this->load->view('extension/module/' . $this->_moduleSysName . '_finish', $data);

		$this->response->setOutput(json_encode($json));
	}

	public function is_serialized($value, &$result = null)
	{
		// Bit of a give away this one
		if (!is_string($value)) {
			return false;
		}
		// Serialized false, return true. unserialize() returns false on an
		// invalid string or it could return false if the string is serialized
		// false, eliminate that possibility.
		if ($value === 'b:0;') {
			$result = false;
			return true;
		}
		$length = strlen($value);
		$end = '';
		switch ($value[0]) {
			case 's':
				if ($value[$length - 2] !== '"') {
					return false;
				}
			case 'b':
			case 'i':
			case 'd':
				// This looks odd but it is quicker than isset()ing
				$end .= ';';
			case 'a':
			case 'O':
				$end .= '}';
				if ($value[1] !== ':') {
					return false;
				}
				switch ($value[2]) {
					case 0:
					case 1:
					case 2:
					case 3:
					case 4:
					case 5:
					case 6:
					case 7:
					case 8:
					case 9:
						break;
					default:
						return false;
				}
			case 'N':
				$end .= ';';
				if ($value[$length - 1] !== $end[0]) {
					return false;
				}
				break;
			default:
				return false;
		}
		if (($result = @unserialize($value)) === false) {
			$result = null;
			return false;
		}
		return true;
	}

	public function checkMinAmount($price, $type_quick_order)
	{
		$this->load->language('extension/module/' . $this->_moduleSysName);
		$data = array();
		$data['text_min_amount'] = $this->language->get('text_min_amount');
		$data['error'] = false;
		$min_amount = $this->config->get($this->_moduleSysName . "_min_amount");
		if (!isset($min_amount)) {
			$min_amount = 0;
		}
		$min_amount_value = $min_amount;

		$current_currency = $this->session->data['currency'];
		$config_currency = $this->config->get('config_currency');

		if ($config_currency != $current_currency) {
			$min_amount = $this->currency->convert($min_amount, $config_currency, $current_currency);
			if ($type_quick_order == 'cart_product') {
				$price = $this->currency->convert($price, $config_currency, $current_currency);
			}
		}
		$data['price'] = $price;
		if ($min_amount > 0 && $price < $min_amount) {
			$data['error'] = true;
		}
		$data['min_amount'] = $this->currency->format($min_amount_value, $this->session->data['currency']);
		return $data;
	}

	public function checkMinAmountProduct()
	{
		$json = array();
		if (!isset($this->request->post['price'])) {
			$this->response->setOutput(json_encode($json));
			return;
		}
		$price = $this->request->post['price'];
		$json = $this->checkMinAmount($price, 'one_product');
		$this->response->setOutput(json_encode($json));
	}

	public function dataCheckMinAmountCart()
	{
		$data = array();
		$price = $this->cart->getTotal();
		$data = $this->checkMinAmount($price, 'cart_product');
		return $data;
	}

	public function jsonCheckMinAmountCart()
	{
		$json = array();
		$price = $this->cart->getTotal();
		$json = $this->checkMinAmount($price, 'cart_product');
		$this->response->setOutput(json_encode($json));
	}

	public function checkOrderRestriction()
	{
		$json = array();
		$this->load->language("extension/module/" . $this->_moduleSysName);
		$restriction = $this->config->get($this->_moduleSysName . "_fast_order_restriction");
		$restriction_count = $this->config->get($this->_moduleSysName . "_fast_order_restriction_count");
		if ($restriction) {
			$count_query = $this->db->query("SELECT count(ip) as orders FROM `" . DB_PREFIX . "order` WHERE ip = '" . $this->request->server['REMOTE_ADDR'] . "' AND date_added >= '" . date('Y-m-d H:i:s', strtotime("-5 min")) . "'");
			if ($count_query->num_rows) {
				if (intval($count_query->row['orders']) > $restriction_count) {
					$json['error']['error_orders_limit'] = $this->language->get("text_orders_limit");
				}
			}
		}
		if (count($this->request->post) == 0) {
			$this->response->setOutput(json_encode($json));
		} else {
			return $json;
		}
	}

}
