function FirestoreSlideshow(target, options) {

    const slideShow = $(target).find('.firestore-slider-wrapper');
    let interval;
    let dots = null;

    if (undefined !== options.dots) {
        dots = $(options.dots);

    }

    if (null === options.items) {
        console.log('Не выбрано количество Items в Options');
        return;
    }

    let slideShowItemsBox = document.createElement('div');

    let itemsLength = Math.ceil(slideShow.children().length / options.items)

    const isPortable = () => {
        return /Android|webOS|iPhone|iPad|iPod|BlackBerry|BB|PlayBook|IEMobile|Windows Phone|Kindle|Silk|Opera Mini/i.test(navigator.userAgent);
    }

    const appendChild = () => {
        let counter = 0;
        let y = 0;

        slideShow.children().each(function (index, element) {

            if (options.items === counter) {
                y++;
                counter = 0;
            }

            if (undefined === slideShowItemsBox.children[y]) {
                return false;
            }

            if (undefined !== options.margin && options.items > 1) {
                if (undefined !== options.mode && options.mode === 'vertical') {
                    element.setAttribute( 'style',  'margin-bottom: ' + options.margin + 'px;');
                } else {
                    element.setAttribute( 'style',  'width: ' + 100 / options.items + '%; margin-right: ' + options.margin + 'px;');

                }
            } else {
                element.style.width = (100 / options.items) + '%';
            }

            slideShowItemsBox.children[y].append(element);
            counter++;
        });

    }

    const createItems = () => {

        for (let i = 0; i < itemsLength; i++) {

            let slideShowItem = document.createElement('div');
            slideShowItem.setAttribute('class', 'firestore-slider-item');
            if (!i)  {
                slideShowItem.setAttribute('style', 'display: block;');
                slideShowItem.classList.add('active');
            } else {
                slideShowItem.setAttribute('style', 'display: none;');
            }


            slideShowItemsBox.append(slideShowItem);


        }

        appendChild();
    }


    const slideToggle = () => {
        slideShow.find('.firestore-slider-item.active').fadeIn();
        slideShow.find('.firestore-slider-item:not(.active)').fadeOut();
    }

    const toggleSlidePrev = () => {
        if (slideShow.find('.firestore-slider-item.active').prev('.firestore-slider-item').length) {
            slideShow.find('.firestore-slider-item.active').prev('.firestore-slider-item').addClass('active');
            slideShow.find('.firestore-slider-item.active').next('.firestore-slider-item').removeClass('active');
        } else {
            slideShow.find('.firestore-slider-item').removeClass('active');
            slideShow.find('.firestore-slider-item').eq(-1).addClass('active');
        }

        if (null !== dots) {
            dotsToggle('prev');
        }

        slideToggle();
    }

    const toggleSlideNext = () => {
        if (slideShow.find('.firestore-slider-item.active').next('.firestore-slider-item').length) {
            slideShow.find('.firestore-slider-item.active').next('.firestore-slider-item').addClass('active');
            slideShow.find('.firestore-slider-item.active').prev('.firestore-slider-item').removeClass('active');
        } else {
            slideShow.find('.firestore-slider-item').removeClass('active');
            slideShow.find('.firestore-slider-item').eq(0).addClass('active');
        }

        if (null !== dots) {
            dotsToggle('next');
        }

        slideToggle();


    }

    const dotsToggle = (action) => {

        if ('prev' === action) {
            if ($(dots).children('.dot.active').prev('.dot').length) {
                $(dots).children('.dot.active').prev('.dot').addClass('active');
                $(dots).children('.dot.active').next('.dot').removeClass('active');
            } else {
                $(dots).children('.dot').removeClass('active');
                $(dots).children('.dot').eq(-1).addClass('active');
            }
        }

        if ('next' === action) {
            if ($(dots).children('.dot.active').next('.dot').length) {
                $(dots).children('.dot.active').next('.dot').addClass('active');
                $(dots).children('.dot.active').prev('.dot').removeClass('active');
            } else {
                $(dots).children('.dot').removeClass('active');
                $(dots).children('.dot').eq(0).addClass('active');
            }
        }

    }

    const slideshowRun = () => {

        if (undefined !== options.autoplay && options.autoplay) {
            interval = setInterval(() => {
                toggleSlideNext();
            }, options.interval)
        }

    }

    const swipeActions = () => {

        if (isPortable()) {

            let startX = 0;
            let endX = 0;

            slideShow.on('touchstart', function (e) {
                startX = e.changedTouches[0].pageX;
            });

            slideShow.on('touchend', function (e) {
                endX = e.changedTouches[0].pageX;
                if (endX > startX) {
                    toggleSlidePrev();
                } else if (endX < startX) {
                    toggleSlideNext();
                }
            });

        }

        return false;
    }

    const init = () => {
        swipeActions();
        createItems();
        slideShow.append(slideShowItemsBox.children);

        if (null !== dots && options.items) {

            for (let i = 0; i < slideShow.find('.firestore-slider-item').length; i++) {

                (!i)
                    ? $(dots).append('<span class="dot active"></span>')
                    : $(dots).append('<span class="dot"></span>');

            }

            $(dots).children('.dot').on('click', function () {
                $(dots).children('.dot').removeClass('active');
                $(this).addClass('active');
                if (!slideShow.find('.firestore-slider-item').eq($(this).index()).hasClass('active')) {
                    slideShow.find('.firestore-slider-item').removeClass('active');
                    slideShow.find('.firestore-slider-item').eq($(this).index()).addClass('active');
                    slideToggle();
                }

            });

        }



    }

    slideshowRun();

    $(target).find(options.btnPrev).on('click', () => {
        clearInterval(interval);
        toggleSlidePrev();

        slideshowRun();

    });

    $(target).find(options.btnNext).on('click', () => {
        clearInterval(interval);
        toggleSlideNext();

        slideshowRun();

    });

    init();

}
