<?php
/**
 * @package		OpenCart
 * @author		Daniel Kerr
 * @copyright	Copyright (c) 2005 - 2017, OpenCart, Ltd. (https://www.opencart.com/)
 * @license		https://opensource.org/licenses/GPL-3.0
 * @link		https://www.opencart.com
*/

/**
* Document class
*/
class Document {
	private $title;

	/* NeoSeo Layout Cache begin */
	private $collecting = false;
	private $collected_data = array();
	/* NeoSeo Layout Cache end */
	private $description;
	private $keywords;
	/* NeoSeo Filter - start */
	private $noindex = false;
	/* NeoSeo Filter - end */

	private $links = array();
	private $styles = array();
	private $scripts = array();

	/**
     * 
     *
     * @param	string	$title
     */
	/* NeoSeo Filter - start */
	public function nsf_setLinks($links) {
		$this->links = $links;
	}

	public function nsf_setNoindex($state = false) {
		$this->noindex = $state;
	}

	public function nsf_isNoindex() {
		return $this->noindex;
	}
	/* NeoSeo Filter - end */

	/* NeoSeo Firestore BEGIN */
	public function clearScripts($position='header')
	{
		$this->scripts[$position] = array();
	}

	public function clearStyles()
	{
		$this->styles = array();
	}
	/* NeoSeo Firestore END */

		/* NeoSeo Layout Cache begin */
	public function startCollectDataForCache()
	{
		$this->collecting = true;
		$this->collected_data = array();
	}

	public function stopCollectAndSave()
	{
		$this->collecting = false;
		return $this->collected_data;
	}

	public function restoreDataFromCache($restored_data)
	{
		if(is_array($restored_data)){
			if(isset($restored_data['scripts'])){
				foreach ($restored_data['scripts'] as $script){
					$this->scripts[$script['position']][$script['href']] = $script['href'];
				}
			}
			if(isset($restored_data['styles'])){
				foreach ($restored_data['styles'] as $style){
					$this->styles[$style['href']] = array(
						'href'  => $style['href'],
						'rel'   => $style['rel'],
						'media' => $style['media'],
					);
				}
			}
			if(isset($restored_data['link'])){
				foreach ($restored_data['link'] as $link){
					$this->links[$link['href']] = array(
						'href' => $link['href'],
						'rel'  => $link['rel'],
					);
				}
			}
		}
	}
		/* NeoSeo Layout Cache end */

	public function setTitle($title) {
		$this->title = $title;
	}

	/**
     * 
	 * 
	 * @return	string
     */
	public function getTitle() {
		return $this->title;
	}

	/**
     * 
     *
     * @param	string	$description
     */
	public function setDescription($description) {
		$this->description = $description;
	}

	/**
     * 
     *
     * @param	string	$description
	 * 
	 * @return	string
     */
	public function getDescription() {
		return $this->description;
	}

	/**
     * 
     *
     * @param	string	$keywords
     */
	public function setKeywords($keywords) {
		$this->keywords = $keywords;
	}

	/**
     *
	 * 
	 * @return	string
     */
	public function getKeywords() {
		return $this->keywords;
	}
	
	/**
     * 
     *
     * @param	string	$href
	 * @param	string	$rel
     */
	public function addLink($href, $rel) {

	/* NeoSeo Layout Cache begin */
		if($this->collecting){
			$this->collected_data['link'][$href] = array(
				'href' => $href,
				'rel'  => $rel
			);
		}
	/* NeoSeo Layout Cache end */
		$this->links[$href] = array(
			'href' => $href,
			'rel'  => $rel
		);
	}

	/**
     * 
	 * 
	 * @return	array
     */
	public function getLinks() {
		return $this->links;
	}

	/**
     * 
     *
     * @param	string	$href
	 * @param	string	$rel
	 * @param	string	$media
     */
	public function addStyle($href, $rel = 'stylesheet', $media = 'screen', $position = 'header') {

	/* NeoSeo Layout Cache begin */
		if($this->collecting){
			$this->collected_data['styles'][$href] = array(
				'href'  => $href,
				'rel'   => $rel,
				'media' => $media
			);
		}
	/* NeoSeo Layout Cache end */
		$this->styles[$position][$href] = array(
			'href'  => $href,
			'rel'   => $rel,
			'media' => $media
		);
	}

	/**
     * 
	 * 
	 * @return	array
     */
	public function getStyles($position = 'header') {
		if (isset($this->styles[$position])) {
			return $this->styles[$position];
		} else {
			return array();
		}
	}

	/**
     * 
     *
     * @param	string	$href
	 * @param	string	$position
     */
	public function addScript($href, $position = 'header') {

	/* NeoSeo Layout Cache begin */
		if($this->collecting){
			$this->collected_data['scripts'][] = ['position' => $position,'href' => $href];
		}
	/* NeoSeo Layout Cache end */
		$this->scripts[$position][$href] = $href;
	}

	/**
     * 
     *
     * @param	string	$position
	 * 
	 * @return	array
     */
	public function getScripts($position = 'header') {
		if (isset($this->scripts[$position])) {
			return $this->scripts[$position];
		} else {
			return array();
		}
	}
}